// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.6 $
#include "hk_kdespinbox.h"
#include <hk_string.h>
#include <hk_class.h>
#include <qvalidator.h>

class hk_kdespinboxvalidator :public QValidator
{
    public:
        hk_kdespinbox* p_spinbox;

        hk_kdespinboxvalidator(hk_kdespinbox* s):QValidator(s)
        {
            p_spinbox=s;
            p_ivalidator =new QIntValidator(this);

        }
        ~hk_kdespinboxvalidator()
        {
            delete p_ivalidator;
        }

        virtual QValidator::State validate(QString& val,int& ) const
        {
            if (p_spinbox->displaytype()!=hk_kdespinbox::standard)
            {
                QString suffix=p_spinbox->suffix();
		int f=suffix.find(" ");
		if (f>-1) suffix.remove(f,1);
		 f=val.find(suffix);
                if (f>-1) val.remove(f,p_spinbox->suffix().length());

            }
            QString v=val;
            int f=v.find('.');
            if (f>-1)
            {
                v.remove(f,1);
            }
            int p=0;
            return p_ivalidator->validate(v,p);

        }

    protected:

    private:
        QIntValidator*    p_ivalidator;

};

hk_kdespinbox::hk_kdespinbox(QWidget* parent, const char* name): QSpinBox(parent,name)
{

    init();
}


hk_kdespinbox::hk_kdespinbox(int minValue, int maxValue, int step,QWidget* parent,const char* name)
: QSpinBox(minValue,maxValue,step,parent,name)
{
    init();
}


hk_kdespinbox::~hk_kdespinbox()
{

    delete p_validator;
}


void hk_kdespinbox::init(void)
{

    set_displaytype(percent);
    setMaxValue(10000);
    setMinValue(0);
    setLineStep(10);
    p_validator=new hk_kdespinboxvalidator(this);
    setValidator(p_validator);
}


QString hk_kdespinbox::mapValueToText(int value)
{
    if (p_displaytype==percent|| p_displaytype==cm)   return QString("%1.%2").arg(value/100).arg(value % 100);
    return QSpinBox::mapValueToText(value);

}


int hk_kdespinbox::mapTextToValue(bool* s)
{
    if (p_displaytype!=percent&&p_displaytype!=cm) return QSpinBox::mapTextToValue(s);

    hk_string txt=cleanText().local8Bit().data();
    double n=standardstring2double(txt);
    return (int) (100 * n+0.5);
}


void hk_kdespinbox::set_displaytype(enum_displaytype d)
{
    p_displaytype=d;
    QString s;
    switch (p_displaytype)
    {
     case percent : s=" %";break;
     case pixels  : s=" px";break;
     case cm  : hk_class::measuresystem()==hk_class::cm?s=" cm":s=" inch";break;
     default:;
    }
    setSuffix(s);
}


hk_kdespinbox::enum_displaytype hk_kdespinbox::displaytype(void)
{
    return p_displaytype;
}
