// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.10 $
#include "knodamaindockwindow.h"
#include "hk_kdeform.h"
#include "hk_kdetable.h"
#include "hk_kdequery.h"
#include "hk_kdereport.h"
#include "hk_kdedblistview.h"
#include "hk_kdecsvimportdialog.h"
#include "hk_kdecsvexportdialog.h"
#include "hk_kdexmlexportdialog.h"
#include "hk_kdedatabasesetting.h"
#include "hk_kdeobjecthandler.h"

#include <hk_connection.h>

#include <qlayout.h>
#include <qclipboard.h>
#include <qtoolbutton.h>
#include <kcombobox.h>

knodamaindockwindow::knodamaindockwindow(
        hk_connection* c,
 	QWidget* parent,const char* name, WFlags f,
	const QString& dbname,const QString& form):knodamaindockwindowbase(c,parent,name,f)
{
  connect(p_listview,SIGNAL(currentChanged(QListViewItem*)),this,SLOT(slot_selection_changed()));
  clipboarddata_has_changed();
  
  if (!dbname.isEmpty())
   {
      int c=p_databasecombobox->count();
      int count=0;
      bool found=false;      
      while (count<c && !found)
      {
       QString s=p_databasecombobox->text(count);
       if (!s.isEmpty())
        {
	   if (s==dbname) 
	   {
	    p_databasecombobox->setCurrentItem(count);
	    slot_database_selected(count);
	    found=true;
	   }
	}
       ++count;
      }
   if (!form.isEmpty())
   {
   slot_viewmode_form(form);
   
   }
      
   }
   slot_selection_changed();

}	

knodamaindockwindow::~knodamaindockwindow()
{
}

void knodamaindockwindow::slot_childClosed(QWidget* w)
{
 
 if (!w) 
 {
   cerr<<"knodamaindockwindow::slot_childClosed\nWARNING! w==NULL"<<endl;
   return;
 }
 KMdiChildView* v=dynamic_cast<KMdiChildView*>(w->parent());
 if (!v)
   {
    cerr <<"knodamaindockwindow::slot_childClosed\nWARNING! parent is not a KMdiChildView!"<<endl;
    return;
   }
    p_windowlist.remove(w);
 v->activate();
 closeWindow(v);
}
  
 void knodamaindockwindow::slot_childClosed(KMdiChildView* c)
 {
  QValueList<QWidget*>::iterator it=p_windowlist.begin();
  while (it!=p_windowlist.end())
  {
   QWidget* w=*it;
    if (w->parentWidget()==c)
    {
      slot_childClosed(w);
      return;
    }
   ++it;
  }

 }
  

  void knodamaindockwindow::slot_new_database(void)
  {
    if (!p_connection->server_supports(hk_connection::SUPPORTS_NEW_DATABASE)) 
        return;
        hk_string r=show_stringvaluedialog(hk_translate("New database:"));
	r=trim(r);
        if (r.size()>0)
        {
            if (!p_connection->create_database(r))
	    {
	      show_warningmessage(hk_translate("Database could not be created"));
	    }
	    set_databases();
        }
  }
  
  void knodamaindockwindow::slot_delete_database(const QString& t)
  {
    if (!p_connection->server_supports(hk_connection::SUPPORTS_DELETE_DATABASE)) 
        return;
    if (p_connection->delete_database(t.local8Bit().data()))
    set_databases();
  }
  
  
  void knodamaindockwindow::slot_new_table(void)
  {
   hk_kdetable* o=new_table();
   hk_datasource* d=p_database->new_table();
   o->set_datasource(d);
   o->set_designmode();
  }
  
  void knodamaindockwindow::slot_delete_table(const QString& t)
  {
   p_database->delete_table(t.local8Bit().data());

  }
  
  void knodamaindockwindow::slot_designmode_table(const QString& t)
  {
   
   hk_kdetable* o=new_table();
   hk_datasource* d=p_database->new_table();
   d->set_name(t.local8Bit().data());
   o->set_datasource(d);
   o->set_designmode();
  
  }
 
  
  void knodamaindockwindow::slot_viewmode_table(const QString& t)
  {
   
   hk_kdetable* o=new_table();
   hk_datasource* d=p_database->new_table();
   d->set_name(t.local8Bit().data());
   o->set_datasource(d);
   o->set_viewmode();
  
  }

  
  
  void knodamaindockwindow::slot_new_query(void)
  {
   hk_kdequery* o=new_query();
   hk_datasource* d=p_database->new_resultquery();
   o->set_datasource(d);
   o->set_designmode();
  
  }
  
  void knodamaindockwindow::slot_delete_query(const QString& t)
  {
     p_database->delete_file(t.local8Bit().data(),ft_query);
  }
  
  void knodamaindockwindow::slot_designmode_query(const QString&t)
  {
   hk_kdequery* o=new_query();
   hk_datasource* d=p_database->new_resultquery();
   d->set_name(t.local8Bit().data());
   o->set_datasource(d);
   o->load_query();
   o->set_designmode();
}
  void knodamaindockwindow::slot_viewmode_query(const QString&t)
  {
   hk_kdequery* o=new_query();
   hk_datasource* d=p_database->new_resultquery();
   d->set_name(t.local8Bit().data());
   o->set_datasource(d);
   o->load_query();
   o->set_viewmode();
}

  void knodamaindockwindow::slot_new_form(void)
  {
    hk_kdeform* w=new_form();
    w->set_database(p_database);
    w->set_designmode();
 }
  
  void knodamaindockwindow::slot_delete_form(const QString& t)
  {
      p_database->delete_file(t.local8Bit().data(),ft_form);
  }
  
  void knodamaindockwindow::slot_designmode_form(const QString& t)
 {
    hk_kdeform* w=new_form();
    w->set_database(p_database);
    w->load_form(t.local8Bit().data());
    w->set_designmode();
}
  void knodamaindockwindow::slot_viewmode_form(const QString& t)
 {
    hk_kdeform* w=new_form();
    w->set_database(p_database);
    w->load_form(t.local8Bit().data());
    w->set_viewmode();
}

  void knodamaindockwindow::slot_new_report(void)
  {
    hk_kdereport* w=new_report();
    w->set_database(p_database);
    w->set_designmode();
  }
  
  void knodamaindockwindow::slot_delete_report(const QString& t)
  {
      p_database->delete_file(t.local8Bit().data(),ft_report);

  }
  
  
  void knodamaindockwindow::slot_designmode_report(const QString&t)
  {
     hk_kdereport* w=new_report();
     w->set_database(p_database);
     w->load_report(t.local8Bit().data());
     w->set_designmode();
  
  }
  
  void knodamaindockwindow::slot_viewmode_report(const QString& t)
  {
     hk_kdereport* w=new_report();
     w->set_database(p_database);
     w->load_report(t.local8Bit().data());
     w->set_viewmode();

  }

  
  
  
  
  hk_kdetable* knodamaindockwindow::new_table(void)
  {
   KMdiChildView* dock=new KMdiChildView("Table",(mdiMode()==KMdi::ToplevelMode)?0L:this);
   (new QHBoxLayout(dock))->setAutoAdd(true);
   hk_kdetable* o=new hk_kdetable(dock,0L,WDestructiveClose);
   o->set_autoclose(true);
   connect(o,SIGNAL(signal_closed(QWidget*))
          ,this,SLOT(slot_childClosed(QWidget*)));
   connect(dock,SIGNAL(childWindowCloseRequest(KMdiChildView*))
          ,this,SLOT(slot_childClosed(KMdiChildView*)));
   
   
   p_windowlist.append(o);
   addWindow(dock);
   
   return o;
  
  }
  
  hk_kdequery* knodamaindockwindow::new_query(void)
  {
   KMdiChildView* dock=new KMdiChildView("Query",(mdiMode()==KMdi::ToplevelMode)?0L:this);
   (new QHBoxLayout(dock))->setAutoAdd(true);
   hk_kdequery* o=new hk_kdequery(dock,0L,WDestructiveClose);
   o->set_autoclose(true);
   connect(o,SIGNAL(signal_closed(QWidget*))
          ,this,SLOT(slot_childClosed(QWidget*)));
   
   
   p_windowlist.append(o);
   addWindow(dock);
   
   return o;
  
  }
  
  
    hk_kdeform* knodamaindockwindow::new_form(void)
  {
   KMdiChildView* dock=new KMdiChildView("Form",(mdiMode()==KMdi::ToplevelMode)?0L:this);
   (new QHBoxLayout(dock))->setAutoAdd(true);
   hk_kdeform* o=new hk_kdeform(dock,0L,WDestructiveClose);
   o->set_autoclose(true);
   connect(o,SIGNAL(signal_closed(QWidget*))
          ,this,SLOT(slot_childClosed(QWidget*)));
   
   
   p_windowlist.append(o);
   addWindow(dock);
   
   return o;
  
  }
  
  hk_kdereport* knodamaindockwindow::new_report(void)
  {
   KMdiChildView* dock=new KMdiChildView("Report",(mdiMode()==KMdi::ToplevelMode)?0L:this);
   (new QHBoxLayout(dock))->setAutoAdd(true);
   hk_kdereport* o=new hk_kdereport(dock,0L,WDestructiveClose);
   //o->set_autoclose(true);
   connect(o,SIGNAL(signal_closed(QWidget*))
          ,this,SLOT(slot_childClosed(QWidget*)));
   
   p_windowlist.append(o);
   addWindow(dock);
   
   return o;
  
  }
  

void knodamaindockwindow::rename_clicked()
{
if (!p_listview->currentItem()||p_listview->is_headeritem())
return;



hk_string newname=trim(show_stringvaluedialog(hk_translate("Enter new name:")));
if (newname.size()==0) return;
    filetype f;
    if (p_listview->is_tableitem())
       f=ft_table;
    else
    if (p_listview->is_queryitem())
       f=ft_query;
    else
    if (p_listview->is_formitem())
       f=ft_form;
    else
       f=ft_report;


    if (!p_database->rename_file(p_listview->currentItem()->text(0).local8Bit().data()
    ,newname,f))
    show_warningmessage(hk_translate("Could not rename object!"));
    
}

void knodamaindockwindow::importcsv_clicked()
{
    if (p_database==NULL) return;
    hk_kdecsvimportdialog* i= new hk_kdecsvimportdialog(0,0,true);
    hk_datasource* ds=p_database->new_table();
//   ds->wanna_debug(true);
    i->set_datasource(ds);
    i->exec();
    delete i;
}

void knodamaindockwindow::exportcsv_clicked()
{
    if (p_database==NULL) return;
    hk_kdecsvexportdialog* e =new hk_kdecsvexportdialog(p_listview->currentItem()->text(0),0,0,true);
    e->set_database(p_database);
    e->set_usetablelist(p_listview->is_tableitem());
    e->exec();
    delete e;
}

void knodamaindockwindow::exportxml_clicked()
{
    if (p_database==NULL) return;
    hk_kdexmlexportdialog* e =new hk_kdexmlexportdialog(p_listview->currentItem()->text(0),0,0,true);
    e->set_database(p_database);
    e->set_usetablelist(p_listview->is_tableitem());
    e->exec();
    delete e;
}

void knodamaindockwindow::newpassworddialog_selected(void)
{
    if (p_connection!=NULL) p_connection->show_newpassworddialog();
}

void knodamaindockwindow::copy_clicked(void)
{
p_listview->copy();
}

void knodamaindockwindow::paste_clicked(void)
{
p_listview->paste();
}

void knodamaindockwindow::clipboarddata_has_changed(void)
{
 p_copyaction->setEnabled(!p_listview->is_headeritem()
                        ||p_listview->is_databaseitem());
 p_pasteaction->setEnabled(hk_dbviewerdrag::canDecode(QApplication::clipboard()->data(QClipboard::Clipboard)));
}

void knodamaindockwindow::slot_selection_changed(void)
{  
 p_newaction->setEnabled(!runtime_only()
 && p_database&& p_database->name().size()>0&& (p_listview->is_databaseitem()&&p_connection->server_supports(hk_connection::SUPPORTS_NEW_DATABASE)
 ||p_listview->is_tableitem(true)&&p_connection->server_supports(hk_connection::SUPPORTS_NEW_TABLE) 
 ||p_listview->is_queryitem(true)||p_listview->is_formitem(true)||p_listview->is_reportitem(true)
 ));
 newbutton->setEnabled(p_newaction->isEnabled());
 bool e=!runtime_only() && p_database&& p_database->name().size()>0;
 p_newdatabaseaction->setEnabled(!runtime_only()&&p_connection->server_supports(hk_connection::SUPPORTS_NEW_DATABASE));
 p_newtableaction->setEnabled(e&&p_connection->server_supports(hk_connection::SUPPORTS_NEW_TABLE));
 p_newqueryaction->setEnabled(e);
 p_newformaction->setEnabled(e);
 p_newreportaction->setEnabled(e);

 p_alteraction->setEnabled(!p_listview->is_headeritem() &&!runtime_only()); 
 alterbutton->setEnabled(p_alteraction->isEnabled());
 p_startaction->setEnabled(!p_listview->is_headeritem());
 startbutton->setEnabled(p_startaction->isEnabled());
p_deleteaction->setEnabled((!p_listview->is_headeritem()
 			    || p_listview->is_databaseitem()
 		           ) &&!runtime_only()&&p_database&& p_database->name().size()>0
			   );
 deletebutton->setEnabled(p_deleteaction->isEnabled());
 p_renameaction->setEnabled(
    (p_listview->is_databaseitem() && p_connection->server_supports(hk_connection::SUPPORTS_RENAME_DATABASE)
    ||p_listview->is_tableitem() && p_connection->server_supports(hk_connection::SUPPORTS_RENAME_TABLE)
    ||(p_listview->is_queryitem()||p_listview->is_formitem() ||p_listview->is_reportitem() 
    )&&!runtime_only()
    
    )
 );
 p_exportaction->setEnabled(p_listview->is_tableitem()||p_listview->is_queryitem());
 p_exportcsvaction->setEnabled(p_listview->is_tableitem()||p_listview->is_queryitem());
 p_exportxmlaction->setEnabled(p_listview->is_tableitem()||p_listview->is_queryitem());
 p_importaction->setEnabled(true);
 p_importcsvaction->setEnabled(true);
 p_databasesettingaction->setEnabled(p_database&&!runtime_only());
 p_passwordaction->setEnabled(p_listview->database()!=NULL);
 clipboarddata_has_changed();
}

void knodamaindockwindow::slot_listbox_popup(QListViewItem* item,const QPoint&point)
{
 if (!item) return;
QPopupMenu * popup=(QPopupMenu *) factory()->container("popup", this);
    if (popup)
        popup->exec( point );


}

void knodamaindockwindow::databasesettings_clicked(void)
{
hk_kdedatabasesetting* setting=new hk_kdedatabasesetting(p_database);
 if (setting->exec()==QDialog::Accepted) 
    {
      p_listview->reload_lists();
    }
 p_objecthandleraction->setEnabled(p_database&& p_database->has_centralstoragetable()&&!runtime_only());
delete setting;
}

void knodamaindockwindow::objecthandler_clicked(void) 
{
  hk_kdeobjecthandler* h=new hk_kdeobjecthandler(p_database);
  h->exec();
 
  delete h;
}

