// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.13 $
#include "knodamaindockwindowbase.h"
#include "hk_kdedblistview.h"
#include <hk_connection.h>
#include <hk_dsvisible.h>
#include <hk_database.h>

#include <qpixmap.h>
#include <qclipboard.h>
#include <qtoolbutton.h>

#include <kcombobox.h>
#include <kdockwidget.h>
#include <kmdichildview.h>
#include <kconfig.h>
#include <klocale.h>
#include <kapplication.h>
#include <kaction.h>
#include <kiconloader.h>
#include <kstandarddirs.h>

class knodamaindockwindowbaseprivate
{
  public:
  knodamaindockwindowbaseprivate()
  {
    p_maindockwidget=NULL;
  }
  
KDockWidget*      p_maindockwidget;
QString           p_databasename;
QMainWindow*      p_viewcontainer;
};



knodamaindockwindowbase::knodamaindockwindowbase(hk_connection* c,
 	QWidget* parent,const char* name, WFlags f,
	const QString& /*dbname*/,const QString& /*form*/)
	:KMdiMainFrm(parent,name,KMdi::IDEAlMode,f),
	hk_dsvisible()
{
   p_listview=NULL;
   p_database=NULL;
    p_connection=NULL;
  // setStandardMDIMenuEnabled();
   setXMLFile(locate("data","hk_kdeclasses/knodamaindockwindowbase.rc"));
   KIconLoader* loader=KGlobal::iconLoader();
   loader->addAppDir("hk_kdeclasses");
   resize( 596, 480 );

   QPixmap pixmap;
   p_private=new knodamaindockwindowbaseprivate;
   p_connection=c;
       if (c)
    {
        hk_string s=c->drivername()+" "+c->user()+"@"+c->host()+":"+ulongint2string(c->tcp_port());
        setCaption(QString::fromLocal8Bit(s.c_str()));
    }
   p_private->p_viewcontainer=new QMainWindow(this);
   
   
   
   p_listview=new hk_kdedblistview(p_private->p_viewcontainer);
   
   
   
   QToolBar* toolbar=new QToolBar(p_private->p_viewcontainer);
   newbutton=new QToolButton(loader->loadIcon("filenew",KIcon::Toolbar),i18n("New"),QString::null,
   					 p_listview,SLOT(new_clicked()),toolbar);
   alterbutton=new QToolButton(loader->loadIcon("edit",KIcon::Toolbar),i18n("Modify"),QString::null,
   					 p_listview,SLOT(alter_clicked()),toolbar);
   startbutton=new QToolButton(loader->loadIcon("exec",KIcon::Toolbar),i18n("Start"),QString::null,
   					 p_listview,SLOT(start_clicked()),toolbar);
   deletebutton=new QToolButton(loader->loadIcon("editdelete",KIcon::Toolbar),i18n("Delete"),QString::null,
   					 p_listview,SLOT(delete_clicked()),toolbar);
    
    
    p_private->p_viewcontainer->setCentralWidget(p_listview);
   p_listview->setCaption(i18n("Elements"));
   p_private->p_viewcontainer->setCaption(i18n("Elements"));
   KMdiToolViewAccessor* tool= addToolWindow(p_private->p_viewcontainer,KDockWidget::DockLeft,getMainDockWidget(),90);
   tool->show();
    
   p_closeaction=new KAction(i18n("&Close"),"fileclose",0,this,SLOT(close()),actionCollection(),"quit");
   p_databasecombobox= new KComboBox(0L,"p_databasecombobox");
   p_databasecombobox->setMinimumWidth(200);
   QLabel* label=new QLabel(0L);
   label->setText(i18n("Database: "));
   new KWidgetAction(label,"",0,0,0,actionCollection(),"databaselabel");
   p_databaseaction=new KWidgetAction(p_databasecombobox,i18n("Select database"),0,0,0,actionCollection(),"databaseselect");
   
       
    p_newobjectaction= new KActionMenu(i18n("&New"),0,actionCollection(),"newobject");
    p_newdatabaseaction= new KAction(i18n("Database"),"contents",0,this,SLOT(slot_new_database()),actionCollection(),"newdatabase");
    p_newtableaction= new KAction(i18n("Table"),"viewtext",0,this,SLOT(slot_new_table()),actionCollection(),"newtable");
    p_newqueryaction= new KAction(i18n("Query"),"filefind",0,this,SLOT(slot_new_query()),actionCollection(),"newquery");
    p_newformaction= new KAction(i18n("Form"),"openterm",0,this,SLOT(slot_new_form()),actionCollection(),"newform");
    p_newreportaction= new KAction(i18n("Report"),"fileprint",0,this,SLOT(slot_new_report()),actionCollection(),"newreport");
    p_newobjectaction->insert(p_newdatabaseaction);
    p_newobjectaction->insert(p_newtableaction);
    p_newobjectaction->insert(p_newqueryaction);
    p_newobjectaction->insert(p_newformaction);
    p_newobjectaction->insert(p_newreportaction);
    
    
    p_newaction= new KAction(i18n("&New"),"filenew",0,p_listview,SLOT(new_clicked()),actionCollection(),"newclicked");
    p_newaction->plug(newbutton);
    p_alteraction= new KAction(i18n("&Modify"),"edit",0,p_listview,SLOT(alter_clicked()),actionCollection(),"alterclicked");
    //p_alteraction->plug(toolbar);
    p_startaction= new KAction(i18n("&Start"),"exec",0,p_listview,SLOT(start_clicked()),actionCollection(),"startclicked");
    p_deleteaction= new KAction(i18n("&Delete"),"editdelete",SHIFT+Key_Delete,p_listview,SLOT(delete_clicked()),actionCollection(),"deleteclicked");
    p_renameaction=new KAction(i18n("&Rename"),0,0,this,SLOT(rename_clicked()),actionCollection(),"renameclicked");
    p_alteraction->setEnabled(false);
    p_startaction->setEnabled(false);
    p_deleteaction->setEnabled(false);

    p_exportaction= new KActionMenu(i18n("E&xport"),0,actionCollection(),"export");
    p_exportcsvaction= new KAction(i18n("&CSV"),0,0,this,SLOT(exportcsv_clicked()),actionCollection(),"exportcsv");
    p_exportxmlaction= new KAction(i18n("&XML"),0,0,this,SLOT(exportxml_clicked()),actionCollection(),"exportxml");
    p_exportaction->insert(p_exportcsvaction);
    p_exportaction->insert(p_exportxmlaction);
    p_exportaction->setEnabled(false);
    p_importaction= new KActionMenu(i18n("I&mport"),0,actionCollection(),"import");
    p_importaction->setEnabled(false);
    p_importcsvaction= new KAction(i18n("&CSV"),0,0,this,SLOT(importcsv_clicked()),actionCollection(),"importcsv");
    p_importaction->insert(p_importcsvaction);
    p_passwordaction= new KAction(i18n("&Change password"),0,0,this,SLOT(newpassworddialog_selected()),actionCollection(),"changepassword");
    p_copyaction= new KAction(i18n("&Copy"),"editcopy",SHIFT+CTRL+Key_C,this,SLOT(copy_clicked()),actionCollection(),"copy");
    p_pasteaction= new KAction(i18n("&Paste"),"editpaste",SHIFT+CTRL+Key_V,this,SLOT(paste_clicked()),actionCollection(),"paste");
    p_databasesettingaction= new KAction(i18n("&Database settings"),0,0,this,SLOT(databasesettings_clicked()),actionCollection(),"dbsettings");
    p_objecthandleraction= new KAction(i18n("&Object handler"),0,0,this,SLOT(objecthandler_clicked()),actionCollection(),"objecthandler");
   
   
   
   
   
  connect (QApplication::clipboard(), SIGNAL(dataChanged()),this, SLOT(clipboarddata_has_changed()));

   connect(p_databasecombobox,SIGNAL(activated(int)),this,SLOT(slot_database_selected(int)));
   
   connect(p_listview,SIGNAL(signal_delete_database(const QString&)),this,SLOT(slot_delete_database(const QString&)));
   connect(p_listview,SIGNAL(signal_new_database(void)),this,SLOT(slot_new_database(void)));
   connect(p_listview,SIGNAL(signal_reload_databases(void)),this,SLOT(set_databases(void)));
   
   connect(p_listview,SIGNAL(signal_viewmode_table(const QString&)),this,SLOT(slot_viewmode_table(const QString&)));
   connect(p_listview,SIGNAL(signal_designmode_table(const QString&)),this,SLOT(slot_designmode_table(const QString&)));
   connect(p_listview,SIGNAL(signal_delete_table(const QString&)),this,SLOT(slot_delete_table(const QString&)));
   connect(p_listview,SIGNAL(signal_new_table(void)),this,SLOT(slot_new_table(void)));
   
   connect(p_listview,SIGNAL(signal_viewmode_query(const QString&)),this,SLOT(slot_viewmode_query(const QString&)));
   connect(p_listview,SIGNAL(signal_designmode_query(const QString&)),this,SLOT(slot_designmode_query(const QString&)));
   connect(p_listview,SIGNAL(signal_delete_query(const QString&)),this,SLOT(slot_delete_query(const QString&)));
   connect(p_listview,SIGNAL(signal_new_query(void)),this,SLOT(slot_new_query(void)));
   
   connect(p_listview,SIGNAL(signal_viewmode_form(const QString&)),this,SLOT(slot_viewmode_form(const QString&)));
   connect(p_listview,SIGNAL(signal_designmode_form(const QString&)),this,SLOT(slot_designmode_form(const QString&)));
   connect(p_listview,SIGNAL(signal_delete_form(const QString&)),this,SLOT(slot_delete_form(const QString&)));
   connect(p_listview,SIGNAL(signal_new_form(void)),this,SLOT(slot_new_form(void)));
   
   connect(p_listview,SIGNAL(signal_viewmode_report(const QString&)),this,SLOT(slot_viewmode_report(const QString&)));
   connect(p_listview,SIGNAL(signal_designmode_report(const QString&)),this,SLOT(slot_designmode_report(const QString&)));
   connect(p_listview,SIGNAL(signal_delete_report(const QString&)),this,SLOT(slot_delete_report(const QString&)));
   connect(p_listview,SIGNAL(signal_new_report(void)),this,SLOT(slot_new_report(void)));
   connect(p_listview, SIGNAL(contextMenuRequested(QListViewItem*,const QPoint&, int)),
   this,SLOT(slot_listbox_popup(QListViewItem*,const QPoint&)));
//   createShellGUI(true);
   createGUI(0L);
   set_databases();
   slot_database_selected(0);
   setManagedDockPositionModeEnabled(true);
   KConfig* config=kapp->config();
   applyMainWindowSettings( config, "knodamain" );   
   QString value=config->readEntry("MDIMode","None");
   if (value!="None")
      readDockConfig(config,"knodamaindock");
  p_newobjectaction->setEnabled(!runtime_only());
  p_newaction->setEnabled(!runtime_only());
  p_databasesettingaction->setEnabled(!runtime_only());
  if (p_connection)
  {
        p_newdatabaseaction->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_NEW_DATABASE));
  
  }      
}	


knodamaindockwindowbase::~knodamaindockwindowbase()
{
  delete p_closeaction;
  delete p_databaseaction;
  delete p_private;
}

hk_connection* knodamaindockwindowbase::connection(void)
{
  return p_connection;
}



void knodamaindockwindowbase::closeEvent(QCloseEvent*event)
{
  QValueList<QWidget*>::iterator it=p_windowlist.begin();
  while (it!=p_windowlist.end())
  {
   //QWidget* w=*it;
   p_windowlist.remove((*it));
   it=p_windowlist.begin();
  }
  


KConfig* c=kapp->config();
QString value="ideal";
c->writeEntry("MDIMode",value);
saveMainWindowSettings( c, "knodamain" );
writeDockConfig(c,"knodamaindock");
if (p_database) 
   {
      p_database->disable();
      delete p_database;
   }
p_database=NULL;
KMdiMainFrm::closeEvent(event);
}


void knodamaindockwindowbase::slot_database_selected(int )
{
  QString newdb=p_databasecombobox->currentText();
  if (newdb!=p_private->p_databasename)
  {
    if (!p_database) p_database=p_connection->new_database();
     if (p_database!=NULL)
      {
#ifdef HK_DEBUG
        p_database->hkclassname("knodamaindockwindowbase");
#endif
        if (p_database->set_name(newdb.local8Bit().data()))
            p_private->p_databasename=newdb;
        else p_private->p_databasename="";
            set_datasource(p_database->new_resultquery());
       p_database->set_usewidgetparent(this);
      }
   }
 p_listview->set_database(p_database);
 p_objecthandleraction->setEnabled(p_database&& p_database->has_centralstoragetable()&&!runtime_only());
 
}




void knodamaindockwindowbase::set_databases(void)
{
  QString curtext=p_databasecombobox->currentText();
  p_databasecombobox->clear();
  vector<hk_string>* db=p_connection->dblist();
  vector<hk_string>::iterator it;
  p_databasecombobox->blockSignals(true);
  bool dbfound=false;
  if (db!=NULL)
     {
        int i=0;
        for(it=db->begin();it!=db->end();it++)
          {
            p_databasecombobox->insertItem(QString::fromLocal8Bit((*it).c_str()));
             if (curtext==QString::fromLocal8Bit((*it).c_str()))
               {
                p_databasecombobox->setCurrentItem(i);
		dbfound=true;
               }
            i++;
          }
     }
     if (!dbfound)slot_database_selected(0);

  p_databasecombobox->blockSignals(false);

}

