// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.8 $

//***********************************************
//***  hk_kdegrid PART definition             ***
//***********************************************
#include "hk_kdegridpart.h"
#include "hk_kdegridpartfactory.h"
#include "hk_kdesimpleform.h"
#include "hk_kdesimplegrid.h"
#include <kinstance.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kaction.h>
#include <klocale.h>
#include <kurl.h>
#include <qapplication.h>
#include <qclipboard.h>
#include <hk_drivermanager.h>
#include <hk_connection.h>
#include <hk_database.h>
#include <hk_datasource.h>
#include <hk_class.h>


hk_kdegridpart::hk_kdegridpart(QWidget* pWidget, const char* widgetname,QObject* parent, const char* name, const QStringList &)
:KParts::ReadWritePart(parent,name)
{
    setInstance(hk_kdegridpartfactory::instance());
    hk_kdesimpleform* form=dynamic_cast<hk_kdesimpleform*>(pWidget);
    p_grid = new hk_kdegrid(pWidget,widgetname,0,form);
    p_grid->p_part=this;
    setWidget(p_grid);
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    p_columndialogaction = new KAction(i18n("&Gridcolumns"),loader->loadIcon("grid22x22",KIcon::User),0,this,SLOT(show_gridcolumndialog()),actionCollection(),"gridcolumn");
    p_columndialogaction->setEnabled(!hk_class::runtime_only());
    p_copyaction = new KAction(i18n("&Copy"),"editcopy",CTRL+Key_C,p_grid->simplegrid(),SLOT(copy()),actionCollection(),"copy");
    p_pasteaction = new KAction(i18n("&Paste"),"editpaste",CTRL+Key_V,p_grid->simplegrid(),SLOT(paste()),actionCollection(),"paste");
    p_findaction = new KAction(i18n("&Find in columns"),loader->loadIcon("find",KIcon::User),0,p_grid,SLOT(find_clicked()),actionCollection(),"findcolumn");
     setXMLFile(locate("data","hk_kdeclasses/hk_kdegridpart.rc"));
    p_drivermanager=NULL;
    connect (QApplication::clipboard(), SIGNAL(dataChanged()),this, SLOT(clipboarddata_has_changed()));
clipboarddata_has_changed();
}

hk_kdegridpart::~hk_kdegridpart()
{
  if (p_drivermanager) delete p_drivermanager;

}



void hk_kdegridpart::show_gridcolumndialog(void)
{
    p_grid->simplegrid()->show_gridcolumndialog();
}


void hk_kdegridpart::setReadWrite(bool rw)
{
    KParts::ReadWritePart::setReadWrite(rw);
}


bool hk_kdegridpart::openFile()
{
 // URL handling:   mysql:/user:password@host:port/databasename/datasourcetype/datasourcename
 // where datasourcetype is either tables or queries
    KURL url(m_file);
    if (url.protocol()==QString::null) return false;
    if (!url.hasPath()) return false;
    QString path=url.path();
    QString databasename=path.section('/',0,0);
    if (databasename.length()<1) return false;
    QString dstype=path.section('/',1,1);
    if (dstype!="tables"&&dstype!="queries") return false;
    QString dsname=path.section('/',2,2);
    if (dsname.length()<1) return false;

    
    if (!p_drivermanager) p_drivermanager=new hk_drivermanager;
    hk_connection* con=p_drivermanager->new_connection(url.protocol().local8Bit().data());
    if (!con) return false;
    if (url.hasHost()) con->set_host(url.host().local8Bit().data());
    if (url.port()!=0) con->set_tcp_port(url.port());
    if (url.hasUser()) con->set_user(url.user().local8Bit().data());
    if (url.hasPass()) con->set_password(url.pass().local8Bit().data());
    if (!con->connect())
    {
      delete con;
      return false;
    }  
    hk_database* db= con->new_database(databasename.local8Bit().data());
    hk_datasource* ds=db->load_datasource(dsname.local8Bit().data(),dstype=="queries");
    p_grid->set_datasource(ds);
    if (ds) ds->enable();
    return true;
}


bool hk_kdegridpart::saveFile()
{
    return true;
}


KAboutData* hk_kdegridpart::createAboutData()
{
    KAboutData* a= new KAboutData("hk_kdegridpart", I18N_NOOP("hk_kdegridpart"),
        "0.1", I18N_NOOP("Datasource editor"),
        KAboutData::License_GPL,"(c) 2002-2003, Horst Knorr <hk_classes@knoda.org>");

    return a;

}






void  hk_kdegridpart::clipboarddata_has_changed(void)
{
 /* if (!p_grid->datasource()||p_grid->datasource()->is_readonly())
     {
       p_pasteaction->setEnabled(false);
       return;
     }
    if (!QApplication::clipboard()->data(QClipboard::Clipboard))
    {
        p_pasteaction->setEnabled(false);
        return;
    }

    if (QApplication::clipboard()->data(QClipboard::Clipboard)->provides("text/plain"))
    {
        p_pasteaction->setEnabled(true);
    }
    else
    {

        p_pasteaction->setEnabled(false);
    }*/p_pasteaction->setEnabled(true);
}


