// ****************************************************************************
// copyright (c) 2000-2004 Horst Knorr <hk_classes@knoda.org>  
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************

#include "knodanewdatabasedialog.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <hk_class.h>
#include <klocale.h>

/*
 *  Constructs a knodanewdatabasedialog which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
knodanewdatabasedialog::knodanewdatabasedialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
: QDialog( parent, name, modal, fl )
{
    if ( !name )
        setName( "knodanewdatabasedialog" );
    resize( 282, 96 );
    setCaption( i18n("New Database Dialog"  ) );
    setSizeGripEnabled( TRUE );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)3, sizePolicy().hasHeightForWidth() ) );
    knodanewdatabasedialogLayout = new QVBoxLayout( this );
    knodanewdatabasedialogLayout->setSpacing( 6 );
    knodanewdatabasedialogLayout->setMargin( 11 );

    Layout9 = new QHBoxLayout;
    Layout9->setSpacing( 6 );
    Layout9->setMargin( 0 );

    label = new QLabel( this, "label" );
    label->setText( i18n("Enter name of new database:"  ) );
    label->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, label->sizePolicy().hasHeightForWidth() ) );
    label->setMinimumSize( QSize( 165, 12 ) );
    Layout9->addWidget( label );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout9->addItem( spacer );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setText( i18n("&OK"  ) );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );
    buttonOk->setEnabled( FALSE );
    Layout9->addWidget( buttonOk );
    knodanewdatabasedialogLayout->addLayout( Layout9 );

    Layout8 = new QHBoxLayout;
    Layout8->setSpacing( 6 );
    Layout8->setMargin( 0 );

    databasename = new QLineEdit( this, "databasename" );
    databasename->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)3, (QSizePolicy::SizeType)1, databasename->sizePolicy().hasHeightForWidth() ) );
    databasename->setMinimumSize( QSize( 165, 0 ) );
    databasename->setFocus();
    Layout8->addWidget( databasename );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    Layout8->addItem( spacer_2 );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setText( i18n("&Cancel"  ) );
    buttonCancel->setAutoDefault( TRUE );
    Layout8->addWidget( buttonCancel );
    knodanewdatabasedialogLayout->addLayout( Layout8 );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    knodanewdatabasedialogLayout->addItem( spacer_3 );

// signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( databasename, SIGNAL(  textChanged( const QString & ) ), this, SLOT( enable_okbutton() ) );
}


/*
 *  Destroys the object and frees any allocated resources
 */
knodanewdatabasedialog::~knodanewdatabasedialog()
{
// no need to delete child widgets, Qt does it all for us
}


void knodanewdatabasedialog::enable_okbutton()
{
    buttonOk->setEnabled(!databasename->text().isEmpty());
}
