// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_classes library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
#include "hk_kdedate.h"
#include "hk_kdesimpleform.h"

#include <kapplication.h>
#include <kdatetbl.h>
#include <qdatetime.h>

#include <hk_datetime.h>

hk_kdedate::hk_kdedate(QWidget* wid,hk_form* form):KDatePicker(wid),hk_dsdate(form)
{
p_widget_specific_row_change=false;
    QObject::connect(this,SIGNAL(dateSelected(QDate )),this,SLOT(slot_data_changed()));
    QObject::connect(this,SIGNAL(tableClicked( )),this,SLOT(slot_table_clicked()));

}


void hk_kdedate::resizeEvent ( QResizeEvent * event )
{
#ifdef HK_DEBUG
    hkdebug("hk_kdedate::resizeEvent");
#endif
    KDatePicker::resizeEvent(event);
    reposition();

}


void  hk_kdedate::moveEvent ( QMoveEvent * event)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdedate::resizeEvent");
#endif
    KDatePicker::moveEvent(event);
    reposition();
}



void hk_kdedate::reposition(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdedate::reposition");
#endif
    if (p_presentation==NULL ||p_setcoordinates==true) return;
    p_setwidgetcoordinates=true;
    unsigned int ppx=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QWidget::x()):QWidget::x();
    unsigned int ppy=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QWidget::y()):QWidget::y();
    unsigned int pph=p_presentation->sizetype()==hk_presentation::relative?p_presentation->vertical2relativ(QWidget::height()):QWidget::height();
    unsigned int ppw=p_presentation->sizetype()==hk_presentation::relative?p_presentation->horizontal2relativ(QWidget::width()):QWidget::width();
    set_size(ppx,ppy,ppw,pph);
    p_setwidgetcoordinates=false;
}

bool hk_kdedate::widget_specific_coordinates(uint px,uint py,uint pwidth,uint pheight)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdedate::widget_specific_coordinates");
#endif
    setGeometry(px,py,pwidth,pheight);
    qApp->processEvents();

    return true;
}


bool    hk_kdedate::widget_specific_row_change(void)
{
    hk_column* c=column();
    p_widget_specific_row_change=true;
    if (datasource()!=NULL)
        if (c!=NULL)
    {
        hk_string v=datasource()->mode()==hk_datasource::mode_insertrow?
            use_defaultvalue()?defaultvalue():"":
        (c->has_changed()?c->changed_data_asstring():c->asstring(true));
        hk_datetime dt;
        dt.set_date_asstring(v);
        QDate date(dt.year(),dt.month(),dt.day());

        setDate(date);
    }

    p_widget_specific_row_change=false;
    return true;
}

void   hk_kdedate::widget_specific_enable_disable(void)
{cerr <<"hk_kdedate::widget_specific_enable_disable"<<endl;

    if ((datasource()!=NULL)&&(column()!=NULL))
    {
#ifdef HK_DEBUG
        hkdebug("hk_kdedate::if ((datasource()!=NULL)&&(column()!=NULL))");
#endif

        if (datasource()->is_enabled())
        { cerr <<"setEnabled(true);"<<endl;
	    setEnabled(is_enabled());
            widget_specific_row_change();
        }
       else
       {cerr <<"setEnabled(false);"<<endl;
       setEnabled(false);
       }
    }
    else
    {
cerr <<"Datenquelle nicht gesetzt"<<endl;
        if (p_presentation)
           setEnabled(p_presentation->mode()==hk_presentation::viewmode&& is_enabled());
        else
          setEnabled(is_enabled());
        //blockSignals(true);
        //blockSignals(false);
    }



}


void hk_kdedate::slot_data_changed(void)
{
#ifdef HK_DEBUG
    hkdebug("kdedate::slot_data_changed");
#endif
    if (!p_widget_specific_row_change)
    {
#ifdef HK_DEBUG
        hkdebug("kdedate::data has changed!");
#endif
        if (column()!=NULL)
        {
#ifdef HK_DEBUG
            hkdebug("kdedate::data will be updated");
#endif
	QDate d=KDatePicker::date();
	hk_datetime dt;
	dt.set_date(d.day(),d.month(),d.year());
	column()->set_asstring(dt.date_asstring(),true,true);

        }
    }
}

void hk_kdedate::show_widget(void)
{
  show();
}

void hk_kdedate::hide_widget(void)
{
  hide();
}

void hk_kdedate::close_widget(void)
{
  close();
}

void  hk_kdedate::mousePressEvent(QMouseEvent* event)
{
   KDatePicker::mousePressEvent(event);
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       && event->button()== LeftButton)
           action_on_click();
}



void  hk_kdedate::mouseDoubleClickEvent(QMouseEvent* event)
{
   KDatePicker::mouseDoubleClickEvent(event);
   if (p_presentation && p_presentation->mode()==hk_presentation::viewmode
       && event->button()== LeftButton)
           action_on_doubleclick();
}


void hk_kdedate::focusInEvent ( QFocusEvent * e)
{
  action_on_getfocus();
  KDatePicker::focusInEvent(e);
}

void hk_kdedate::focusOutEvent ( QFocusEvent * e)
{
  action_on_loosefocus();
  KDatePicker::focusOutEvent(e);

}

void hk_kdedate::set_value(const hk_string&v)
{
 hk_column* c=column();
 hk_datetime dt;
 dt.set_date_asstring(v);
        QDate date(dt.year(),dt.month(),dt.day());

 if (c)c->set_asstring(v);
 else         setDate(date);

action_on_valuechanged();
}

hk_string hk_kdedate::value(void)
{
  if (!column())
   {
	QDate d=KDatePicker::date();
	hk_datetime dt;
	dt.set_date(d.day(),d.month(),d.year());
        return dt.date_asstring();
   }
  else return hk_dsdate::value();
}

void hk_kdedate::slot_table_clicked(void)
{
        if (p_presentation && p_presentation->mode()==hk_presentation::viewmode)
        {

        }

}



void hk_kdedate::widget_specific_font_changed(void)
{
    QFont f=QFont(QString::fromUtf8 (l2u(hk_dsdate::font().fontname()).c_str())
                  ,hk_dsdate::font().fontsize(),hk_dsdate::font().bold()?QFont::Bold:QFont::Normal,
		   hk_dsdate::font().italic());
    //setFont(f);
    //KDateTable* p=dateTable();
    //p->setFont(f);
    setFontSize(hk_dsdate::font().fontsize());

}




void    hk_kdedate::widget_specific_backgroundcolour_changed(const hk_colour&)
{
    hk_colour c=backgroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteBackgroundColor(newcolour);

}


void    hk_kdedate::widget_specific_foregroundcolour_changed(const hk_colour&)
{
    hk_colour c=foregroundcolour();
    QColor newcolour(c.red(),c.green(),c.blue());
    setPaletteForegroundColor(newcolour);

}

void hk_kdedate::widget_specific_enabled_changed(void)
{
  setEnabled(is_enabled());
}


bool hk_kdedate::presentationmode_changed()
{
if (!p_presentation)
  {
    setEnabled(is_enabled());
    return hk_dsdate::presentationmode_changed();
  }
bool result=hk_dsdate::presentationmode_changed();
   setEnabled(is_enabled());
  return  result;
}

