// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of knoda -Knorr's Datenbank.
// This file may be distributed and/or modified under the terms of the
// GNU General Public License version 2 as published by the Free Software
// Foundation and appearing in the file COPYING included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.53 $

#include "knodawinbase.h"
#include "knodanewdatabasedialog.h"
#include "knodamaindockwindow.h"
#include "hk_kdeeximportdatabase.h"
#include "hk_kdedbdesigner.h"
#include <kstandarddirs.h>
#include <kglobalsettings.h>
#include <kapplication.h>
#include <kconfig.h>

#include <qbuttongroup.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qdragobject.h>
#include <qevent.h>
#include <qkeycode.h>

#include <qmenubar.h>
#include <qmime.h>
#include <qapplication.h>
#include <qprogressdialog.h>
#include <qclipboard.h>
#include <qstringlist.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kpopupmenu.h>


#include <vector>

#include <hk_class.h>
#include <hk_string.h>
#include <hk_url.h>
#include "hk_kdetable.h"
#include "hk_kdequery.h"
#include "hk_kdegrid.h"
#include "hk_kdesimplegrid.h"
#include "hk_kdecsvimportdialog.h"
#include "hk_kdecsvexportdialog.h"
#include "hk_kdexmlexportdialog.h"
#include "hk_kdeform.h"
#include "hk_kdereport.h"
#include "hk_kdedatabasesetting.h"
#include "knodaprogrambase.h"
#include "hk_kdeobjecthandler.h"

#include <kaction.h>
#include <kstdaction.h>
#include <kmainwindow.h>

hk_kdeschemadialog::hk_kdeschemadialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
: QDialog( parent, name, modal, fl )
{
    if ( !name )
        setName( "hk_kdeschemadialog" );
    resize( 253, 100 );
    setCaption( i18n( "Please select" ) );
    setSizeGripEnabled( TRUE );
    hk_kdeschemadialogLayout = new QHBoxLayout( this, 11, 6, "hk_kdeschemadialogLayout");

    ButtonGroup1 = new QButtonGroup( this, "ButtonGroup1" );
    ButtonGroup1->setColumnLayout(0, Qt::Vertical );
    ButtonGroup1->layout()->setSpacing( 6 );
    ButtonGroup1->layout()->setMargin( 11 );
    ButtonGroup1Layout = new QVBoxLayout( ButtonGroup1->layout() );
    ButtonGroup1Layout->setAlignment( Qt::AlignTop );

    schemaonlyfield = new QRadioButton( ButtonGroup1, "schemaonlyfield" );
    schemaonlyfield->setChecked( TRUE );
    ButtonGroup1Layout->addWidget( schemaonlyfield );

    datafield = new QRadioButton( ButtonGroup1, "datafield" );
    ButtonGroup1Layout->addWidget( datafield );
    hk_kdeschemadialogLayout->addWidget( ButtonGroup1 );

    Layout2 = new QVBoxLayout( 0, 0, 6, "Layout2");

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setText( i18n( "&OK" ) );
    buttonOk->setAccel( 0 );
    buttonOk->setAutoDefault( TRUE );
    buttonOk->setDefault( TRUE );
    Layout2->addWidget( buttonOk );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setText( i18n( "&Cancel" ) );
    buttonCancel->setAccel( 0 );
    buttonCancel->setAutoDefault( TRUE );
    Layout2->addWidget( buttonCancel );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Layout2->addItem( spacer );
    hk_kdeschemadialogLayout->addLayout( Layout2 );

// signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
}


/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdeschemadialog::~hk_kdeschemadialog()
{
// no need to delete child widgets, Qt does it all for us
}


enum enum_menupoint {pm_new,pm_alter,pm_delete,pm_start,pm_import,pm_export,pm_importcsv,pm_exportcsv,pm_importxml,pm_exportxml,pm_exporthtml,pm_copy};

bool hk_listbox::p_cancelcopying=false;
QProgressDialog* hk_listbox::p_progressdialog=NULL;

hk_listbox::hk_listbox(knodamainwindowbase* w):QListBox(w),hk_class()
{
    p_window=w;
    p_dragging=false;
    p_schemadialog= new hk_kdeschemadialog();
    p_schemadialog->schemaonlyfield->setText(i18n("&Schema only"));
    p_schemadialog->datafield->setText(i18n("Schema and &data"));
    if (p_window!=NULL) p_popup= p_window->popupmenu();
    setAcceptDrops(true);
}


hk_listbox::~hk_listbox()
{

    delete p_schemadialog;
}

/*void  hk_listbox::focusInEvent(QFocusEvent*)
{
if (p_window->workspace()&&p_window->parentWidget()&&p_window->parentWidget()->isMaximized())
  { cerr <<"p_window is maximized"<<endl;
   p_window->parentWidget()->hide();
   p_window->parentWidget()->show();
  }else cerr <<"p_window not maximized"<<endl;
}*/

void hk_listbox::contextMenuEvent(QContextMenuEvent* m)
{

    p_dragstartposition = m->pos();

//QListBox::mousePressEvent(m);

    if (p_popup)
    {
        int r = p_popup->exec( m->globalPos() );
        switch (r)
        {
            case pm_new:
                p_window->new_clicked();
                break;
            case pm_alter:
                p_window->alter_clicked();
                break;
            case pm_start:
                p_window->start_clicked();
                break;
            case pm_delete:
                p_window->delete_clicked();
                break;
            case pm_importcsv:
                p_window->importcsv_clicked();
                break;
            case pm_exportcsv:
                p_window->exportcsv_clicked();
                break;
            default:
                cerr <<"Not implemented yet"<<endl;
                ;
        }

    }
}


void hk_listbox::mouseMoveEvent(QMouseEvent* event)
{

    int mindragdist =KGlobalSettings::dndEventDelay();
    if (event->state() &Qt::LeftButton && !p_dragging
        &&(
        event->pos().x() >p_dragstartposition.x() +mindragdist
        ||event->pos().x() <p_dragstartposition.x() -mindragdist
        ||event->pos().y() >p_dragstartposition.y() +mindragdist
        ||event->pos().y() <p_dragstartposition.y() -mindragdist

        ))
    {
// dragging begins
        QStoredDrag* p_drag = new QStoredDrag("application/x-hk_filecopy",this);
        QCString cstr =create_draginfo().c_str();
//cout <<"mystring drag: "<<endl<<cstr<<endl;
        p_drag->setEncodedData(cstr);
        p_drag->dragCopy();

    }
}


hk_string hk_listbox::create_draginfo(void)
{
    hk_string mystring="<NAME>";
    mystring+=u2l(currentText().utf8().data());
    mystring+="</NAME>\n<TYPE>";
    if (p_window->databasebutton->isChecked()) mystring+="DATABASE";
    else
    if (p_window->tablebutton->isChecked()) mystring+="TABLE";
        else
        if (p_window->querybutton->isChecked()) mystring+="QUERY";
    else
        if (p_window->viewbutton->isChecked()) mystring+="VIEW";
            else
            if (p_window->formbutton->isChecked()) mystring+="FORM";
                else mystring+="REPORT";
    mystring+="</TYPE>\n<DIRECTORY>";
    mystring+=p_window->datasource()->database()->database_path()+"/</DIRECTORY>\n<SERVER>";
    mystring+=p_window->datasource()->database()->connection()->drivername()+"</SERVER>\n<HOST>";
    mystring+=p_window->datasource()->database()->connection()->host()+"</HOST>\n<TCP>";
    mystring+=longint2string(p_window->datasource()->database()->connection()->tcp_port())+"</TCP>\n<USER>";
    mystring+=p_window->datasource()->database()->connection()->user()+"</USER>\n<DBNAME>";
    mystring+=p_window->datasource()->database()->name()+"</DBNAME>";
    return mystring;

}


void hk_listbox::mouseReleaseEvent(QMouseEvent* )
{

    p_dragging=false;

}


void hk_listbox::dragEnterEvent(QDragEnterEvent* event)
{
    bool cancreate=true;
    hk_string xtype;
    if (!event) return;
    if (!event->encodedData("application/x-hk_filecopy") )
      {
         cerr <<"event->encodedData ==NULL!!!"<<endl;
	 return;
      }
    if (!event->encodedData("application/x-hk_filecopy").data() )
      {
         cerr <<"event->encodedData.data ==NULL!!!"<<endl;
	 return;
      }

    hk_string result=event->encodedData("application/x-hk_filecopy").data();
    hk_class::get_tagvalue(result,"TYPE",xtype);
    if (xtype=="TABLE"
        && !(p_window->connection()&&p_window->connection()->server_supports(hk_connection::SUPPORTS_NEW_TABLE)))
        cancreate=false;
    else
    if (xtype=="DATABASE"
        && !(p_window->connection()&&p_window->connection()->server_supports(hk_connection::SUPPORTS_NEW_DATABASE)))
        cancreate=false;

    event->accept(event->provides("application/x-hk_filecopy")&&event->source()!=this && cancreate);
}


void hk_listbox::dropEvent(QDropEvent* event)
{
    if(decode_action(event)) execute_action();
}


bool hk_listbox::decode_action(QMimeSource* event)
{
    if (!event) return false;
    if (!event->encodedData("application/x-hk_filecopy").data())return false;
    hk_string result=event->encodedData("application/x-hk_filecopy").data();

    if (!(
        hk_class::get_tagvalue(result,"NAME",xname)
        &&hk_class::get_tagvalue(result,"TYPE",xtype)
        &&hk_class::get_tagvalue(result,"DIRECTORY",xdirectory)
        &&hk_class::get_tagvalue(result,"SERVER",xserver)
        &&hk_class::get_tagvalue(result,"HOST",xhost)
        &&hk_class::get_tagvalue(result,"TCP",xtcp)
        &&hk_class::get_tagvalue(result,"USER",xuser)
        &&hk_class::get_tagvalue(result,"DBNAME",xdbname)
        )
        )
    {
        show_warningmessage("Error in drag&drop protocol");
        cerr <<result<<endl;
        return false;
    }
    if (xtype=="REPORT")
    {
        ftype=ot_report;
    }
    else
    if (xtype=="QUERY")
    {
        ftype=ot_query;
    }
    else
    if (xtype=="VIEW")
    {
        ftype=ot_view;
    }
    else
    if (xtype=="FORM")
    {
        ftype=ot_form;
    }
    else
    if (xtype=="TABLE")
    {
        ftype=ot_table;
    }
    else
    {
        ftype=ot_database;
    }

    return true;

}


bool hk_listbox::execute_action(void)
{

    if (p_window->databasebutton->isChecked())actiontype=ot_database;
    else
    if (p_window->tablebutton->isChecked())actiontype=ot_table;
        else
        if (p_window->viewbutton->isChecked())actiontype=ot_view;
        else
        if (p_window->querybutton->isChecked())actiontype=ot_query;
            else
            if (p_window->formbutton->isChecked())actiontype=ot_form;
                else actiontype=ot_report;

    switch (ftype)
    {
        case ot_table:
        {
            copy_table();
            break;
        }
        case ot_view:
        {
            copy_view();
            break;
        }
        case ot_database:
        {
            copy_database();
            break;
        }
        default: copy_presentationfile();
    }
    p_window->function_select(actiontype);
    return true;

}


bool hk_listbox::copy_presentationfile(void)
{

    if (!p_window->datasource()->database()) return false;
    hk_connection* con=find_connection();
    hk_connection* newcon=p_window->datasource()->database()->connection()->drivermanager()->new_connection(xserver);
    newcon->set_host(xhost);
    newcon->set_tcp_port(localestring2uint(xtcp));
    newcon->set_user(xuser);
    if (con) newcon->set_password(con->password());
    newcon->connect();
    if (!newcon->is_connected())
    {
        delete newcon;
        return false;
    }
    hk_database* db=newcon->new_database(xdbname);
    hk_string input=db->load(xname,(filetype)actiontype);

      p_window->datasource()->database()->save(input,xname,(filetype)actiontype,true,true);

   return true;

}


bool hk_listbox::copy_table(void)
{
    if (!p_window->datasource()) return false;
    if (!p_window->datasource()->database()) return false;
    hk_connection* con=find_connection();
    hk_connection* newcon=p_window->datasource()->database()->connection()->drivermanager()->new_connection(xserver);
    newcon->set_host(xhost);
    newcon->set_tcp_port(localestring2uint(xtcp));
    newcon->set_user(xuser);
    if (con) newcon->set_password(con->password());
    newcon->connect();
    if (!newcon->is_connected())
    {
        delete newcon;
        return false;
    }
    hk_database* db=newcon->new_database(xdbname);
    hk_datasource* ds=NULL;
    if (db)ds= db->new_table(xname);
    bool data=true;
    int i=p_schemadialog->exec();

    if (p_schemadialog->schemaonlyfield->isChecked())data=false;
    p_schemadialog->hide();
    if (i==QDialog::Rejected)return false;
    p_cancelcopying=false;
    p_progressdialog= new  QProgressDialog();
    p_progressdialog->resize(300,p_progressdialog->height());
    connect(p_progressdialog,SIGNAL(cancelled()),this,SLOT(copying_cancelled()));
    p_progressdialog->show();
    qApp->processEvents();
    bool result= p_window->datasource()->database()->copy_table(ds,data,true,true,&hk_listbox::set_progress);
    delete ds;
    delete p_progressdialog;
    p_progressdialog=NULL;
    newcon->disconnect();
    delete newcon;
    return result;
}



bool hk_listbox::copy_view(void)
{
    if (!p_window->datasource()) return false;
    if (!p_window->datasource()->database()) return false;
    hk_connection* con=find_connection();
    hk_connection* newcon=p_window->datasource()->database()->connection()->drivermanager()->new_connection(xserver);
    newcon->set_host(xhost);
    newcon->set_tcp_port(localestring2uint(xtcp));
    newcon->set_user(xuser);
    if (con) newcon->set_password(con->password());
    newcon->connect();
    if (!newcon->is_connected())
    {
        delete newcon;
        return false;
    }
    hk_database* db=newcon->new_database(xdbname);
    hk_datasource* ds=NULL;
    if (db)ds= db->new_view(xname);
    p_cancelcopying=false;
    p_progressdialog= new  QProgressDialog();
    p_progressdialog->resize(300,p_progressdialog->height());
    connect(p_progressdialog,SIGNAL(cancelled()),this,SLOT(copying_cancelled()));
    p_progressdialog->show();
    qApp->processEvents();
    bool result= p_window->datasource()->database()->copy_view(ds,&hk_listbox::set_progress);
    delete ds;
    delete p_progressdialog;
    p_progressdialog=NULL;
    newcon->disconnect();
    delete newcon;
    return result;
}



void hk_listbox::copying_cancelled()
{
    p_cancelcopying=true;
}


bool hk_listbox::set_progress(long int position,long int total,const hk_string&txt)
{
    if (p_progressdialog)
    {

        p_progressdialog->setCaption(QString::fromUtf8(l2u(txt).c_str()));
        p_progressdialog->setTotalSteps(total);
        p_progressdialog->setProgress(position);
        qApp->processEvents();
    }
    return p_cancelcopying;
}


bool hk_listbox::copy_database(void)
{
    if (!p_window->datasource()) return false;
    if (!p_window->datasource()->database()) return false;
    hk_connection* con=find_connection();
    hk_connection* newcon=p_window->datasource()->database()->connection()->drivermanager()->new_connection(xserver);
    newcon->set_host(xhost);
    newcon->set_tcp_port(localestring2uint(xtcp));
    newcon->set_user(xuser);
    if (con) newcon->set_password(con->password());
    newcon->connect();
    if (!newcon->is_connected())
    {
        delete newcon;
        return false;
    }
    hk_database* db=newcon->new_database(xdbname);
    bool data=true;
    int i=p_schemadialog->exec();
    if (p_schemadialog->schemaonlyfield->isChecked())data=false;
    p_schemadialog->hide();
    if (i==QDialog::Rejected)return false;
    p_cancelcopying=false;
    p_progressdialog= new  QProgressDialog();
    p_progressdialog->resize(300,p_progressdialog->height());
    connect(p_progressdialog,SIGNAL(cancelled()),this,SLOT(copying_cancelled()));
    p_progressdialog->show();
    qApp->processEvents();
    bool result= p_window->datasource()->database()->connection()->copy_database(db,data,true,&hk_listbox::set_progress);
    delete p_progressdialog;
    p_progressdialog=NULL;
    newcon->disconnect();
    delete newcon;
    return result;
}


hk_connection* hk_listbox::find_connection(void)
{
    if (!p_window->datasource()) return NULL;
    return p_window->datasource()->database()->connection()->drivermanager()->find_existing_connection(xserver,xhost,localestring2uint(xtcp),xuser);
}


//************************************************************************

//******** knodamainwin    start                              ************

//************************************************************************

knodamainwindowbase::knodamainwindowbase( KMainWindow* parent, const char* name, WFlags fl,const QString& database,const QString& form )
: QWidget( parent, name, fl ) ,hk_dsvisible()
{
#ifdef HK_DEBUG
    hkclassname("knodawinbase");
    hkdebug("knodamainwindowbase::knodamainwindowbase");
#endif
//   setXMLFile("knodaui.rc");
    p_parent=parent;
    p_selecteddb=database;
    p_selectedform=form;
    p_designer=NULL;
    if ( !name )
        setName( "knodamainwindowbase" );
//   resize( 400, 480 );
    //setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, sizePolicy().hasHeightForWidth() ) );
    //setMinimumSize( QSize( 400, 200 ) );
    setMaximumSize( QSize( 32767, 32767 ) );
    knodamainwindowbaseLayout = new QHBoxLayout( this );
    knodamainwindowbaseLayout->setSpacing( 6 );
    knodamainwindowbaseLayout->setMargin( 11 );
    p_stablestring=i18n("&Tables");
    p_sviewstring=i18n("&Views");
    p_squerystring=i18n("&Queries");
    p_sformstring=i18n("F&orms");
    p_sreportstring=i18n("&Reports");

    p_tablestring=i18n("Tables");
    p_querystring=i18n("Queries");
    p_viewstring=i18n("Views");
    p_formstring=i18n("Forms");
    p_reportstring=i18n("Reports");

    p_databasestring=i18n("Databases");
    p_sdatabasestring=i18n("D&atabases");

    Layout8 = new QGridLayout;
    Layout8->setSpacing( 6 );
    Layout8->setMargin( 0 );

    TextLabel1 = new QLabel( this, "TextLabel1" );
    TextLabel1->setText( p_databasestring );

    Layout8->addWidget( TextLabel1, 0, 0 );
    knodamainwindowbaseLayout->addLayout( Layout8 );

    Layout3 = new QVBoxLayout;
    Layout3->setSpacing( 6 );
    Layout3->setMargin( 0 );

    TextLabel1_2 = new QLabel( this, "TextLabel1_2" );
    TextLabel1_2->setText( i18n( "Active database:"  ) );
    Layout3->addWidget( TextLabel1_2 );

    databasename = new QLabel( this, "databasename" );
    databasename->setAlignment( int( QLabel::WordBreak | QLabel::AlignCenter ) );
    databasename->setFrameShape( QLabel::Box );
    databasename->setFrameShadow( QLabel::Sunken );
    databasename->setScaledContents( TRUE );
    databasename->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)7, databasename->sizePolicy().hasHeightForWidth() ) );
    databasename->setMinimumSize( QSize( 0, 30 ) );
    Layout3->addWidget( databasename );
    ButtonGroup2 = new QButtonGroup( this, "ButtonGroup2" );
    ButtonGroup2->setTitle( i18n( "Functions"  ) );
    ButtonGroup2->setExclusive( TRUE );
    ButtonGroup2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, ButtonGroup2->sizePolicy().hasHeightForWidth() ) );
    ButtonGroup2->setMinimumSize( QSize( 0, 180 ) );
    ButtonGroup2->setColumnLayout(0, Qt::Vertical );
    ButtonGroup2->layout()->setSpacing( 0 );
    ButtonGroup2->layout()->setMargin( 0 );

    ButtonGroup2Layout = new QVBoxLayout( ButtonGroup2->layout() );
    ButtonGroup2Layout->setAlignment( Qt::AlignTop );
    ButtonGroup2Layout->setSpacing( 6 );
    ButtonGroup2Layout->setMargin( 11 );

    querybutton = new QRadioButton( ButtonGroup2, "querybutton" );
    querybutton->setGeometry( QRect( 11, 71, 73, 19 ) );
    querybutton->setText(  p_squerystring );
    ButtonGroup2->insert( querybutton, 2 );
    querybutton->setEnabled( FALSE );
    querybutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, querybutton->sizePolicy().hasHeightForWidth() ) );
    querybutton->installEventFilter(this);

    reportbutton = new QRadioButton( ButtonGroup2, "reportbutton" );
    reportbutton->setGeometry( QRect( 11, 147, 73, 19 ) );
    reportbutton->setText(  p_sreportstring );
    ButtonGroup2->insert( reportbutton, 5 );
    reportbutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, reportbutton->sizePolicy().hasHeightForWidth() ) );
    reportbutton->setEnabled( FALSE );
    reportbutton->installEventFilter(this);

    tablebutton = new QRadioButton( ButtonGroup2, "tablebutton" );
    tablebutton->setGeometry( QRect( 11, 46, 73, 19 ) );
    tablebutton->setText( p_stablestring );
    ButtonGroup2->insert( tablebutton, 1 );
    tablebutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, tablebutton->sizePolicy().hasHeightForWidth() ) );
    tablebutton->setEnabled( FALSE );
    tablebutton->installEventFilter(this);

    viewbutton = new QRadioButton( ButtonGroup2, "viewbutton" );
    viewbutton->setGeometry( QRect( 11, 96, 73, 19 ) );
    viewbutton->setText( p_sviewstring );
    ButtonGroup2->insert( viewbutton, 3 );
    viewbutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, viewbutton->sizePolicy().hasHeightForWidth() ) );
    viewbutton->setEnabled( FALSE );
    viewbutton->installEventFilter(this);

    formbutton = new QRadioButton( ButtonGroup2, "formbutton" );
    formbutton->setGeometry( QRect( 11, 121, 73, 19 ) );
    formbutton->setText( p_sformstring );
    ButtonGroup2->insert( formbutton, 4 );
    formbutton->setEnabled( FALSE );
    formbutton->installEventFilter(this);

    databasebutton = new QRadioButton( ButtonGroup2, "databasebutton" );
    databasebutton->setGeometry( QRect( 11, 21, 73, 19 ) );
    databasebutton->setText( p_sdatabasestring );
    databasebutton->setChecked( TRUE );
    ButtonGroup2->insert( databasebutton, 0 );
    databasebutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, databasebutton->sizePolicy().hasHeightForWidth() ) );
    databasebutton->setEnabled( FALSE );
    ButtonGroup2Layout->addWidget( databasebutton );
    ButtonGroup2Layout->addWidget( tablebutton );
    ButtonGroup2Layout->addWidget( querybutton );
    ButtonGroup2Layout->addWidget( viewbutton );
    ButtonGroup2Layout->addWidget( formbutton );
    ButtonGroup2Layout->addWidget( reportbutton );
    Layout3->addWidget( ButtonGroup2 );
    databasebutton->installEventFilter(this);

    ButtonGroup3 = new QButtonGroup( this, "ButtonGroup3" );
    ButtonGroup3->setTitle( i18n( "Actions"  ) );
    ButtonGroup3->setMinimumSize( QSize( 0, 170 ) );
    ButtonGroup3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, ButtonGroup3->sizePolicy().hasHeightForWidth() ) );
    ButtonGroup3->setColumnLayout(0, Qt::Vertical );
    ButtonGroup3->layout()->setSpacing( 0 );
    ButtonGroup3->layout()->setMargin( 0 );
    ButtonGroup3Layout = new QVBoxLayout( ButtonGroup3->layout() );
    ButtonGroup3Layout->setAlignment( Qt::AlignTop );
    ButtonGroup3Layout->setSpacing( 6 );
    ButtonGroup3Layout->setMargin( 11 );

    startbutton = new QPushButton( ButtonGroup3, "startbutton" );
    startbutton->setText( i18n( "&Start"  ) );
    startbutton->setEnabled( FALSE );
    startbutton->setMinimumSize( QSize( 0, 20 ) );
    startbutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, startbutton->sizePolicy().hasHeightForWidth() ) );
    ButtonGroup3Layout->addWidget( startbutton );
    startbutton->installEventFilter(this);

    alterbutton = new QPushButton( ButtonGroup3, "alterbutton" );
    alterbutton->setText( i18n( "&Modify"  ) );
    alterbutton->setEnabled( FALSE );
    alterbutton->setMinimumSize( QSize( 0, 20 ) );
    alterbutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, startbutton->sizePolicy().hasHeightForWidth() ) );
    ButtonGroup3Layout->addWidget( alterbutton );
    alterbutton->installEventFilter(this);

    newbutton = new QPushButton( ButtonGroup3, "newbutton" );
    newbutton->setText( i18n( "&New"  ) );
    newbutton->setEnabled( true );
    newbutton->setMinimumSize( QSize( 0, 20 ) );
    newbutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, newbutton->sizePolicy().hasHeightForWidth() ) );
    ButtonGroup3Layout->addWidget( newbutton );
    newbutton->installEventFilter(this);

    deletebutton = new QPushButton( ButtonGroup3, "deletebutton" );
    deletebutton->setText( i18n( "&Delete"  ) );
    deletebutton->setEnabled( FALSE );
    deletebutton->setMinimumSize( QSize( 0, 20 ) );
    deletebutton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, startbutton->sizePolicy().hasHeightForWidth() ) );
    ButtonGroup3Layout->addWidget( deletebutton );
    Layout3->addWidget( ButtonGroup3 );
    knodamainwindowbaseLayout->addLayout( Layout3 );
    deletebutton->installEventFilter(this);

// signals and slots connections
    connect( newbutton, SIGNAL( clicked() ), this, SLOT( new_clicked() ) );
    connect( startbutton, SIGNAL( clicked() ), this, SLOT( start_clicked() ) );
    connect( alterbutton, SIGNAL( clicked() ), this, SLOT( alter_clicked() ) );
    connect( deletebutton, SIGNAL( clicked() ), this, SLOT( delete_clicked() ) );
    connect( ButtonGroup2, SIGNAL( clicked(int) ), this, SLOT( function_select(int) ) );
    connect (QApplication::clipboard(), SIGNAL(dataChanged()),this, SLOT(clipboarddata_has_changed()));
    p_connection=NULL;
    p_database=NULL;
    if (runtime_only())
    {
        alterbutton->hide();
        newbutton->hide();
        deletebutton->hide();
    }

//     p_changepasswordaction= new KAction(i18n("&Change password"),0,0,this,SLOT(newpassworddialog_selected()),p_parent->actionCollection(),"changepassword");
//     p_changepasswordaction->setEnabled(false);
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");

    p_newaction= new KAction(i18n("&New"),"filenew",0,this,SLOT(new_clicked()),p_parent->actionCollection(),"newclicked");
    p_alteraction= new KAction(i18n("&Modify"),"edit",0,this,SLOT(alter_clicked()),p_parent->actionCollection(),"alterclicked");
    p_startaction= new KAction(i18n("&Start"),"exec",0,this,SLOT(start_clicked()),p_parent->actionCollection(),"startclicked");
    p_deleteaction= new KAction(i18n("&Delete"),"editdelete",Key_Delete,this,SLOT(delete_clicked()),p_parent->actionCollection(),"deleteclicked");
    p_renameaction=new KAction(i18n("&Rename"),0,0,this,SLOT(rename_clicked()),p_parent->actionCollection(),"renameclicked");
    p_databasesettingaction= new KAction(i18n("&Database settings"),0,0,this,SLOT(databasesettings_clicked()),p_parent->actionCollection(),"dbsettings");
     p_objecthandleraction= new KAction(i18n("&Object handler"),0,0,this,SLOT(objecthandler_clicked()),p_parent->actionCollection(),"objecthandler");

    p_alteraction->setEnabled(false);
    p_startaction->setEnabled(false);
    p_deleteaction->setEnabled(false);

    p_exportaction= new KActionMenu(i18n("E&xport"),0,p_parent->actionCollection(),"export");
    p_exportcsvaction= new KAction(i18n("&CSV"),0,0,this,SLOT(exportcsv_clicked()),p_parent->actionCollection(),"exportcsv");
    p_exportxmlaction= new KAction(i18n("&XML"),0,0,this,SLOT(exportxml_clicked()),p_parent->actionCollection(),"exportxml");

    p_exportaction->insert(p_exportcsvaction);
    p_exportaction->insert(p_exportxmlaction);
    p_exportdatabaseaction= new KActionMenu(i18n("To &database"),0,p_parent->actionCollection(),"exportdatabase");
    p_exportaction->insert(p_exportdatabaseaction);
    connect(p_exportdatabaseaction->popupMenu(),SIGNAL(aboutToShow()),this,SLOT(show_exportdbdrivers()));
    //p_exportaction->setEnabled(false);
    p_importaction= new KActionMenu(i18n("I&mport"),0,p_parent->actionCollection(),"import");
    //p_importaction->setEnabled(false);
    p_importcsvaction= new KAction(i18n("&CSV"),0,0,this,SLOT(importcsv_clicked()),p_parent->actionCollection(),"importcsv");
    p_importaction->insert(p_importcsvaction);
    p_passwordaction= new KAction(i18n("&Change password"),0,0,this,SLOT(newpassworddialog_selected()),p_parent->actionCollection(),"changepassword");
    p_copyaction= new KAction(i18n("&Copy"),"editcopy",CTRL+Key_C,this,SLOT(copy_clicked()),p_parent->actionCollection(),"copy");
    p_pasteaction= new KAction(i18n("&Paste"),"editpaste",CTRL+Key_V,this,SLOT(paste_clicked()),p_parent->actionCollection(),"paste");

    p_openlocaldbaction=  new KAction(i18n("Open &local database"),"fileopen",0,this,SLOT(slot_open_localdatabase()),p_parent->actionCollection(),"openlocaldb");

   p_openlocaldbaction->setEnabled(false);
    p_importdatabaseaction= new KActionMenu(i18n("From &database"),0,p_parent->actionCollection(),"importdatabase");
    p_importaction->insert(p_importdatabaseaction);
    connect(p_importdatabaseaction->popupMenu(),SIGNAL(aboutToShow()),this,SLOT(show_importdbdrivers()));
    p_storeconnection= new KAction(i18n("Store connection"),"contents",0,this,SLOT(slot_store_connection()),p_parent->actionCollection(),"storeconnection");

      p_referentialintegrityaction=new KAction(i18n("Referential integrity"),loader->loadIcon("dbdesigner",KIcon::User),0,this,SLOT(slot_referentialintegrity()),p_parent->actionCollection(),"referentialintegrity");
   p_referentialintegrityaction->setEnabled(false);


    QString rcfile=locate("data","knoda/knodaui.rc");
    if (rcfile.isNull())
    {
        show_warningmessage(hk_translate("Fatal error: File 'knodaui.rc' could not be located. Probably Knoda is installed incorrectly\n\
Are you sure you have used\n ./configure --prefix=/your_KDE_directory ? \n See the http://hk-classes.sourceforge.net/download.html for details. "));
        exit(1);
    }
    p_parent->createGUI(rcfile);
    itemslist = new hk_listbox( this );
    itemslist->installEventFilter(this);

    itemslist->setMinimumSize( QSize( 250, 300 ) );
    itemslist->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)3, itemslist->sizePolicy().hasHeightForWidth() ) );
  KConfig* c=kapp->config();
  c->setGroup("Preferences");
// if (c->readBoolEntry("UseSingleclick",false))
//    connect( itemslist, SIGNAL( clicked(QListBoxItem*) ), this, SLOT( itemslist_doubleclicked() ) );
// else
    connect( itemslist, SIGNAL( doubleClicked(QListBoxItem*) ), this, SLOT( itemslist_doubleclicked() ) );


    connect( itemslist, SIGNAL( highlighted(QListBoxItem*) ), this, SLOT( itemslist_clicked(QListBoxItem*) ) );

    Layout8->addWidget( itemslist, 1, 0 );
    clipboarddata_has_changed();

}


/*
 *  Destroys the object and frees any allocated resources
 */
knodamainwindowbase::~knodamainwindowbase()
{

//set_generaldebug(true);

#ifdef HK_DEBUG
    hkdebug("=========================>>>>>>>>>>>>>>>");
    hkdebug("knodamainwindowbase::~knodamainwindowbase");
#endif
// no need to delete child widgets, Qt does it all for us
    if (p_connection!=NULL)
    {
//     p_connection->new_database();
#ifdef HK_DEBUG
        hkdebug("knodamainwindowbase::disconnect ");
#endif
        p_connection->disconnect();
        delete p_connection;
        p_connection=NULL;
        p_database=NULL;
    }
    cerr <<"knodamainwindowbase::~knodamainwindowbase()"<<endl;
    delete p_newaction;
    delete p_alteraction;
    delete p_startaction;
    delete p_deleteaction;
    delete p_copyaction;
    delete p_pasteaction;
    delete p_exportaction;
    delete p_exportcsvaction;
    delete p_exportxmlaction;
    delete p_importaction;
    delete p_importcsvaction;
    delete p_passwordaction;
    delete p_openlocaldbaction;

    delete Layout8;
    delete Layout3;
    delete knodamainwindowbaseLayout;
    delete ButtonGroup3Layout;
    delete ButtonGroup2Layout;
    delete itemslist;

}


void knodamainwindowbase::set_connection(hk_connection*c )
{
    if (p_connection)
    {
      delete p_database;
      p_database=NULL;
    }
    p_connection=c;
    if (!p_connection) return;
    function_select(ot_database);
    databasebutton->setEnabled(true);
    p_passwordaction->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_CHANGE_PASSWORD));
    p_openlocaldbaction->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_LOCAL_FILEFORMAT));
   p_referentialintegrityaction->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_REFERENTIALINTEGRITY));

    if (!p_selecteddb.isEmpty())
    {
        p_database=p_connection->new_database();

        if (p_database!=NULL)
        {
#ifdef HK_DEBUG
            p_database->hkclassname("knodawinbasedatabase");
#endif

	    p_database->set_name(u2l(p_selecteddb.utf8().data()));
            set_datasource(p_database->new_resultquery());
            databasename->setText(p_selecteddb);
	    open_autoform();
            if (!p_selectedform.isEmpty())
            {
                hk_kdeform* w=new_form();
                w->set_database(p_database);
                w->load_form(u2l(p_selectedform.utf8().data()));
                show();
                if (open_maximized_windows())w->showMaximized();
                else w->show();
                w->set_viewmode();
            }
            set_buttons();
        }

    }
    else
    {
        itemslist->setCurrentItem(0);
        itemslist->setFocus();
    }

}


void knodamainwindowbase::importcsv_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::importcsv_clicked");
#endif
    if (p_database==NULL) return;
    hk_kdecsvimportdialog* i= new hk_kdecsvimportdialog(0,0,true);
    hk_datasource* ds=p_database->new_table();
//   ds->wanna_debug(true);
    i->set_datasource(ds);
    i->exec();
    delete i;
}


void knodamainwindowbase::exportcsv_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::exportcsv_clicked");
#endif
    if (p_database==NULL) return;
    hk_kdecsvexportdialog* e =new hk_kdecsvexportdialog(itemslist->currentText(),0,0,true);
    e->set_database(p_database);
    if (querybutton->isChecked()) e->set_usequerylist();
    else
    if (viewbutton->isChecked()) e->set_useviewlist();
    else
     e->set_usetablelist();


    e->exec();
    delete e;
}


void knodamainwindowbase::exportxml_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::exportxml_clicked");
#endif
    if (p_database==NULL) return;
    hk_kdexmlexportdialog* e =new hk_kdexmlexportdialog(itemslist->currentText(),0,0,true);
    e->set_database(p_database);
    if (querybutton->isChecked()) e->set_usequerylist();
    else
    if (viewbutton->isChecked()) e->set_useviewlist();
    else
     e->set_usetablelist();
    e->exec();
    delete e;
}


void knodamainwindowbase::alter_clicked()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::alter_clicked");
#endif
    if (p_database==NULL) return;
    int item=itemslist->currentItem();
    if (item==-1)return;
    if (tablebutton->isChecked())
    {
//hk_kdetable �fnen

        hk_kdetable* w=new_table();
        hk_datasource* d=p_database->new_table();
//   d->wanna_debug(true);
        d->set_name(u2l(itemslist->text(itemslist->currentItem()).utf8().data()));
        w->set_datasource(d);
        w->set_designmode();
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        return ;
    }

    else
    if (viewbutton->isChecked())
    {
//hk_kdetable �fnen

        hk_kdequery* w=new_view();
        hk_datasource* d=p_database->new_view();
//   d->wanna_debug(true);
        d->set_name(u2l(itemslist->text(itemslist->currentItem()).utf8().data()));
        w->set_datasource(d);
        w->set_designmode();
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        return ;
    }

    else
    if (querybutton->isChecked())
    {
        hk_kdequery* w=new_query();
        hk_datasource* d=p_database->new_resultquery();
        w->set_datasource(d);
//   d->wanna_debug(true);
        d->set_name(u2l(itemslist->text(itemslist->currentItem()).utf8().data()));
        w->load_query();
//   d->sql(p_database->load(itemslist->text(u2l(itemslist->currentItem()).utf8().data()),lt_query).c_str());
        w->set_designmode();
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        return ;
    }
    else
    if (formbutton->isChecked())
    {
//    set_generaldebug(true);
        hk_kdeform* w=new_form();
        w->set_database(p_database);
        w->load_form(u2l(itemslist->text(itemslist->currentItem()).utf8().data()));
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        w->set_designmode();

    }
    else
    if (reportbutton->isChecked())
    {
//    set_generaldebug(true);
        hk_kdereport* w=new_report();
        w->set_database(p_database);
        w->load_report(u2l(itemslist->text(itemslist->currentItem()).utf8().data()));
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        w->set_designmode();

    }
    else
        qWarning( "knodamainwindowbase::alter_clicked(): Not implemented yet!" );
}


void knodamainwindowbase::delete_clicked()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::delete_clicked");
#endif
    if (databasebutton->isChecked())
    {
        if (itemslist->currentItem()>-1)
        {
            int cpos=itemslist->currentItem();
            hk_string dbname=u2l(itemslist->text(itemslist->currentItem()).utf8().data());
            int x=-1;
            if (itemslist->currentItem()>0) x=itemslist->currentItem()-1;
            else if (itemslist->count()>1) x=itemslist->currentItem()+1;
            itemslist->setCurrentItem(x);
            if (p_connection->delete_database(dbname))
            {
                function_select(ot_database);
                if (x<0)databasename->setText("");
                set_buttons();
            } else itemslist->setCurrentItem(cpos);
        }
    }
    else
    if (tablebutton->isChecked())
    {
        if (p_database==NULL) return;
        if (itemslist->currentItem()>-1)
            if (p_database->delete_table(u2l(itemslist->text(itemslist->currentItem()).utf8().data())))
        {
            function_select(ot_table);
        }
    }
    else
    {
        if (p_database==NULL) return;
        filetype f=ft_query;
        if (formbutton->isChecked()) f=ft_form;
        else
        if (reportbutton->isChecked()) f=ft_report;

            p_database->delete_file(u2l(itemslist->text(itemslist->currentItem()).utf8().data()),f);
    }
}


void knodamainwindowbase::rename_clicked()
{
if (itemslist->currentItem()==-1)
    {
       show_warningmessage(hk_translate("no object selected"));
       return;
    }
hk_string newname=trim(show_stringvaluedialog(hk_translate("Enter new name:")));
if (newname.size()==0) return;
if (databasebutton->isChecked());
    else
    {
    filetype f;
    if (tablebutton->isChecked())
       f=ft_table;
    else
    if (querybutton->isChecked())
       f=ft_query;
    else
    if (formbutton->isChecked())
       f=ft_form;
    else
       f=ft_report;


    if (!p_database->rename_file(u2l(itemslist->text(itemslist->currentItem()).utf8().data()),newname,f))
    show_warningmessage(hk_translate("Could not rename object!"));
    }
}




void knodamainwindowbase::function_select(int f)
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::function_select");
#endif
    if (f==3) f=6;
    else if (f>3) --f;
    if (p_connection==NULL) return;
    itemslist->clear();
    p_importcsvaction->setEnabled(false);
    p_exportcsvaction->setEnabled(false);
    p_exportxmlaction->setEnabled(false);
    switch (f)
    {
        case ot_database:
        {
            TextLabel1->setText( p_databasestring );
            if (!p_connection->is_connected())p_connection->connect();
            vector<hk_string>* db=p_connection->dblist();
            vector<hk_string>::iterator it;
            itemslist->blockSignals(true);
	    hk_url url=(hk_string)(u2l(databasename->text().utf8().data()));
	    if (!url.directory().empty())
	    {
	       itemslist->insertItem(databasename->text());
	       itemslist->setCurrentItem(0);
	    }
            if (db!=NULL)
            {
                int i=0;
                for(it=db->begin();it!=db->end();it++)
                {
                    itemslist->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
                    if (databasename->text()==QString::fromUtf8(l2u((*it)).c_str()))
                    {
                        itemslist->setCurrentItem(i);
                    }
                    i++;
                }
            }
            itemslist->blockSignals(false);

        }
        break;

        case ot_table:
        {
            if (p_database==NULL) break;
            TextLabel1->setText( p_tablestring );
            p_importcsvaction->setEnabled(true);
            p_exportcsvaction->setEnabled(true);
            p_exportxmlaction->setEnabled(true);
            vector<hk_string>* tb=p_database->tablelist();
            vector<hk_string>::iterator it;
            if (tb!=NULL)
            {
                for(it=tb->begin();it!=tb->end();it++)
                {
                    itemslist->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
                }
            }
        }
        break;

        case ot_query:
        {
            if (p_database==NULL) break;
            TextLabel1->setText( p_querystring );
            p_importcsvaction->setEnabled(true);
            p_exportcsvaction->setEnabled(true);
            p_exportxmlaction->setEnabled(true);
            vector<hk_string>* tb=p_database->querylist();
            vector<hk_string>::iterator it;
            if (tb!=NULL)
            {
                for(it=tb->begin();it!=tb->end();it++)
                {
                    itemslist->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
                }
            }
        }
        break;

        case ot_view:
        {
            if (p_database==NULL) break;
            TextLabel1->setText( p_viewstring );
            p_exportaction->setEnabled(true);
            vector<hk_string>* tb=p_database->viewlist();
            vector<hk_string>::iterator it;
            if (tb!=NULL)
            {
                for(it=tb->begin();it!=tb->end();it++)
                {
                    itemslist->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
                }
            }
        }
        break;

        case ot_form:
        {
            if (p_database==NULL) break;
            TextLabel1->setText( p_formstring );
            vector<hk_string>* tb=p_database->formlist();
            vector<hk_string>::iterator it;
            if (tb!=NULL)
            {
                for(it=tb->begin();it!=tb->end();it++)
                {
                    itemslist->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
                }
            }
        }
        break;

        case ot_report:
        {
            if (p_database==NULL) break;
            TextLabel1->setText( p_reportstring );
            vector<hk_string>* tb=p_database->reportlist();
            vector<hk_string>::iterator it;
            if (tb!=NULL)
            {
                for(it=tb->begin();it!=tb->end();it++)
                {
                    itemslist->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
                }
            }
        }
        break;

        default:;

    }
    if (f!=ot_database) itemslist->setCurrentItem(-1);

    set_buttons();
    itemslist->repaint(true);
}


void knodamainwindowbase::function_select(void)
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::function_select");
#endif
objecttype actiontype;
if (databasebutton->isChecked())actiontype=ot_database;
    else
    if (tablebutton->isChecked())actiontype=ot_table;
        else
        if (querybutton->isChecked())actiontype=ot_query;
            else
        if (viewbutton->isChecked())actiontype=ot_view;
            else
            if (formbutton->isChecked())actiontype=ot_form;
            else
            if (reportbutton->isChecked())actiontype=ot_report;
                else return;
function_select(actiontype);
}


void knodamainwindowbase::itemslist_doubleclicked()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::itemslist_doubleclicked");
#endif
    start_clicked();
}


void knodamainwindowbase::new_clicked()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::new_clicked");
#endif

    if (databasebutton->isChecked())
    {

        knodanewdatabasedialog* d =new knodanewdatabasedialog(0,0,true);
        int r=d->exec();
        if (r==QDialog::Accepted)
        {
            if (!p_connection->create_database(u2l(d->databasename->text().utf8().data())))
	    {
	      show_warningmessage(hk_translate("Database could not be created"));
	    }
            function_select(ot_database);
        }
//     delete d;
    }
    else
    if (tablebutton->isChecked())
    {
        if (p_database==NULL) return;
        hk_kdetable* t=new_table();
        hk_datasource* d=p_database->new_table();
        t->set_datasource(d);
        t->set_designmode();
        if (open_maximized_windows())t->showMaximized();
        else t->show();
        return;
    }
    else
    if (querybutton->isChecked())
    {
        if (p_database==NULL) return;
        hk_kdequery* w=new_query();
        hk_datasource* d=p_database->new_resultquery();
        w->set_datasource(d);
        w->set_designmode();
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        return ;
    }

    else
    if (viewbutton->isChecked())
    {
        if (p_database==NULL) return;
        hk_kdequery* w=new_query();
        hk_datasource* d=p_database->new_view();
        w->set_datasource(d);
        w->set_designmode();
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        return ;
    }

    else
    if (formbutton->isChecked())
    {
        if (p_database==NULL) return;
        hk_kdeform* w=new_form();
        w->set_database(p_database);
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        w->set_designmode();
        return ;
    }
    else
    if (reportbutton->isChecked())
    {
        if (p_database==NULL) return;
        hk_kdereport* w=new_report();
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        w->set_database(p_database);
        w->set_designmode();
        return ;
    }
    else    qWarning( "knodamainwindowbase::new_clicked(): Not implemented yet!" );
}


void knodamainwindowbase::start_clicked()
{
    if (p_database==NULL) return;
    int item=itemslist->currentItem();
    if (item==-1)return;
    if (tablebutton->isChecked())
    {
//hk_kdetable �fnen
        hk_kdetable* w=new_table();
        hk_datasource* d=p_database->new_table();
//   d->wanna_debug(true);
        d->set_name(u2l(itemslist->text(itemslist->currentItem()).utf8().data()));
        w->set_datasource(d);
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        w->set_viewmode();
        return ;
    }

    else
    if (querybutton->isChecked())
    {
        hk_kdequery* w=new_query();
        hk_datasource* d=p_database->new_resultquery();
        d->set_name(u2l(itemslist->text(itemslist->currentItem()).utf8().data()));
        w->set_datasource(d);
        w->load_query();
        if (open_maximized_windows())w->showMaximized();
        else w->show();
        w->set_viewmode();
        return ;
    }
    else
    if (viewbutton->isChecked())
    {
        hk_kdequery* w=new_query();
        hk_datasource* d=p_database->new_view();
        d->set_name(u2l(itemslist->text(itemslist->currentItem()).utf8().data()));
        w->set_datasource(d);
        w->set_use_qbe(false,false);

        if (open_maximized_windows())w->showMaximized();
        else w->show();
        w->set_viewmode();
        return ;
    }
    else
    if (formbutton->isChecked())
    {
        hk_kdeform* w=new_form();
        w->set_database(p_database);
        w->load_form(u2l(itemslist->text(itemslist->currentItem()).utf8().data()));

        if (open_maximized_windows())w->showMaximized();
        else w->show();
        w->set_viewmode();
        w->raise();
        return ;
    }
    else
    if (reportbutton->isChecked())
    {
        hk_kdereport* w=new_report();
        w->set_database(p_database);
//   w->set_designmode();
        w->load_report(u2l(itemslist->text(itemslist->currentItem()).utf8().data()));

        if (open_maximized_windows())w->showMaximized();
        else w->show();
        w->set_viewmode();
        return ;
    }
    else

        qWarning( "knodamainwindowbase::start_clicked(): Not implemented yet!" );
}


void knodamainwindowbase::itemslist_clicked(QListBoxItem* item)
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::itemslist_clicked");
#endif

    if (item==NULL)return;
    if (databasebutton->isChecked())
    {

        if (item->text()!=databasename->text())
        {
            if (!p_database)p_database=p_connection->new_database();
            if (p_database!=NULL)
            {
#ifdef HK_DEBUG
                p_database->hkclassname("knodawinbasedatabase");
#endif
                if (p_database->set_name(u2l(item->text().utf8().data())))
                {
                    databasename->setText(item->text());
                    ;
                }
                else databasename->setText("");
		open_autoform();

                set_datasource(p_database->new_resultquery());
            }
        }
    }

    set_buttons();
}


void knodamainwindowbase::open_autoform()
{
  if (p_database && p_database->form_exists(u2l(autoform.utf8().data())))
{
   hk_kdeform* w=new_form();
   w->set_database(p_database);
   w->load_form(u2l(autoform.utf8().data()));
    show();
   if (open_maximized_windows())w->showMaximized();
    else w->show();
   w->set_viewmode();
}

}

void    knodamainwindowbase::list_changes(listtype type)
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::list_changes");
#endif
    int f;
    switch (type)
    {
        case lt_query : f=ot_query;
        break;
        case lt_form : f=ot_form;
        break;
        case lt_view : f=ot_view;
        break;
        case lt_report : f=ot_report;
        break;
        case lt_table : f=ot_table;
        break;
        default : function_select();
        	  return;

    }
    if (f==ft_query && !querybutton->isChecked()) return;
    if (f==ft_form && !formbutton->isChecked()) return;
    if (f==ft_report && !reportbutton->isChecked()) return;
    function_select(f);
    set_buttons();
}


void knodamainwindowbase::set_buttons()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::set_buttons");
#endif

    if (itemslist->currentItem()>-1) set_normalbuttons();
    else   set_minimalbuttons();

    if (databasebutton->isChecked()) set_databasebuttons();
    else
    if (tablebutton->isChecked()) set_tablebuttons();
        else
        if (formbutton->isChecked()) set_formbuttons();
            else
            if (querybutton->isChecked()) set_querybuttons();
                else
                if (reportbutton->isChecked()) set_reportbuttons();

}


void knodamainwindowbase::set_databasebuttons()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::set_databasebuttons");
#endif
    startbutton->setEnabled(false);
    alterbutton->setEnabled(false);
    if (itemslist->p_popup!=NULL)
    {
        itemslist->p_popup->setItemEnabled(pm_start,false);
        itemslist->p_popup->setItemEnabled(pm_alter,false);
    }//else assert(true);
    p_startaction->setEnabled(false);
    p_alteraction->setEnabled(false);
    if (!p_connection->server_supports(hk_connection::SUPPORTS_NEW_DATABASE))
    {
        p_newaction->setEnabled(false);
        newbutton->setEnabled(false);
    }
    if (!p_connection->server_supports(hk_connection::SUPPORTS_DELETE_DATABASE))
    {
        p_deleteaction->setEnabled(false);
        deletebutton->setEnabled(false);
    }
p_renameaction->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_RENAME_DATABASE));

}


void knodamainwindowbase::set_tablebuttons()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::set_tablebuttons");
#endif
    if (itemslist->p_popup!=NULL)
    {
        itemslist->p_popup->setItemEnabled(pm_import,true);
        if(itemslist->currentItem()>-1)
            itemslist->p_popup->setItemEnabled(pm_export,true);
    } //else assert(itemslist->p_popup==NULL);
    if (!p_connection->server_supports(hk_connection::SUPPORTS_NEW_TABLE))
    {
        p_newaction->setEnabled(false);
        newbutton->setEnabled(false);
    }
    if (!p_connection->server_supports(hk_connection::SUPPORTS_DELETE_TABLE))
    {
        p_deleteaction->setEnabled(false);
        deletebutton->setEnabled(false);
    }
/*      if (!p_connection->server_supports(hk_connection::SUPPORTS_ALTER_TABLE))
   {
     p_alteraction->setEnabled(false);
     alterbutton->setEnabled(false);
   }*/
p_renameaction->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_RENAME_TABLE));

}


void knodamainwindowbase::set_querybuttons()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::set_querybuttons");
#endif
    if (itemslist->p_popup==NULL) return;
    if(itemslist->currentItem()>-1)
        itemslist->p_popup->setItemEnabled(pm_export,true);
p_renameaction->setEnabled(true);

}


void knodamainwindowbase::set_formbuttons()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::set_formbuttons");
#endif
//   newbutton->setEnabled(false);
//   itemslist->p_popup->setItemEnabled(pm_new,false);
p_renameaction->setEnabled(true);
}


void knodamainwindowbase::set_reportbuttons()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::set_reportbuttons");
#endif
    newbutton->setEnabled(true);
    if (itemslist->p_popup!=NULL)itemslist->p_popup->setItemEnabled(pm_new,true);
p_renameaction->setEnabled(true);
}


void knodamainwindowbase::set_minimalbuttons()
{
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::set_minimalbuttons");
#endif
    newbutton->setEnabled(true);
    startbutton->setEnabled(false);
    alterbutton->setEnabled(false);
    deletebutton->setEnabled(false);
    p_newaction->setEnabled(true);
    p_startaction->setEnabled(false);
    p_alteraction->setEnabled(false);
    p_deleteaction->setEnabled(false);
    p_copyaction->setEnabled(false);
    p_renameaction->setEnabled(false);
    p_databasesettingaction->setEnabled(p_database);

    if (itemslist->p_popup!=NULL)
    {
        itemslist->p_popup->setItemEnabled(pm_new,true);
        itemslist->p_popup->setItemEnabled(pm_start,false);
        itemslist->p_popup->setItemEnabled(pm_alter,false);
        itemslist->p_popup->setItemEnabled(pm_delete,false);
        itemslist->p_popup->setItemEnabled(pm_copy,false);
        itemslist->p_popup->setItemEnabled(pm_import,false);
        itemslist->p_popup->setItemEnabled(pm_export,false);
    } //else assert(itemslist->p_popup==NULL);
    if (databasename->text().isEmpty())
    {
        tablebutton->setEnabled(false);
        querybutton->setEnabled(false);
	viewbutton->setEnabled(false);
        formbutton->setEnabled(false);
        reportbutton->setEnabled(false);
    }
    else
    {
        tablebutton->setEnabled(true);
        viewbutton->setEnabled(p_connection->server_supports(hk_connection::SUPPORTS_VIEWS));
        querybutton->setEnabled(true);
        formbutton->setEnabled(true);
        reportbutton->setEnabled(true);
    }

}


void knodamainwindowbase::set_normalbuttons()
{
//	cout<<"itemslist->currentItem() "<<   itemslist->currentItem() <<endl;
#ifdef HK_DEBUG
    hkdebug("knodamainwindowbase::set_normalbuttons");
#endif
    set_minimalbuttons();
    newbutton->setEnabled(true);
    startbutton->setEnabled(true);
    alterbutton->setEnabled(!runtime_only());
    deletebutton->setEnabled(!runtime_only());
    if (itemslist->p_popup!=NULL)
    {
        itemslist->p_popup->setItemEnabled(pm_start,true);
        itemslist->p_popup->setItemEnabled(pm_alter,true);
        itemslist->p_popup->setItemEnabled(pm_delete,true);
        itemslist->p_popup->setItemEnabled(pm_copy,true);
    }
    p_newaction->setEnabled(true);
    p_alteraction->setEnabled(!runtime_only());
    p_startaction->setEnabled(true);
    p_deleteaction->setEnabled(!runtime_only());
    p_copyaction->setEnabled(true);
}


void knodamainwindowbase::newpassworddialog_selected(void)
{
    if (p_connection!=NULL) p_connection->show_newpassworddialog();
}


QPopupMenu* knodamainwindowbase::popupmenu(void)
{
    return (QPopupMenu *)p_parent->factory()->container("popup", p_parent);
}


void knodamainwindowbase::copy_clicked(void)
{
    QStoredDrag* p_drag = new QStoredDrag("application/x-hk_filecopy");
    QCString cstr =itemslist->create_draginfo().c_str();
    p_drag->setEncodedData(cstr);
    QApplication::clipboard()->setData(p_drag);

}


void knodamainwindowbase::paste_clicked(void)
{
    if(itemslist->decode_action(QApplication::clipboard()->data()))
    {
        itemslist->execute_action();
    }

}


void  knodamainwindowbase::clipboarddata_has_changed(void)
{
    if (!QApplication::clipboard()->data())
    {
        p_pasteaction->setEnabled(false);
        return;
    }

    if (QApplication::clipboard()->data()->provides("application/x-hk_filecopy"))
    {
        p_pasteaction->setEnabled(true);
    }
    else
    {

        p_pasteaction->setEnabled(false);
    }
}

hk_kdeform* knodamainwindowbase::new_form()
{

    return new hk_kdeform(NULL,0,WDestructiveClose);
}
hk_kdereport* knodamainwindowbase::new_report(void)
{
    return new hk_kdereport(NULL,0,WDestructiveClose);
}

hk_kdetable* knodamainwindowbase::new_table(void)
{
return new hk_kdetable(NULL,0,WDestructiveClose);
}

hk_kdequery* knodamainwindowbase::new_query(void)
{
return new hk_kdequery(NULL,0,WDestructiveClose);
}


hk_kdequery* knodamainwindowbase::new_view(void)
{
return new hk_kdequery(NULL,0,WDestructiveClose);
}



bool knodamainwindowbase::eventFilter(QObject* object, QEvent* event)
{
   /*if (	object==itemslist&&p_workspace&&
   	  parentWidget()&&
	  parentWidget()->isShown() &&
	  parentWidget()->isMaximized())
  {
   // parentWidget()->hide();
   //parentWidget()->show();
  }*/

    return QWidget::eventFilter(object,event);
}

void knodamainwindowbase::databasesettings_clicked(void)
{
hk_kdedatabasesetting* setting=new hk_kdedatabasesetting(p_database);
 if (setting->exec()==QDialog::Accepted)
      function_select();
 delete setting;
}



void knodamainwindowbase::objecthandler_clicked(void)
{
  hk_kdeobjecthandler* h=new hk_kdeobjecthandler(p_database);
  h->exec();
  delete h;
}


void knodamainwindowbase::slot_open_localdatabase(void)
{
  if (!p_connection) return;
  QStringList l;
  QString xmime=QString::fromUtf8(l2u(p_connection->mimetype()).c_str());
  l.append(xmime);cerr <<"add xmime:"<<xmime<<endl;
  l.append("all/allfiles");
KFileDialog* d=new KFileDialog(QString::null,QString::null,this,0,true);
d->setMimeFilter(l,xmime);
d->exec();
QString filename=d->selectedFile();
  if (!filename.isNull())
  {
     itemslist->blockSignals(true);
     itemslist->insertItem(filename);
     itemslist->blockSignals(false);
  }
     databasename->setText(filename);


  if (!p_database)p_database=p_connection->new_database();
  if (p_database!=NULL)
    {
     p_database->set_name(u2l(filename.utf8().data()));
    }



     function_select(ot_database);
delete d;
}


void knodamainwindowbase::show_exportdbdrivers()
{
 KPopupMenu* menu= p_exportdatabaseaction->popupMenu();
   show_drivers(menu,f_exportdb);

}

void knodamainwindowbase::show_importdbdrivers()
{
 KPopupMenu* menu= p_importdatabaseaction->popupMenu();
   show_drivers(menu,f_importdb);

}
void knodamainwindowbase::show_drivers(KPopupMenu* menu,enum_function f)
{
   if (!menu) return;
  menu->clear();
    vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    int di=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        switch (f)
	{
	 case f_exportdb:
	                menu->insertItem(QString::fromUtf8(l2u((*it)).c_str()),this,SLOT(exportdbdriver_selected(int)),0,di);
	 		break;
	 case f_importdb:
	                menu->insertItem(QString::fromUtf8(l2u((*it)).c_str()),this,SLOT(importdbdriver_selected(int)),0,di);
	 		break;
	}
        di++;
    }


}


void knodamainwindowbase::exportdbdriver_selected(int index)
{
   vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    hk_string drvname;
    int di=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        if (di==index)
	{
	     drvname=(*it);
	     break;

	}
        di++;
    }
     if (drvname.size()==0) return;


 hk_connection* con=p_database->connection()->drivermanager()->new_connection(drvname);
 if (con!=NULL)
  {
  	if (!con->show_passworddialog())
       	{
      	delete con;
        return;
      	}
       if (con->server_needs(hk_connection::NEEDS_DATABASENAME))
	   {
	     //internal_set_database(con->defaultdatabase());
	   }
       if (con->connect())
        {
	   hk_kdeeximportdatabase* dialog=new   hk_kdeeximportdatabase(p_database,con,hk_kdeeximportdatabase::m_export);
	   dialog->exec();
           delete dialog;
	}

   delete con;

   }




}


void knodamainwindowbase::importdbdriver_selected(int index)
{
  vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    hk_string drvname;
    int di=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        if (di==index)
	{
	     drvname=(*it);
	     break;

	}
        di++;
    }
     if (drvname.size()==0) return;

 hk_connection* con=p_database->connection()->drivermanager()->new_connection(drvname);
 if (con!=NULL)
  {
  	if (!con->show_passworddialog())
       	{
      	delete con;
        return;
      	}
       if (con->server_needs(hk_connection::NEEDS_DATABASENAME))
	   {
	     //internal_set_database(con->defaultdatabase());
	   }
       if (con->connect())
        {
	   hk_kdeeximportdatabase* dialog=new   hk_kdeeximportdatabase(p_database,con,hk_kdeeximportdatabase::m_import);
	   dialog->exec();
           delete dialog;
	}

   delete con;

   }



}

void knodamainwindowbase::slot_store_connection()
{
  if (!p_database) return;
  QStringList l;
  QString xmime="application/x-hk_connection";
  l.append(xmime);cerr <<"add xmime:"<<xmime<<endl;
KFileDialog* d=new KFileDialog(QString::null,QString::null,this,0,true);
d->setMimeFilter(l,xmime);
d->setOperationMode(KFileDialog::Saving);
d->exec();
QString filename=d->selectedFile();
  if (!filename.isNull())
  {
   p_database->store_connectionfile(u2l(filename.utf8().data()));
  }
delete d;
}


void knodamainwindowbase::slot_referentialintegrity()
{
    if (!p_designer)
       p_designer=new hk_kdedbdesignerwindow();
//    connect (p_designer,SIGNAL(signal_closed()),this,SLOT(designer_deleted()));
    p_designer->designer()->set_database(p_database);
    hk_referentialintegrity* rf=new hk_referentialintegrity();
    rf->set_database(p_database);
    rf->load_referentialintegrity();
    p_designer->designer()->set_presentation(rf);
    //set_block_has_changed(true);
    p_designer->show();
    //set_block_has_changed(false);
    connect (p_designer,SIGNAL(signal_closed()),this,SLOT(designer_deleted()));

}

void knodamainwindowbase::designer_deleted(void)
{
cerr<<"designer_deleted"<<endl;

p_designer=NULL;
}

