// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.29 $

#include "hk_kdecsvimportdialog.h"
#include "hk_kdecsvimportdialog.moc"
#include <hk_database.h>

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qtable.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qprogressdialog.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <qapplication.h>
#include <qframe.h>
#include <kapplication.h>
#include <kconfig.h>

/*
 *  Constructs a hk_kdecsvimportdialog which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */



bool    hk_kdecsvimportdialog::p_cancelimport=false;
QProgressDialog* hk_kdecsvimportdialog::p_progressdialog=NULL;


hk_kdecsvimportdialog::hk_kdecsvimportdialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
: hk_kdecsvimportdialogbase( parent, name, modal, fl ),hk_importcsv()
{
    moreframe->hide();
    if ( !name )
        setName( "hk_kdecsvimportdialog" );
    setCaption( i18n( "CSV Import Dialog"  ) );
    TextLabel1->setText( i18n( "Filename:"  ) );
    TextLabel3->setText( i18n( "Text delimiter"  ) );
    TextLabel1_3->setText( i18n( "Field names in first row"  ));
    textdelimiterfield->setText( "\""   );
    TextLabel1_2->setText( i18n("Tablename:"  ) );
    TextLabel2->setText( i18n("Column Separator"  ));
    p_tab=i18n("Tab");
    columnseparatorfield->setEditable(true);
    columnseparatorfield->insertItem(  ","  );
    columnseparatorfield->insertItem(  ";"  );
    columnseparatorfield->insertItem(  "|"  );
    columnseparatorfield->insertItem( p_tab);
    timeformatfield->setText(QString::fromUtf8(l2u(defaulttimeformat()).c_str()));
    dateformatfield->setText(QString::fromUtf8(l2u(defaultdateformat()).c_str()));
    datetimeformatfield->setText(QString::fromUtf8(l2u(defaultdatetimeformat()).c_str()));
    for (unsigned int i=0;i<sizeof(charsets)/sizeof(hk_string);++i)
    {
    charsetfield->insertItem(QString::fromUtf8(l2u(charsets[i]).c_str()));
    }

    for (unsigned int i=0;i<sizeof(locales)/sizeof(hk_string);++i)
    {
    localefield->insertItem(QString::fromUtf8(l2u(locales[i]).c_str()));
    }

    charsetfield->setCurrentText(QString::fromUtf8(l2u(filecharset()).c_str()));
    localefield->setCurrentText(QString::fromUtf8(l2u(filelocale()).c_str()));
    buttonOk->setText( i18n( "&OK"  ) );
    buttonCancel->setText( i18n( "&Cancel"  ) );
    buttonHelp->setText( i18n( "&Help"  ));
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("CSVImport");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);
  previewtable->adjustSize();
}


hk_kdecsvimportdialog::~hk_kdecsvimportdialog()
{
// no need to delete child widgets, Qt does it all for us
//    delete p_import;
}


void hk_kdecsvimportdialog::ok_clicked(void)
{
//  wanna_debug(true);
    set_filename(u2l(filefield->text().utf8().data()));
    datasource()->set_name(u2l(tablename->currentText().utf8().data()));
    set_firstrow_contains_fieldnames(firstrow->isChecked());
    QString sep=columnseparatorfield->currentText();
    set_progressdialog(&hk_kdecsvimportdialog::set_progress);
    if (sep==p_tab) sep="\t";
    set_detect_autoinc(autoincfield->isChecked());
    set_filedefinition(u2l(textdelimiterfield->text().utf8().data()),u2l(sep.utf8().data()),"\n",u2l(datetimeformatfield->text().utf8().data()),u2l(dateformatfield->text().utf8().data()),u2l(timeformatfield->text().utf8().data())
    ,u2l(charsetfield->currentText().utf8().data()),u2l(localefield->currentText().utf8().data()));
    set_append_rows(appendrows->isChecked());
    before_execute();
    bool r=execute();
    after_execute();
    if (r ) accept();
    KConfig* c=kapp->config();
  c->setGroup("CSVImport");
  c->writeEntry("Geometry",geometry());

}


void hk_kdecsvimportdialog::filebutton_clicked()
{

    p_file = KFileDialog::getOpenFileName( ":csv", QString::null, this,i18n("Select a CSV file"));
    filefield->setText(p_file);
}


void hk_kdecsvimportdialog::buttons_enabled()
{
    if (    !filefield->text().isEmpty()
        &&!columnseparatorfield->currentText().isEmpty()
        &&!tablename->currentText().isEmpty()
        )
        buttonOk->setEnabled(true);
    else buttonOk->setEnabled(false);
    autoincfield->setEnabled(!appendrows->isChecked());
    set_tablepreview();

}


void    hk_kdecsvimportdialog::before_execute(void)
{
    p_cancelimport=false;
p_progressdialog= new  QProgressDialog(this,NULL,true);
   p_progressdialog->setCaption(i18n("Importing data..."));
   p_progressdialog->setTotalSteps(100);
   connect(p_progressdialog,SIGNAL(cancelled()),this,SLOT(printing_cancelled()));
   p_progressdialog->show();
   qApp->processEvents();
}


void    hk_kdecsvimportdialog::after_execute(void)
{
  delete p_progressdialog;
  p_progressdialog=NULL;
}


bool hk_kdecsvimportdialog::set_progress(long int position,long int total,const hk_string&txt)
{
    if (p_progressdialog)
    {

        p_progressdialog->setCaption(QString::fromUtf8(l2u(txt).c_str()));
        p_progressdialog->setTotalSteps(total);
        p_progressdialog->setProgress(position);
        p_progressdialog->raise();
        qApp->processEvents();
    }
    return p_cancelimport;
}


void hk_kdecsvimportdialog::printing_cancelled(void)
{
    cout <<"cancelclicked"<<endl;
    p_cancelimport=true;

}

void hk_kdecsvimportdialog::morebutton_clicked()
{
    
    if (morebutton->state()==QButton::Off)
     moreframe->hide();
     else
     moreframe->show();
//adjustSize();
}

bool hk_kdecsvimportdialog::widget_specific_after_new_row(void)
{
/*  if (p_progressdialog!=NULL)
  {
     p_progressdialog->setProgress(datasource()->row_position());
  }
  qApp->processEvents();*/

    return !p_cancelimport;
}

void hk_kdecsvimportdialog::keyPressEvent ( QKeyEvent * e )
{
  if (e->key()==Key_F1) help_clicked();
}



void hk_kdecsvimportdialog::help_clicked()
{
kapp->invokeHelp("importcsv");
}



void hk_kdecsvimportdialog::set_tablepreview()
{
   previewtable->setNumRows(0);
 if (filefield->text().isEmpty())
 {
   previewtable->setNumCols(0);
   return;
 }
    QString sep=columnseparatorfield->currentText();
    if (sep==p_tab) sep="\t";
    set_filedefinition(u2l(textdelimiterfield->text().utf8().data()),u2l(sep.utf8().data()),"\n",u2l(datetimeformatfield->text().utf8().data()),u2l(dateformatfield->text().utf8().data()),u2l(timeformatfield->text().utf8().data())
    ,u2l(charsetfield->currentText().utf8().data()),u2l(localefield->currentText().utf8().data()));
 hk_string sbuffer;
 ifstream* p_filestream=new ifstream(u2l(filefield->text().utf8().data()).c_str(),ios::in);
 vector<hk_string>* l=NULL;
 if (firstrow->isChecked())
   {
    get_line(*p_filestream,sbuffer);
    l=create_valuelist(sbuffer);
    previewtable->setNumCols(l->size());
    vector<hk_string>::iterator it=l->begin();
    int i=0;
    while (it!=l->end())
    {
      previewtable->horizontalHeader()->setLabel(i,QString::fromUtf8(l2u(*it).c_str()));
      ++it;++i;
    }

   }

    const int maxpreview=5;
    bool eof=false;
    int i=0;
    for (i=0;i<maxpreview &&!eof;++i)
     {
        if (!p_filestream->eof())
        {
        get_line(*p_filestream,sbuffer);           //zweite bis maxpreview Datenzeile einlesen
        l=create_valuelist(sbuffer);
        if (l->size()>(unsigned int)previewtable->numCols())
           previewtable->setNumCols(l->size());

        previewtable->setNumRows(previewtable->numRows()+1);
        vector<hk_string>::iterator it=l->begin();
        int i=0;
        while (it!=l->end())
        {
          previewtable->setText(previewtable->numRows()-1,i,QString::fromUtf8(l2u(*it).c_str()));
          ++it;++i;
        }


        }
        else eof=true;//eof

     }

 if (!firstrow->isChecked())
   {
    if (appendrows->isChecked())
    {
    for (int i=0;i<previewtable->numCols() ;)
    {
      QString n;
      n.setNum(i+1);
      previewtable->horizontalHeader()->setLabel(i,n);
      ++i;
    }

    }
    else
    {
    for (int i=0;i<previewtable->numCols();++i)
    {
      QString f;
      f.setNum(i);
      f=i18n("field_")+f;
      previewtable->horizontalHeader()->setLabel(i,f);
    }
    }
   }

 delete p_filestream;
}


void hk_kdecsvimportdialog::set_datasource(hk_datasource* d)
{
 hk_importcsv::set_datasource(d);
   tablename->clear();
 if (d)
 {
   vector<hk_string>* tbl=d->database()->tablelist();
   tablename->insertItem("");
   vector<hk_string>::iterator it=tbl->begin();
   while (it!=tbl->end())
   {
     tablename->insertItem(QString::fromUtf8(l2u(*it).c_str()));
     ++it;
   }
 }
}

