// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.51 $
#include <assert.h>
#include "hk_kdedbdesigner.h"
#include "hk_kdeformdatasourcedialog.h"
#include "hk_kderelationdialog.h"
#include "hk_kdeaddtabledialog.h"
#include <hk_presentation.h>
#include <hk_datasource.h>
#include <hk_dsdatavisible.h>
#include <hk_referentialintegrity.h>
#include <list>
#include <qscrollview.h>
#include <qlistbox.h>
#include <qlayout.h>
#include <qcolor.h>
#include <qpalette.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qptrlist.h>
#include <qbitmap.h>
#include <qpopupmenu.h>
#include <qcursor.h>
#include <qpushbutton.h>
#include <qtable.h>
#include <qapplication.h>
#include <qdragobject.h>
#include <qtooltip.h>
#include <klocale.h>
#include <kglobalsettings.h>
#include <klibloader.h>
#include <kstandarddirs.h>
#include <kiconloader.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kaccelmanager.h>
#include <kglobal.h>
#include <kiconloader.h>


const int designwidth=3000;
const int designheight=3000;

class hk_kdescrollview: public QScrollView
{
public:
  hk_kdescrollview(hk_kdedbdesigner* parent=0,const char* name=0,WFlags f=0):QScrollView(parent,name,f)
  {
   p_designer=parent;
  }

  virtual void contentsContextMenuEvent(QContextMenuEvent* q)
  		{
			QPopupMenu* context=new QPopupMenu(this);
			int id[3];
			id[0]=context->insertItem(i18n("Add datasource"));
			int res=context->exec(QCursor::pos());
			if (res==id[0])
			{
				p_designer->add_datasource();
			}
			q->accept();
		}
hk_kdedbdesigner* p_designer;
};



class hk_kdedbdesignerprivate
{
public:
hk_kdedbdesignerprivate( hk_kdedbdesigner* designer)
	{
		p_designer=designer;
		p_layout=new QVBoxLayout(designer);
		p_scrollview=new hk_kdescrollview(designer);
		p_layout->addWidget(p_scrollview);
		p_scrollview->viewport()->setPaletteBackgroundColor(p_scrollview->colorGroup().mid());
		p_scrollview->setVScrollBarMode(QScrollView::AlwaysOn);
		p_scrollview->setHScrollBarMode(QScrollView::AlwaysOn);

		p_presentation=NULL;
		p_datasources=NULL;
	}
virtual ~hk_kdedbdesignerprivate()
	{

	}
QVBoxLayout*	p_layout;
hk_kdescrollview* p_scrollview;
hk_kdedbdesigner* p_designer;
hk_presentation* p_presentation;
		list<hk_datasource*>* p_datasources;
list<hk_kdedatasourceframe*> p_windowlist;
list<hk_kdedbrelation*> p_relationlist;
};




kdedatasourcelabel::kdedatasourcelabel(hk_kdedatasourceframe* w):QLabel(w)
{
 p_drag=false;
 p_startx=p_starty=p_offsetx=p_offsety=0;
 setFocusPolicy(QWidget::ClickFocus);
 setPaletteBackgroundColor(palette().inactive().background());
 setPaletteForegroundColor(palette().inactive().text());
 p_datasourceframe=w;
  setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Fixed);
#if KDE_VERSION_MAJOR >=3 && KDE_VERSION_MINOR >=4
  KAcceleratorManager::setNoAccel(this);
#endif
}


void kdedatasourcelabel::mouseMoveEvent(QMouseEvent* event)
{

if (p_drag && event->state()==Qt::LeftButton)
  {
   QPoint localPos=event->globalPos();
   int xdiff=localPos.x()-p_startx;
   int ydiff=localPos.y()-p_starty;
   if ((abs(xdiff)>2) || (abs(ydiff)>2))
     {
 	QPoint newPos=p_datasourceframe->designer()->scrollview()->viewportToContents(parentWidget()->pos())+QPoint(xdiff,ydiff);
	if (newPos.x()<0)
	{
	  p_offsetx+=newPos.x();
	  newPos.setX(0);
	}
	else
	if (p_offsetx<0)
	 {
	   p_offsetx+=newPos.x();
	   if (p_offsetx>0)
		{
		newPos.setX(p_offsetx);
		p_offsetx=0;
		}
	   else newPos.setX(0);
	 }
	if (newPos.y()<0)
	 {
		p_offsety+=newPos.y();
		newPos.setY(0);
	 }
	else
	 if (p_offsety<0)
	  {
		p_offsety+=newPos.y();
		if (p_offsety>0)
		 {
		   newPos.setY(p_offsety);
		   p_offsety=0;
		 }
		else newPos.setY(0);
	  }
	p_datasourceframe->designer()->scrollview()->moveChild(parentWidget(),newPos.x(),newPos.y());
	p_startx=localPos.x();
	p_starty=localPos.y();
    }

   }
}


void kdedatasourcelabel::mousePressEvent(QMouseEvent* event)
	{
	p_datasourceframe->designer()->new_focus(p_datasourceframe);
	if (event->button()==Qt::LeftButton)
	   {
		p_drag=true;
		p_startx=event->globalPos().x();
		p_starty=event->globalPos().y();
		p_offsetx=p_offsety=0;
	   }

	}


void kdedatasourcelabel::mouseReleaseEvent(QMouseEvent* event)
	{
	if (event->button()==Qt::LeftButton)
	   {
		p_drag=false;
	   }

	}






hk_kdefieldlist::hk_kdefieldlist(hk_kdedatasourceframe* parent):QListBox(parent)
{
  p_datasourceframe=parent;
  setAcceptDrops(true);
  setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::Preferred);

  //setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred);
  connect(this,SIGNAL(signal_field_doubleclicked(int, const hk_string&)),p_datasourceframe->designer(),SLOT(slot_field_doubleclicked(int, const hk_string&)));
}

void hk_kdefieldlist::setFocus(void)
	{
		p_datasourceframe->designer()->new_focus(p_datasourceframe);
		QListBox::setFocus();
	}

void hk_kdefieldlist::clearFocus(void)
	{
		parentWidget()->clearFocus();
		QListBox::clearFocus();
	}






void hk_kdefieldlist::mouseDoubleClickEvent(QMouseEvent* event)
{
QString field;
QListBoxItem* item=itemAt(event->pos());
if (item)
{
   field=item->text();
}
if (p_datasourceframe->designer()->presentation()->presentationtype()!=hk_presentation::qbe)
   p_datasourceframe->edit();
if (!field.isEmpty())
   emit signal_field_doubleclicked(p_datasourceframe->datasource()->presentationnumber(),u2l(field.utf8().data()));
}




void hk_kdefieldlist::mouseMoveEvent(QMouseEvent* event)
{
   int mindragdist =KGlobalSettings::dndEventDelay();
    if (event->state() &Qt::LeftButton
        &&(
        event->pos().x() >p_dragstartposition.x() +mindragdist
        ||event->pos().x() <p_dragstartposition.x() -mindragdist
        ||event->pos().y() >p_dragstartposition.y() +mindragdist
        ||event->pos().y() <p_dragstartposition.y() -mindragdist

        ))
    {
// dragging begins
        QStoredDrag* p_drag = new QStoredDrag("application/x-hk_kdedbdesigner",this);
	QString n;
	//cerr <<"drag wert="<<index(itemAt(event->pos()))<<endl;
	n.setNum(p_datasourceframe->datasource()->presentationnumber());
	n="<VUPN>"+n+"</VUPN>\n<VALUE>"+( itemAt(event->pos())?itemAt(event->pos())->text():QString("")) +"</VALUE>\n";
	//cerr<<"dragwert"<<n<<endl;
        QCString cstr =n.utf8();
	//cerr<"cstr"<<cstr<<endl;
        p_drag->setEncodedData(cstr);
        p_drag->dragCopy();

    }

}

void hk_kdefieldlist::mouseReleaseEvent(QMouseEvent*)
{
}

void hk_kdefieldlist::dragEnterEvent(QDragEnterEvent* event)
{
    event->accept(event->provides("application/x-hk_kdedbdesigner")&&
    (p_datasourceframe->designer()->presentation()->presentationtype()==hk_presentation::referentialintegrity
     ||(p_datasourceframe->designer()->presentation()->presentationtype()!=hk_presentation::referentialintegrity &&event->source()!=this )));

}

void hk_kdefieldlist::dropEvent(QDropEvent* event)
{
   if (!event->encodedData("application/x-hk_kdedbdesigner")) return;
   hk_string eventtxt=u2l(event->encodedData("application/x-hk_kdedbdesigner").data());
   long mastervupn;
   hk_string mastertxt;
   if (!(     hk_class::get_tagvalue(eventtxt,"VUPN",mastervupn)
         && hk_class::get_tagvalue(eventtxt,"VALUE",mastertxt)))
	 {
            hk_class::show_warningmessage("Error in drag&drop protocol");
              cerr <<eventtxt<<endl;
		return;
	 }

      hk_datasource* masterds=p_datasourceframe->designer()->presentation()->get_datasource(mastervupn);
      hk_kdedbrelation* r=	p_datasourceframe->designer()->get_relation(
      					p_datasourceframe->designer()->get_dsframe(masterds),
					p_datasourceframe);
      if (r)
      	{
		r->edit();
		return;
	}



   hk_kderelationdialog* d = new hk_kderelationdialog(
   						p_datasourceframe->designer()->get_dsframe(masterds),
         p_datasourceframe,p_datasourceframe->designer());

	((QComboTableItem*)(d->grid->item(0,0)))->setCurrentItem(d->masterindex(QString::fromUtf8(l2u(mastertxt).c_str())));
	if(itemAt(event->pos()))((QComboTableItem*)(d->grid->item(0,1)))->setCurrentItem(d->slaveindex(itemAt(event->pos())->text()));
/*	if (((QComboTableItem*)(d->grid->item(0,0)))->currentItem()>0
	    && ((QComboTableItem*)(d->grid->item(0,1)))->currentItem()>0
	   ) d->add_row();*/d->slot_data_changed(0,0);


     if (d->exec()==QDialog::Accepted)
       {
        if(p_datasourceframe->designer()->presentation()->presentationtype()==hk_presentation::referentialintegrity)
        {
        p_datasourceframe->designer()->set_all_relations();
        }
        else
          p_datasourceframe->designer()->add_relation(masterds,p_datasourceframe->datasource());

       }

    delete d;


}



void hk_kdefieldlist::contextMenuEvent(QContextMenuEvent* event)
{
QPopupMenu* context=new QPopupMenu(this);
int id[3];
id[0]=context->insertItem(i18n("Edit"));
id[1]=context->insertItem(i18n("Delete"));
int res=context->exec(QCursor::pos());

if (res==id[0])
	{
		p_datasourceframe->edit();
	}
else
if (res==id[1])
	{
		p_datasourceframe->designer()->delete_datasource(p_datasourceframe);
	}
delete context;
event->accept();

}










hk_kdedatasourceframe::hk_kdedatasourceframe(hk_kdedbdesigner* designer,QWidget* parent,hk_datasource* ds):
	QFrame(parent)
	,hk_dsdatavisible()
{
	p_designer = designer;
	set_datasource(ds);
	setFrameStyle( QFrame::WinPanel | QFrame::Raised );
	p_layout=new QGridLayout(this,3/*rows*/,2/*cols*/,1/*margin*/,0/*space*/);
	QSize s=QSize(150,150);
   	setMinimumSize(s);
   	setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);

	p_listbox=new hk_kdefieldlist(this);
	p_header=new kdedatasourcelabel(this);
        p_listbox->installEventFilter(this);
	p_header->installEventFilter(this);
	installEventFilter(this);
	p_layout->addWidget(p_header,0,0);
	p_layout->addWidget(p_listbox,1,0);
	hk_kdemovewidget* mv=new  hk_kdemovewidget(hk_kdemovewidget::horizontal,this);
	p_layout->addWidget(mv,2,0);
	mv=new  hk_kdemovewidget(hk_kdemovewidget::vertical,this);
	p_layout->addWidget(mv,0,1);
	mv=new  hk_kdemovewidget(hk_kdemovewidget::vertical,this);
	p_layout->addWidget(mv,1,1);
	mv=new  hk_kdemovewidget(hk_kdemovewidget::diagonal,this);
	p_layout->addWidget(mv,2,1);

	p_positionupdate=true;
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    keyicon=loader->loadIcon("key",KIcon::User);
	set_fields();
	if (ds)
	{
		setGeometry(ds->x(),ds->y(),ds->width(),ds->height());
	}
	else 	setGeometry(20,20,150,150);
	p_designer->scrollview()->moveChild(this,QWidget::x(),QWidget::y());
	p_positionupdate=false;


}



bool hk_kdedatasourceframe::eventFilter(QObject* object,QEvent* e)
{
 QKeyEvent* event=dynamic_cast<QKeyEvent*>(e);
 if (event  && event->key()==Qt::Key_Delete && event->type()==QEvent::KeyRelease && datasource())
   {
       if (show_yesnodialog(replace_all(
       		"%1",hk_translate("Remove datasource '%1'?"),
		p_designer->presentation()->unique_datasourcename(datasource()->presentationnumber()))
		,true))
       {
       		designer()->delete_datasource(this);
       //event->accept();
       return true;
       }
   }
return QFrame::eventFilter(object,e);
}



void hk_kdedatasourceframe::set_fields(void)
{
	  if (!datasource())
	   {
	    cerr <<"hk_kdedatasourceframe::set_fields, NO DATASOURCE SET !!!"<<endl;
	    return;
	   }
	  list<hk_string>* cols=datasource()->columnnames();
	  if (!cols) return;
	  if (p_designer->presentation()->presentationtype()==hk_presentation::qbe)
	     p_listbox->insertItem("*");
	  list<hk_string>::iterator it=cols->begin();
	  while (it!=cols->end())
	  {
	  	hk_column* c=datasource()->column_by_name(*it);
	  	if (c &&c->is_primary())
	  	{
	  	  p_listbox->insertItem(keyicon,QString::fromUtf8(l2u((*it)).c_str()));
	  	}
	  	else
	  	  p_listbox->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
		++it;
	  }
	  set_header();
}




void hk_kdedatasourceframe::set_header(void)
{
	 if (!datasource()) return;
	 QString headertext;
	 switch(p_designer->presentation()->presentationtype())
	 {
	  case hk_presentation::qbe 	:headertext=QString::fromUtf8(l2u(p_designer->presentation()->unique_shortdatasourcename(datasource()->presentationnumber())).c_str());
	  				break;
	  default : headertext=QString::fromUtf8(l2u(p_designer->presentation()->unique_datasourcename(datasource()->presentationnumber())).c_str());
	 }
	 p_header->setText(headertext);
	 int w=QFrame::width();
	 adjustSize();
	 if (w<QFrame::width())
	    setMinimumWidth(QFrame::width());

}




void hk_kdedatasourceframe::set_focus(hk_kdedatasourceframe* f)
{
   if (f==this)
   {
	p_header->setPaletteBackgroundColor(palette().active().highlight());
	p_header->setPaletteForegroundColor(palette().active().highlightedText());
	setFocus();
   }
   else
   {
	p_header->setPaletteBackgroundColor(palette().inactive().background());
	p_header->setPaletteForegroundColor(palette().inactive().text());
   }
//setFocus();
}


void hk_kdedatasourceframe::setFocus(void)
	{
		//set_focus(this);
		QFrame::setFocus();

	}

void hk_kdedatasourceframe::clearFocus(void)
	{
		p_header->clearFocus();
		QFrame::clearFocus();
//	setPaletteBackgroundColor(palette().active().highlight());
//	setPaletteForegroundColor(palette().active().highlightedText());

	}

void hk_kdedatasourceframe::mousePressEvent(QMouseEvent*)
{

}

void hk_kdedatasourceframe::moveEvent(QMoveEvent*)
{
 set_new_position();
}


void hk_kdedatasourceframe::resizeEvent(QResizeEvent*)
{
 set_new_position();
}

void hk_kdedatasourceframe::set_new_position(void)
{
hk_datasource* ds=datasource();
if (!ds||p_positionupdate) return;
ds->set_position(QWidget::x(),QWidget::y(),false);
ds->set_size(QWidget::width(),QWidget::height());
emit signal_moved();
}



hk_kdedbdesigner* hk_kdedatasourceframe::designer(void) const
{
  return p_designer;
}



void hk_kdedatasourceframe::edit(void)
{
    hk_kdeformdatasourcedialog* d = new hk_kdeformdatasourcedialog(designer()->presentation(),this,0,true);
    hk_kdeformdatasourcedialog::enum_displaytype dp=hk_kdeformdatasourcedialog::d_form;
    if (designer()->presentation()->presentationtype()!=hk_presentation::form)
    dp=(designer()->presentation()->presentationtype()==hk_presentation::report?
        hk_kdeformdatasourcedialog::d_report:
	hk_kdeformdatasourcedialog::d_query);
    d->set_displaytype(dp);
    d->set_edittype(hk_kdeformdatasourcedialog::e_modify);
    d->set_datasource(datasource());
    hk_datasource* depdatasource=NULL;
    if (datasource())depdatasource=datasource()->depending_on();
    d->alterbutton->setEnabled(true);
    d->Addbutton->setEnabled(false);
    d->deletebutton->setEnabled(true);
    d->set_allow_delete_datasource(false);
    d->exec();
    if (d->clicked_button()==hk_kdeformdatasourcedialog::cb_delete)
        {
	   designer()->delete_datasource(this);
	   delete datasource();
	   return;
	}
	else
	// datasource still exists, so set the perhaps changed relation
    if (depdatasource &&!d->datasource()->depending_on())
       { //old relation is not needed any more
	   designer()->delete_relation(designer()->get_relation(depdatasource,datasource()));
       }
    else
    if (depdatasource && depdatasource!=d->datasource()->depending_on())
    	{ //old relation exists, but linked to the wrong master datasource
           hk_kdedbrelation* relation=designer()->get_relation(depdatasource,datasource());
	   if (relation)
	   	{
			relation->set_datasources(designer()->get_dsframe(datasource()->depending_on()),this);
		}
	}
     else
     if (!depdatasource && d->datasource()->depending_on())
     	{//no relation exists, but a new one is set
		designer()->add_relation(d->datasource()->depending_on(),datasource());
	}

    delete d;


}




//   HK_KDEDBDESIGNER BEGINN


 hk_kdedbdesigner::hk_kdedbdesigner(QWidget* parent):QWidget(parent),hk_dbvisible()
{
  p_private=new hk_kdedbdesignerprivate(this);
  setGeometry(QWidget::x(),QWidget::y(),600,500);
  p_private->p_scrollview->resizeContents(designwidth,designheight);
}



hk_kdedbdesigner::~hk_kdedbdesigner()
{
delete p_private->p_layout;
delete p_private->p_scrollview;
delete p_private;
}




QScrollView* hk_kdedbdesigner::scrollview(void) const
{
return p_private->p_scrollview;
}




void hk_kdedbdesigner::set_presentation(hk_presentation * p)
{
p_private->p_presentation =p;
p_private->p_datasources=NULL;
clear_datasources();
if (!p_private->p_presentation) return;
p_private->p_datasources=p_private->p_presentation->datasources();
set_datasources();
}




hk_presentation* hk_kdedbdesigner::presentation(void)
{
return p_private->p_presentation;
}





void hk_kdedbdesigner::clear_datasources()
{
 if (!p_private->p_datasources)return;
}





hk_kdedatasourceframe* hk_kdedbdesigner::get_dsframe(hk_datasource* ds)
{
  if (!ds) return NULL;
  list<hk_kdedatasourceframe*>::iterator it=p_private->p_windowlist.begin();
while (it!=p_private->p_windowlist.end())
  	{
	   if ((*it)->datasource()==ds)
	   	{
		  return (*it);
		}
	   ++it;
	}
return NULL;
}





hk_kdedbrelation* hk_kdedbdesigner::get_relation(hk_datasource* master,hk_datasource* slave)
{
  if (!master ||!slave) return NULL;
  list<hk_kdedbrelation*>::iterator it=p_private->p_relationlist.begin();
while (it!=p_private->p_relationlist.end())
  	{
	   if ((*it)->masterdatasource()->datasource()==master && (*it)->slavedatasource()->datasource()==slave)
	   	{
		  return (*it);
		}
	   ++it;
	}
return NULL;
}


hk_kdedbrelation* hk_kdedbdesigner::get_relation(hk_datasource* ds)
{
  if (!ds) return NULL; 
  list<hk_kdedbrelation*>::iterator it=p_private->p_relationlist.begin();
while (it!=p_private->p_relationlist.end())
  	{
	   if ((*it)->masterdatasource()->datasource()==ds|| (*it)->slavedatasource()->datasource()==ds)
	   	{
		  return (*it);
		}
	   ++it;
	}
return NULL;

}


referentialclass* hk_kdedbdesigner::get_referentialintegrity(hk_datasource* master,hk_datasource* slave)
{
  if (!master ||!slave) return NULL;
list <referentialclass>* rl= slave->referenceslist();
list <referentialclass>::iterator rit=rl->begin();
 while (rit!=rl->end())
 {
     if ((*rit).p_masterdatasource==master->name())
     {
       referentialclass* r=new referentialclass;
       *r=*rit;
       return r;
      }
   ++rit;
 }
return NULL;
}






hk_kdedbrelation* hk_kdedbdesigner::get_relation(hk_kdedatasourceframe* master, hk_kdedatasourceframe* slave)
{
 if (!master ||!slave) return NULL;
  return get_relation(master->datasource(),slave->datasource());

}

void hk_kdedbdesigner::new_focus(hk_kdedatasourceframe* f)
{
  list<hk_kdedatasourceframe*>::iterator it=p_private->p_windowlist.begin();
while (it!=p_private->p_windowlist.end())
  	{
	   (*it)->set_focus(f);
	   ++it;
	}

	if (f)
	  {
	    f->raise();
	    relation_clicked(NULL);
	  }

}






void hk_kdedbdesigner::set_datasources()
{
 if (!p_private->p_datasources)
 	{
	 return;
	}
  bool bf=p_private->p_presentation->block_has_changed();
 p_private->p_presentation->set_block_has_changed(true);
 list<hk_datasource*>::iterator it=p_private->p_datasources->begin();
 hk_kdedatasourceframe* firstframe=NULL;
 while (it!=p_private->p_datasources->end())
 {
    hk_kdedatasourceframe* f=add_dsframe((*it));
    if (!firstframe) firstframe=f;

  ++it;
  }
   set_all_relations();

   p_private->p_presentation->set_block_has_changed(bf);
   new_focus(firstframe);
}


void hk_kdedbdesigner::set_all_relations(void)
{
  list<hk_kdedbrelation*>::iterator relit=p_private->p_relationlist.begin();
  while (relit!=p_private->p_relationlist.end())
  {
  hk_kdedbrelation* i=(*relit);
  ++relit;
  delete i;
  }
  p_private->p_relationlist.clear();

  list<hk_kdedatasourceframe*>::iterator sit=p_private->p_windowlist.begin();
  while (sit!=p_private->p_windowlist.end())
  	{
	 hk_datasource* ds=(*sit)->datasource();
         if(p_private->p_presentation->presentationtype()==hk_presentation::referentialintegrity)
         {
          list <referentialclass>* rl= ds->referenceslist();

          list <referentialclass>::iterator rit=rl->begin();
          while (rit!=rl->end())
          {
                add_referentialintegrity((*rit),(*sit));
            ++rit;
          }
         }
         else
         {
	   if (ds && ds->depending_on())
	   {

                add_relation(get_dsframe(ds->depending_on()),(*sit));
	   }
	 }
	++sit;
	}

raise_datasources();

}


hk_datasource* hk_kdedbdesigner::already_added_table(const hk_string&t)
{
list<hk_datasource*>*l=p_private->p_presentation->datasources();
list<hk_datasource*>::iterator it=l->begin();
while (it!=l->end())
{
 hk_datasource* d=(*it);
 if (d->type()==hk_datasource::ds_table && d->name()==t) return d;
++it;
}

return NULL;
}








hk_kdedatasourceframe* hk_kdedbdesigner::add_dsframe(hk_datasource* ds)
{
 if (!ds) return NULL;
 //ds->automatic_position_datasource();
 hk_kdedatasourceframe* k=new hk_kdedatasourceframe(this,p_private->p_scrollview->viewport(), ds);
  p_private->p_scrollview->addChild(k,k->QWidget::x(),k->QWidget::y());
  k->set_datasource(ds);
  p_private->p_windowlist.insert(p_private->p_windowlist.end(),k);
  k->show();
  return k;

}

hk_kdedbrelation* hk_kdedbdesigner::add_relation(hk_kdedatasourceframe* master, hk_kdedatasourceframe* slave)
{
  if (!master||!slave) return NULL;
  if (slave&&slave->datasource()&&slave->datasource()->depending_on())
    {
       hk_kdedbrelation* r=get_relation(slave->datasource()->depending_on(),slave->datasource());
       if (r) 
       {

        delete_relation(r);
       }

    }


  hk_kdedbrelation* relation=new hk_kdedbrelation(p_private->p_scrollview->viewport(),p_private->p_presentation && p_private->p_presentation->presentationtype()==hk_presentation::referentialintegrity);
  p_private->p_scrollview->addChild(relation);
  relation->setAutoMask(true);
  relation->set_datasources(master,slave);
  relation->setGeometry(10,50,100,70);
  p_private->p_relationlist.insert(p_private->p_relationlist.end(),relation);
  connect(relation,SIGNAL(signal_relation_clicked(hk_kdedbrelation*)),this,SLOT(relation_clicked(hk_kdedbrelation*)));
  relation->show();
  relation->raise();
  relation->lower();
  slave->set_header();
emit signal_definition_has_changed();

 return relation;

}

hk_kdedbrelation* hk_kdedbdesigner::add_relation(hk_datasource* master, hk_datasource* slave)
{

  return add_relation(get_dsframe(master),get_dsframe(slave));
}



hk_kdedbrelation* hk_kdedbdesigner::add_referentialintegrity(referentialclass ref, hk_kdedatasourceframe* ds)
{
  hk_kdedatasourceframe* ms=get_dsframe(already_added_table(ref.p_masterdatasource));
  if (!ds ||!ms) return NULL;


  hk_kdedbrelation* relation=new hk_kdedbrelation(p_private->p_scrollview->viewport(),p_private->p_presentation && p_private->p_presentation->presentationtype()==hk_presentation::referentialintegrity);
  p_private->p_scrollview->addChild(relation);
  relation->setAutoMask(true);
  relation->set_referentialintegrity(ref,ms,ds);
  relation->setGeometry(10,50,100,70);
  p_private->p_relationlist.insert(p_private->p_relationlist.end(),relation);
  connect(relation,SIGNAL(signal_relation_clicked(hk_kdedbrelation*)),this,SLOT(relation_clicked(hk_kdedbrelation*)));
  relation->show();
  relation->raise();
  relation->lower();
  ds->set_header();
emit signal_definition_has_changed();

 return relation;

}









void hk_kdedbdesigner::raise_datasources(void)
{
  list<hk_kdedatasourceframe*>::iterator sit=p_private->p_windowlist.begin();
  sit=p_private->p_windowlist.begin();
  while (sit!=p_private->p_windowlist.end())
  	{
	  (*sit)->raise();
	  ++sit;
	}

}



void hk_kdedbdesigner::delete_datasource(hk_kdedatasourceframe* f)
{
 if (!f) return;
  if (f->datasource())
  {
  	//cerr<<"delete_datasource datasource!=NULL"<<endl;
  	list<hk_datasource*>* l=f->datasource()->dependinglist();
  	list<hk_datasource*>::iterator it=l->begin();
	hk_kdedbrelation* rel=NULL;
  	/*while (it!=l->end())
   	{
   	 rel=get_relation(f->datasource(),(*it));
   	 if (rel) delete_relation(rel);
   	 ++it;
    	}*/
   while((rel=get_relation(f->datasource())))
   {  
      if (rel) remove_relation(rel);
   }
  }
  else cerr <<"leere Datasource!!!"<<endl;
  p_private->p_windowlist.remove(f);
  f->deleteLater();
  delete f->datasource();
emit signal_definition_has_changed();
}



void hk_kdedbdesigner::delete_relation(hk_kdedbrelation* r)
{
  if (presentation()->presentationtype()==hk_presentation::referentialintegrity)
  {
     r->slavedatasource()->datasource()->drop_reference(r->referentialname());
  }
  remove_relation(r);
emit signal_definition_has_changed();
}

void hk_kdedbdesigner::remove_relation(hk_kdedbrelation* r)
{
  p_private->p_relationlist.remove(r);
  r->slavedatasource()->datasource()->set_depending_on_presentationdatasource(-1);
  r->slavedatasource()->datasource()->clear_depending_fields();
  r->slavedatasource()->set_header();
  r->deleteLater();

}


void hk_kdedbdesigner::relation_clicked(hk_kdedbrelation* cr)
{
list<hk_kdedbrelation*>::iterator it=p_private->p_relationlist.begin();
while (it!=p_private->p_relationlist.end())
  	{
	  (*it)->slot_relation_clicked(cr);
	  ++it;
	}


	if (cr) new_focus(NULL);
}





void hk_kdedbdesigner::add_datasource(void)
{
assert(presentation()!=NULL);
    if (!presentation())
    {
     show_warningmessage("No presentation set!");
     return;
    }
    hk_kdeaddtabledialog* addtabledialog=new hk_kdeaddtabledialog(
		this,
		presentation()->presentationtype()!=hk_presentation::qbe,this
		);
    addtabledialog->exec();
     if (addtabledialog->datasource_added())
         emit signal_definition_has_changed();
    delete addtabledialog;
    return;

/*
    hk_kdeformdatasourcedialog* d = new hk_kdeformdatasourcedialog(presentation(),this,0,true);

    hk_kdeformdatasourcedialog::enum_displaytype dp=hk_kdeformdatasourcedialog::d_form;
    if (presentation()->presentationtype()!=hk_presentation::form)
       dp=(presentation()->presentationtype()==hk_presentation::report?
          hk_kdeformdatasourcedialog::d_report:hk_kdeformdatasourcedialog::d_query);
    d->set_displaytype(dp);
    d->set_edittype(hk_kdeformdatasourcedialog::e_add);
    //d->set_datasource(p_slavedatasource->datasource());
	d->Addbutton->setEnabled(true);
    d->exec();
    bool changed=d->result()==QDialog::Accepted;
    if (d->clicked_button()==hk_kdeformdatasourcedialog::cb_add)
        {
	      if (!d->datasource()) return;
	        d->datasource()->set_designsize(designwidth,designheight,false);
  		hk_kdedatasourceframe* k=add_dsframe(d->datasource());
		k->set_focus(k);


	   hk_datasource* ds=d->datasource();
	   if (ds && ds->depending_on())
	   {

		hk_kdedbrelation* relation=add_relation(get_dsframe(ds->depending_on()),k);
		relation->show();
	   }
		//p_private->p_scrollview->show();
		raise_datasources();
         k->raise();
	}

    delete d;
*/
}


void hk_kdedbdesigner::slot_field_doubleclicked(int t, const hk_string& c)
{
emit signal_field_doubleclicked(t,c);
}



























// hk_kdeDBRELATION BEGIN
  const  int hlength=10;//horizontal line length
  const  int  arrowlength=5;
  const  int  arrowheight=5;

hk_kdedbrelation::hk_kdedbrelation(QWidget* parent,bool is_integrity):QWidget(parent),hk_class()
{
p_tox=p_toy=p_fromx=p_fromy=0;
p_masterdatasource=p_slavedatasource=NULL;
p_is_focused=false;
setMouseTracking(true);
setFocusPolicy(StrongFocus);
p_is_referentialintegrity=is_integrity;
if (is_integrity)setPaletteForegroundColor(blue);
p_deletecascade=false;
p_updatecascade=false;
}

hk_kdedbrelation::~hk_kdedbrelation()
{
}

void hk_kdedbrelation::paint_relation(QPainter* paint)
{
   paint->save();
/*   paint->drawLine(0,0,width(),0);
   paint->drawLine(0,height()-1,width(),height()-1);
   paint->drawLine(0,0,0,height());
   paint->drawLine(width()-1,0,width()-1,height());
*/
   hk_datasource* sd=(p_slavedatasource?p_slavedatasource->datasource():NULL);
   bool paint_arrow=(sd && sd->depending_on_is_left_join());

    
    QPen p=paint->pen();
   if (p_is_focused)
   {
    p.setWidth(2);
    paint->setPen(p);
   }
   paint->drawLine(p_fromx+hlength,p_fromy+1,p_tox-hlength,p_toy+arrowheight); //diagonal


   int pw=p.width();
   p.setWidth(pw*2+3);
   paint->setPen(p);
   paint->drawLine(p_fromx,p_fromy+1,p_fromx+hlength,p_fromy+1);//master horizontal
   p.setWidth(pw);
   paint->setPen(p);
   paint->drawLine(p_tox-hlength,p_toy+arrowheight,  p_tox ,p_toy+arrowheight);//slave horizontal
//     p.setWidth(pw);
//    paint->setPen(p);
   if (p_is_focused)
   {
    QPen p=paint->pen();
    p.setWidth(0);
    paint->setPen(p);
   }
//    hk_datasource* sd=(p_slavedatasource?p_slavedatasource->datasource():NULL);
   if (paint_arrow)
   {
     QPointArray array;
     array.setPoints(3,p_tox-1,p_toy+arrowheight, p_tox-arrowlength-1,p_toy,p_tox-arrowlength-1,p_toy+2*arrowheight);
     paint->drawPolygon(array);
   }
   else
   {
    paint->drawEllipse(p_tox-hlength/2,p_toy,hlength,hlength);
   }
   
   paint->restore();
}



void hk_kdedbrelation::paintEvent(QPaintEvent*)
{
  if (autoMask()) return;
  QPainter paint(this);
  paint.setBrush(colorGroup().foreground());
  paint_relation(&paint);
}

hk_string hk_kdedbrelation::referentialname()const
{
  return p_refname;
}

void hk_kdedbrelation::updateMask(void)
{
   QBitmap bm(size());
   bm.fill(color0);
   QPainter paint;
   paint.begin(&bm,this);
   paint.setBrush(color1);
   paint.setPen(color1);
   paint_relation(&paint);
   paint.end();
   setMask(bm);
}

void  hk_kdedbrelation::setAutoMask(bool b)
{

	setBackgroundMode(b?PaletteForeground:PaletteBackground);
	QWidget::setAutoMask(b);

}


void hk_kdedbrelation::set_datasources(hk_kdedatasourceframe* master,hk_kdedatasourceframe* slave)
{
if (!master||!slave) return;


 p_masterdatasource=master;
 p_slavedatasource=slave;
  QToolTip::add(this,tooltipfields());
 connect(p_masterdatasource,SIGNAL(signal_moved()),this,SLOT(datasource_moved()));
 connect(p_slavedatasource,SIGNAL(signal_moved()),this,SLOT(datasource_moved()));
 datasource_moved();
}


void hk_kdedbrelation::set_referentialintegrity(referentialclass c,hk_kdedatasourceframe* master,hk_kdedatasourceframe* slave)
{
if (!master||!slave) return;


 p_masterdatasource=master;
 p_slavedatasource=slave;
 p_refname=c.p_name;
 p_deletecascade=c.p_deletecascade;
 p_updatecascade=c.p_updatecascade;
  QToolTip::add(this,tooltipfields(&c));
 connect(p_masterdatasource,SIGNAL(signal_moved()),this,SLOT(datasource_moved()));
 connect(p_slavedatasource,SIGNAL(signal_moved()),this,SLOT(datasource_moved()));
 datasource_moved();
}


bool hk_kdedbrelation::updatecascade(void) const
{
  return p_updatecascade;
}

bool hk_kdedbrelation::deletecascade(void) const
{
  return p_deletecascade;
}

QString hk_kdedbrelation::tooltipfields(referentialclass* c)
{
   QString result;
   if (c)
   {
     list<dependingclass>::iterator it= c->p_fields.begin();
     while (it!= c->p_fields.end())
     {
       if (!result.isEmpty()) result+="\n";
       result+=	QString::fromUtf8(l2u((*it).masterfield).c_str())
       		+"\t = " + QString::fromUtf8(l2u((*it).dependingfield).c_str());
      ++it;
     }
       if (!result.isEmpty()) result+="\n________________\n";
       result+=i18n("On update:") +(c->p_updatecascade?i18n("Cascade"):i18n("Restrict"))+"\n";
       result+=i18n("On delete:") +(c->p_deletecascade?i18n("Cascade"):i18n("Restrict"));

    return result;
   }


   list<hk_string>* masterlist=p_slavedatasource->datasource()->depending_on_masterfields();
   list<hk_string>* slavelist=p_slavedatasource->datasource()->depending_on_thisfields();
   list<hk_string>::iterator masterit= masterlist->begin();
   list<hk_string>::iterator slaveit= slavelist->begin();
   while (masterit!=masterlist->end())
   {
       if (!result.isEmpty()) result+="\n";
       result+=	QString::fromUtf8(l2u((*masterit)).c_str())
       		+"\t = " + QString::fromUtf8(l2u((*slaveit)).c_str());
     ++masterit;
     ++slaveit;
   }
return result;
}




hk_kdedatasourceframe* hk_kdedbrelation::masterdatasource(void) const
{
  return p_masterdatasource;
}







hk_kdedatasourceframe* hk_kdedbrelation::slavedatasource(void) const
{
  return p_slavedatasource;
}



void hk_kdedbrelation::datasource_moved(void)
{
int x,y,w,h,mx,my,mh,sx,sy,sh;
mx=p_masterdatasource->QWidget::x()+p_masterdatasource->QWidget::width();
sx=p_slavedatasource->QWidget::x();
if (mx+hlength<sx)
{ //standard case;
   x=mx;
   w=sx-mx;
   p_fromx=0;
   p_tox=w;
}
else
{
   x=sx-hlength;
   w=mx-sx+2*hlength;
   p_fromx=w-hlength;
   p_tox=hlength;

}
if (w<hlength)w=hlength;

my=p_masterdatasource->QWidget::y();
mh=p_slavedatasource->QWidget::y()-p_masterdatasource->QWidget::y();
sy=p_slavedatasource->QWidget::y();
sh=-mh;
if (my<sy)
{//standard case
y=my;
h=mh;
p_fromy=0;
p_toy=h;
}
else
{
y=sy;
h=sh;
if (h>0)p_fromy=h;
else p_fromy=0;
p_toy=0;
}

if (h<3)h=3;
if (w<3)w=3;

setGeometry(x,y+10,w+10,h+20);

}


void hk_kdedbrelation::mouseMoveEvent(QMouseEvent* e)
{
 //cerr <<"mouseMoveEvent e->x: "<<e->x()<<" e->y: "<<e->y() <<endl;
      QWidget::mouseMoveEvent(e);
}




void hk_kdedbrelation::mousePressEvent(QMouseEvent* e)
{
 //cerr <<"mousePressEvent e->x: "<<e->x()<<" e->y: "<<e->y() <<endl;
 //emit signal_relation_clicked(this);
 setFocus();
      QWidget::mousePressEvent(e);
}


void hk_kdedbrelation::keyPressEvent(QKeyEvent* event)
{
if (event->key()==Key_Delete)
	p_masterdatasource->designer()->delete_relation(this);

}





void hk_kdedbrelation::mouseDoubleClickEvent(QMouseEvent*)
{
 edit();
}




void hk_kdedbrelation::slot_relation_clicked(hk_kdedbrelation* cr)
{  //cerr<<"hk_kdedbrelation::slot_relation_clicked" <<endl;
   if (cr==this )
        {if (!p_is_focused) setFocus();}
     else
       p_is_focused=false;
   set_focus();
}

void hk_kdedbrelation::set_focus(void)
{
 p_masterdatasource->designer()->presentation()->set_block_has_changed(true);
 p_masterdatasource->move(p_masterdatasource->QWidget::x()+1,p_masterdatasource->QWidget::y());
 p_masterdatasource->move(p_masterdatasource->QWidget::x()-1,p_masterdatasource->QWidget::y());
 p_masterdatasource->designer()->presentation()->set_block_has_changed(false);
}



void hk_kdedbrelation::setFocus(void)
{
QWidget::setFocus();
p_is_focused=true;
//set_focus();
p_masterdatasource->designer()->relation_clicked(this);
}




void hk_kdedbrelation::contextMenuEvent(QContextMenuEvent* event)
{
QPopupMenu* context=new QPopupMenu(this);
int id[3];
//id[0]=context->insertItem(i18n("Show connections"));
id[1]=context->insertItem(i18n("Edit"));
id[2]=context->insertItem(i18n("Delete"));
int res=context->exec(QCursor::pos());

/*if (res==id[0])
	{

	}
else*/
if (res==id[1])
	{
      	  edit();
	}
else
if (res==id[2])
	{
	p_masterdatasource->designer()->delete_relation(this);
	}

delete context;
event->accept();
}


void hk_kdedbrelation::edit(void)
{
    hk_kderelationdialog* d = new hk_kderelationdialog(p_masterdatasource,p_slavedatasource
    ,p_masterdatasource->designer(),this);
    d->exec();
  QToolTip::add(this,tooltipfields());

    delete d;

}



class hk_kdedbdesignerwindowprivate
{
public:
KParts::ReadWritePart* p_part;
KAction* p_closeaction;
};

hk_kdedbdesignerwindow::hk_kdedbdesignerwindow( QWidget* parent, const char* name, WFlags fl )
: KParts::MainWindow( parent, name, fl|WType_Dialog|WShowModal )
{
p_private=new hk_kdedbdesignerwindowprivate;
//   createGUI(0L);

   KIconLoader* loader=KGlobal::iconLoader();
   loader->addAppDir("hk_kdeclasses");
   setXMLFile(locate("data","hk_kdeclasses/hk_kdedbdesigner.rc"));
   setGeometry(x(),y(),600,500);
   KLibFactory* p_factory= KLibLoader::self()->factory( "libhk_kdedbdesignerpart" );
   p_private->p_part =(KParts::ReadWritePart*) p_factory->create (this, "hk_kdedbdesignerpart", "KParts::ReadWritePart");
   p_private->p_closeaction=new KAction(i18n("&Close"),"fileclose",0,this,SLOT(close()),actionCollection(),"closedesigner");
   setCentralWidget(designer());
   createGUI(p_private->p_part);


  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("DatabaseDesigner");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);

}

hk_kdedbdesignerwindow::~hk_kdedbdesignerwindow()
{
   delete p_private;

}


hk_kdedbdesigner* hk_kdedbdesignerwindow::designer(void) const
{
   return (hk_kdedbdesigner*)p_private->p_part->widget();
}


void hk_kdedbdesignerwindow::closeEvent(QCloseEvent* e)
{
KConfig* c=kapp->config();
  c->setGroup("DatabaseDesigner");
  c->writeEntry("Geometry",geometry());
if (designer()->presentation()&&
    designer()->presentation()->presentationtype()==hk_presentation::referentialintegrity)
    {
    ((hk_referentialintegrity*)(designer()->presentation()))->save_referentialintegrity();
    }
emit signal_closed();
KParts::MainWindow::closeEvent(e);
}
























const int mvfixed=3;

hk_kdemovewidget::hk_kdemovewidget(enum_orientation orientation,QWidget*parent,const char* name,WFlags fl)
: QWidget(parent,name,fl)
{
   p_drag=false;
   p_startx=p_starty=p_offsetx=p_offsety=0;

   p_orientation=orientation;
   QSize s=QSize(mvfixed,mvfixed);
   setMinimumSize(s);
//   setMaximumSize(s);
   switch (orientation)
   {
     case horizontal:
   		setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Fixed);
   		setCursor(Qt::SizeVerCursor);
		break;

     case vertical:
   		setSizePolicy(QSizePolicy::Fixed,QSizePolicy::Preferred);
   		setCursor(Qt::SizeHorCursor);
		break;
     case diagonal:
   		setSizePolicy(QSizePolicy::Preferred,QSizePolicy::Preferred);
   		setCursor(Qt::SizeFDiagCursor);
		break;

   }
//setBackgroundColor(red);
}

hk_kdemovewidget::~hk_kdemovewidget()
{

}


void hk_kdemovewidget::mousePressEvent(QMouseEvent* event)
{
	if (event->button()==Qt::LeftButton)
	   {
		p_drag=true;
		p_startx=event->globalPos().x();
		p_starty=event->globalPos().y();
		p_offsetx=p_offsety=0;
	   }

}


void hk_kdemovewidget::mouseMoveEvent(QMouseEvent* event)
{
const int minwidth=150;
const int minheight=150;
if (p_drag && event->state()==Qt::LeftButton)
  {
    int xdiff=event->globalPos().x()-p_startx;
    int ydiff=event->globalPos().y()-p_starty;
    if (p_orientation==horizontal) xdiff=0;
     else
     if (p_orientation==vertical) ydiff=0;
    if ((abs(xdiff)>2) || (abs(ydiff)>2))
    {
	QSize newsize=parentWidget()->size()+QSize(xdiff,ydiff);
	if (newsize.width()<minwidth)
	{
		p_offsetx+=newsize.width();
		newsize.setWidth(minwidth);
	}
	else if (p_offsetx<0)
	{
		p_offsetx+=newsize.width();
		if (p_offsetx>0)
		{
			newsize.setWidth(p_offsetx);
			p_offsetx=0;
		}
		else newsize.setWidth(0);
	}
	if (newsize.height()<minheight)
	{
		p_offsety+=newsize.height();
		newsize.setHeight(minheight);
	}
	else
	if (p_offsety<0)
	{
		p_offsety+=newsize.height();
		if (p_offsety>0)
		{
			newsize.setHeight(p_offsety);
			p_offsety=0;
		}
		else newsize.setHeight(0);
	}
	if (newsize.width()<minwidth) newsize.setWidth(minwidth);
	if (newsize.height()<minheight) newsize.setHeight(minheight);
	parentWidget()->resize(newsize);
	p_startx=event->globalPos().x();
	p_starty=event->globalPos().y();
  	}
  }
 }
