// ****************************************************************************
// copyright (c) 2000-2005 Horst Knorr <hk_classes@knoda.org>
// This file is part of the hk_kdeclasses library.
// This file may be distributed and/or modified under the terms of the
// GNU Library Public License version 2 as published by the Free Software
// Foundation and appearing in the file LGPL included in the
// packaging of this file.
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
// ****************************************************************************
//$Revision: 1.30 $

#include "hk_kdeformpartwidget.h"
#include "hk_kdetoolbar.h"
#include "hk_kdesimpleform.h"
#include "hk_kderowselector.h"
#include "hk_kdesimplegrid.h"
#include "../hk_kdegridpart/hk_kdegridpart.h"
#include "../hk_kdeformpart/hk_kdeformpart.h"
#include "hk_kdeformfocus.h"
#include "hk_kdetaborder.h"
#include "hk_kdeproperty.h"

#include <qbuttongroup.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qclipboard.h>
#include <kstatusbar.h>
#include <qstatusbar.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qscrollview.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include <kglobal.h>
#include <kiconloader.h>

#include <hk_class.h>
#include <hk_database.h>
#include <hk_dsvisible.h>
#include <hk_visible.h>
#include <hk_dsdatavisible.h>
#include <hk_datasource.h>
#include <hk_connection.h>

#include <kmenubar.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kstandarddirs.h>
#include <klocale.h>
#include <kmdichildview.h>


/*
 *  Constructs a hk_kdeformpartwidget which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 */
hk_kdeformpartwidget::hk_kdeformpartwidget( hk_kdeformpart* formpart,QWidget* parent,  const char* name, WFlags fl )
: KDockMainWindow( parent, name, fl ) ,hk_class()
{
#ifdef HK_DEBUG
    hkclassname("Hauptformular");
    hkdebug("hk_kdeformpartwidget::hk_kdeformpartwidget");
#endif
    p_formpart=formpart;
    p_dontclose=false;
    setFocusPolicy(StrongFocus);
    KIconLoader* loader=KGlobal::iconLoader();
    loader->addAppDir("hk_kdeclasses");
    //setXMLFile(locate("data","hk_kdeclasses/hk_kdeformpartwidget.rc"));
    if ( !name )
        setName( "hk_kdeformpartwidget" );
    setCaption( i18n( "Form"  ) );
    resize( 800, 600 );
    QPixmap p;
    KDockWidget* maindock=createDockWidget("",p,0,"");
    maindock->setEnableDocking(KDockWidget::DockNone);
    maindock->setDockSite(KDockWidget::DockCorner);
    setView(maindock);
    setMainDockWidget(maindock);
    p_scrollview = new QScrollView(maindock);
    maindock->setWidget(p_scrollview);
    p_form = new hk_kdesimpleform( p_scrollview->viewport() );
    p_scrollview->addChild(p_form);
    p_form->set_formpartwidget(this);
    QWidget* wid= new QWidget(statusBar());
    QHBoxLayout* l=new QHBoxLayout(wid);
    p_rowselector = new hk_kderowselector( wid ,p_form);
    p_rowselector->set_neverregisterchange(true);
    l->addWidget(p_rowselector);
#ifdef HK_DEBUG
    p_rowselector->hkclassname("hkkdeform->p_rowselector");
#endif
    int hbheight= 20;
    p_rowselector->setMaximumHeight(hbheight);
    p_rowselector->setMaximumWidth(240);
    p_rowselector->setMinimumHeight(hbheight);
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding ,QSizePolicy::Minimum );
    l->addItem( spacer );

    statusBar()->addWidget(wid);
    QSizePolicy fixedpolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
//   QSizePolicy labelpolicy(QSizePolicy::Expanding,QSizePolicy::Fixed);
    p_rowselector->setSizePolicy( fixedpolicy );
    setFocusPolicy(ClickFocus);
    if (runtime_only())
    {
      p_designaction=NULL;
      p_viewaction=NULL;
    }
    else
    {
    p_designaction=new KRadioAction(i18n("&Design mode"),"edit",0,this,SLOT(designbutton_clicked()),formpart->actionCollection(),"designmode");
    p_designaction->setEnabled(!runtime_only());
    p_designaction->setExclusiveGroup("mode");
    p_viewaction=new KRadioAction(i18n("&View mode"),"exec",0,this,SLOT(formbutton_clicked()),formpart->actionCollection(),"viewmode");
    p_viewaction->setExclusiveGroup("mode");
    p_designaction->setChecked(true);

    }
    p_saveaction=new KAction(i18n("&Save"),"filesave",0,this,SLOT(save_form()),formpart->actionCollection(),"save");
    p_saveaction->setEnabled(!runtime_only());
    p_saveasaction=new KAction(i18n("Save &as"),"filesaveas",0,this,SLOT(saveas_form()),formpart->actionCollection(),"saveas");
    p_saveasaction->setEnabled(!runtime_only());

    p_lineeditaction=new KRadioAction(i18n("Lineedit"),loader->loadIcon("edit",KIcon::User),0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"lineedit");
    p_pointeraction=new KRadioAction(i18n("Pointer"),loader->loadIcon("pfeil",KIcon::User),0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"pointer");
    p_labelaction=new KRadioAction(i18n("Label"),loader->loadIcon("label",KIcon::User),0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"label");
    p_multilineeditaction=new KRadioAction(i18n("Multiline"),loader->loadIcon("multiline",KIcon::User),0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"multiline");
    p_booleanaction=new KRadioAction(i18n("Boolean"),loader->loadIcon("boolean22x22",KIcon::User),0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"boolean");
    p_comboboxaction=new KRadioAction(i18n("Combobox"),loader->loadIcon("combobox22x22",KIcon::User),0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"combobox");
    p_gridaction=new KRadioAction(i18n("Grid"),loader->loadIcon("grid22x22",KIcon::User),0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"grid");
    p_selectoraction=new KRadioAction(i18n("Selector"),loader->loadIcon("rowselector22x22",KIcon::User),0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"selector");
    p_buttonaction=new KRadioAction(i18n("Button"),loader->loadIcon("button",KIcon::User),0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"button");
    p_subformaction=new KRadioAction(i18n("Subform"),"openterm",0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"subform");
    p_imageaction=new KRadioAction(i18n("Image"),loader->loadIcon("image",KIcon::User),0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"image");
    p_tabwidgetaction=new KRadioAction("Tabwidget","",0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"tabwidget");
    p_dateaction=new KRadioAction("date","kontact_date",0,this,SLOT(fieldbutton_clicked()),formpart->actionCollection(),"date");
    p_bulkaction=new KActionMenu(i18n("Set to all"),0,formpart->actionCollection(),"bulk");
    p_bulkfontaction=new KAction(i18n("Font"),0,0,this,SLOT(bulkfont_clicked()),formpart->actionCollection(),"bulkfont");
    p_bulkforegroundcolouraction=new KAction(i18n("Foregroundcolour"),0,0,this,SLOT(bulkforegroundcolour_clicked()),formpart->actionCollection(),"bulkforeground");
    p_bulkbackgroundcolouraction=new KAction(i18n("Backgroundcolour"),0,0,this,SLOT(bulkbackgroundcolour_clicked()),formpart->actionCollection(),"bulkbackground");

    p_taborderaction=new KAction(i18n("Tab order"),"bottom",0,this,SLOT(taborder_clicked()),formpart->actionCollection(),"taborder");



    p_bulkaction->insert(p_bulkfontaction);
    p_bulkaction->insert(p_bulkforegroundcolouraction);
    p_bulkaction->insert(p_bulkbackgroundcolouraction);

    p_pointeraction->setExclusiveGroup("design");
    p_labelaction->setExclusiveGroup("design");
    p_lineeditaction->setExclusiveGroup("design");
    p_multilineeditaction->setExclusiveGroup("design");
    p_booleanaction->setExclusiveGroup("design");
    p_comboboxaction->setExclusiveGroup("design");
    p_gridaction->setExclusiveGroup("design");
    p_selectoraction->setExclusiveGroup("design");
    p_buttonaction->setExclusiveGroup("design");
    p_subformaction->setExclusiveGroup("design");
    p_imageaction->setExclusiveGroup("design");
    p_tabwidgetaction->setExclusiveGroup("design");
    p_dateaction->setExclusiveGroup("design");

    p_pointeraction->setToolTip( i18n( "select" ) );
    p_labelaction->setToolTip( i18n( "textlabel" ));
    p_lineeditaction->setToolTip( i18n( "lineeditfield" ));
    p_multilineeditaction->setToolTip( i18n( "memofield" ));
    p_booleanaction->setToolTip( i18n( "booleanfield" ));
    p_comboboxaction->setToolTip( i18n( "comboboxfield" ));
    p_gridaction->setToolTip( i18n( "gridfield" ));
    p_selectoraction->setToolTip( i18n( "rowselector" ));
    p_buttonaction->setToolTip( i18n( "button" ));

    p_pointeraction->setChecked(true);
    connect( p_form, SIGNAL( field_created() ), this, SLOT( field_created() ) );
    connect( p_form, SIGNAL( signal_focuswidget_changed() ), this, SLOT( slot_focuswidget_changed() ) );



    p_deleteaction=new KAction(i18n("&Delete"),Key_Delete,p_form,SLOT(delete_widgets()),formpart->actionCollection(),"deleteclicked");
    p_copyaction=new KAction(i18n("&Copy"),CTRL+Key_C,p_form,SLOT(copy()),formpart->actionCollection(),"copy");
    p_pasteaction=new KAction(i18n("&Paste"),CTRL+Key_V,p_form,SLOT(paste()),formpart->actionCollection(),"paste");
    p_cutaction=new KAction(i18n("Cu&t"),CTRL+Key_X,p_form,SLOT(cut()),formpart->actionCollection(),"cutclicked");
    p_formpropertyaction=new KAction(i18n("&Propertyeditor"),loader->loadIcon("propertyeditor",KIcon::User),0,p_form,SLOT(show_property()),formpart->actionCollection(),"viewproperty");

    p_resizeaction=new KActionMenu(i18n("Adjust &size"),0,formpart->actionCollection(),"size");
    p_minwidthaction=new KAction(i18n("Minimum width"),0,0,p_form,SLOT(adjust_minw()),formpart->actionCollection(),"minwidth");
    p_maxwidthaction=new KAction(i18n("Maximum width"),0,0,p_form,SLOT(adjust_maxw()),formpart->actionCollection(),"maxwidth");
    p_minheightaction=new KAction(i18n("Minimum height"),0,0,p_form,SLOT(adjust_minh()),formpart->actionCollection(),"minheight");
    p_maxheightaction=new KAction(i18n("Maximum height"),0,0,p_form,SLOT(adjust_maxh()),formpart->actionCollection(),"maxheight");
    p_minsizeaction=new KAction(i18n("Minimum size"),0,0,p_form,SLOT(adjust_mins()),formpart->actionCollection(),"minsize");
    p_maxsizeaction=new KAction(i18n("Maximum size"),0,0,p_form,SLOT(adjust_maxs()),formpart->actionCollection(),"maxsize");
    p_resizeaction->insert(p_minwidthaction);
    p_resizeaction->insert(p_maxwidthaction);
    p_resizeaction->insert(p_minheightaction);
    p_resizeaction->insert(p_maxheightaction);
    p_resizeaction->insert(p_minsizeaction);
    p_resizeaction->insert(p_maxsizeaction);

    p_alignaction=new KActionMenu(i18n("&Align"),0,formpart->actionCollection(),"align");
    p_alignleftaction=new KAction(i18n("&Left"),0,0,p_form,SLOT(align_left()),formpart->actionCollection(),"alignleft");
    p_alignrightaction=new KAction(i18n("&Right"),0,0,p_form,SLOT(align_right()),formpart->actionCollection(),"alignright");
    p_aligntopaction=new KAction(i18n("&Top"),0,0,p_form,SLOT(align_top()),formpart->actionCollection(),"aligntop");
    p_alignbottomaction=new KAction(i18n("&Bottom"),0,0,p_form,SLOT(align_bottom()),formpart->actionCollection(),"alignbottom");
    p_alignaction->insert(p_alignleftaction);
    p_alignaction->insert(p_alignrightaction);
    p_alignaction->insert(p_aligntopaction);
    p_alignaction->insert(p_alignbottomaction);
    p_dbdesigneraction=new KAction(i18n("Database designer"),loader->loadIcon("dbdesigner",KIcon::User),0,p_form,SLOT(dbdesignaction()),formpart->actionCollection(),"dbdesigner");

    p_withlabelaction=new KToggleAction(i18n("with label"),"attach",0,this,SLOT(withlabelbutton_clicked()),formpart->actionCollection(),"withlabel");

    p_definegridcolumnaction=new KAction(i18n("Define columns"),0,0,this,SLOT(show_gridcolumndialog()),formpart->actionCollection(),"gridcolumndialog");
    p_definegridcolumnaction->setEnabled(false);





    toolbar = new hk_kdetoolbar( this, "toolbar" );
    p_filterdefinitionaction=new KAction(i18n("Filterdefinition"),loader->loadIcon("filter",KIcon::User),0,toolbar,SLOT(filterdefinebutton_clicked()),formpart->actionCollection(),"filterdefinition");
    p_filterexecaction=new KToggleAction(i18n("Filterexecution"),loader->loadIcon("filterexec",KIcon::User),0,toolbar,SLOT(filterexecbutton_clicked()),formpart->actionCollection(),"filterexec");
    toolbar->set_filteractions(p_filterdefinitionaction,p_filterexecaction);

    set_nodesignmode(runtime_only());
    //setCentralWidget(p_scrollview);
    //createGUI(0L);
    //toolBar("designtoolbar")->setBarPos(KToolBar::Left);
    set_viewmode();
    connect(p_form,SIGNAL(signal_has_changed()),this,SLOT(slot_has_changed()));
    connect (QApplication::clipboard(), SIGNAL(dataChanged()),this, SLOT(clipboard_changed()));
p_form->reset_has_changed();

}


/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdeformpartwidget::~hk_kdeformpartwidget()
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::~hk_kdeformpartwidget");
#endif
//    cerr <<p_form->hk_form::name()<<" callerform:"<<caller_form()<<endl;
     emit signal_raise_form(caller_form());
    delete p_rowselector;
}


hk_presentation::enum_mode  hk_kdeformpartwidget::mode(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::mode");
#endif

    return p_form->mode();
}


void    hk_kdeformpartwidget::set_mode(hk_presentation::enum_mode s)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::set_mode(s)");
#endif

    if (!p_form->set_mode(s))return;
    if (mode()==hk_presentation::viewmode)
    {
        p_copyaction->setEnabled(true);
        p_cutaction->setEnabled(false);
        p_pasteaction->setEnabled(true);
        p_deleteaction->setEnabled(false);
	p_dbdesigneraction->setEnabled(false);
    	p_imageaction->setEnabled(false);
    	p_tabwidgetaction->setEnabled(false);
    	p_dateaction->setEnabled(false);

    }
    else
    {                                             //designmode
        slot_focuswidget_changed();
	p_deleteaction->setEnabled(p_form->formfocus()&&p_form->formfocus()->widget());
        p_pasteaction->setEnabled(QApplication::clipboard()->data()&&QApplication::clipboard()->data()->provides("application/x-hk_kdesimpleformcopy"));
	p_dbdesigneraction->setEnabled(true);

    }
    p_resizeaction->setEnabled(mode()==hk_presentation::designmode&&p_form->focus_multipleselected());
    p_alignaction->setEnabled(mode()==hk_presentation::designmode&&p_form->focus_multipleselected());

    if (s==hk_presentation::viewmode)
    {
        //toolBar("designtoolbar")->hide();
        if (p_viewaction)p_viewaction->setChecked(true);
        toolbar->set_viewmode();
        p_bulkaction->setEnabled(false);
        p_formpart->setXMLFile(locate("data","hk_kdeclasses/hk_kdeformpartview.rc"));
        p_pointeraction->setEnabled(false);
        p_lineeditaction->setEnabled(false);
        p_labelaction->setEnabled(false);
        p_multilineeditaction->setEnabled(false);
        p_booleanaction->setEnabled(false);
        p_comboboxaction->setEnabled(false);
        p_gridaction->setEnabled(false);
        p_selectoraction->setEnabled(false);
        p_buttonaction->setEnabled(false);
        p_subformaction->setEnabled(false);
	p_formpropertyaction->setEnabled(false);
	p_taborderaction->setEnabled(false);

    }
    else
    {
        //toolBar("designtoolbar")->show();
        if (p_designaction)p_designaction->setChecked(true);
        toolbar->set_designmode();
        p_bulkaction->setEnabled(true);
        p_formpart->setXMLFile(locate("data","hk_kdeclasses/hk_kdeformpartdesign.rc"));
        p_pointeraction->setEnabled(true);
        p_lineeditaction->setEnabled(true);
        p_labelaction->setEnabled(true);
        p_multilineeditaction->setEnabled(true);
        p_booleanaction->setEnabled(true);
        p_comboboxaction->setEnabled(true);
        p_gridaction->setEnabled(true);
        p_selectoraction->setEnabled(true);
        p_buttonaction->setEnabled(true);
        p_subformaction->setEnabled(true);
	p_formpropertyaction->setEnabled(true);
	p_taborderaction->setEnabled(true);
    	p_imageaction->setEnabled(true);
    	p_tabwidgetaction->setEnabled(true);
    	p_dateaction->setEnabled(true);
    	p_form->setEnabled(true);
    	if (propertyeditor())propertyeditor()->setEnabled(true);
    }
    p_form->repaint(0,0,p_form->QWidget::width(),p_form->QWidget::height(),true);

}


void hk_kdeformpartwidget::set_designmode(void)
{
    set_mode(hk_presentation::designmode);
}


void hk_kdeformpartwidget::set_viewmode(void)
{
    set_mode(hk_presentation::viewmode);
}


hk_dsgrid*      hk_kdeformpartwidget::new_grid(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::new_grid");
#endif
    hk_dsgrid* d=p_form->new_grid();
    return d;
}


hk_dslineedit*  hk_kdeformpartwidget::new_lineedit(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::new_field");
#endif
    hk_dslineedit* d=p_form->new_lineedit();
    return d;
}


hk_dsboolean*   hk_kdeformpartwidget::new_bool(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::new_bool");
#endif
    hk_dsboolean* d=p_form->new_bool();
    return d;
}


hk_dsmemo*  hk_kdeformpartwidget::new_memo(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::new_memo");
#endif
    hk_dsmemo* d=p_form->new_memo();
    return d;
}


hk_button*      hk_kdeformpartwidget::new_button(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::new_button");
#endif
    hk_button* d=p_form->new_button();
    return d;
}


hk_dsrowselector*       hk_kdeformpartwidget::new_rowselector(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::new_rowselector");
#endif
    hk_dsrowselector* d=p_form->new_rowselector();
    return d;
}


hk_subform*       hk_kdeformpartwidget::new_subform(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::new_subform");
#endif
    return p_form->new_subform();
}


void        hk_kdeformpartwidget::set_formsize(unsigned int width, unsigned int height)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::set_formsize");
#endif
    p_form->set_designsize(width,height);
}


void    hk_kdeformpartwidget::set_database(hk_database* db)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::database(db)");
#endif

    p_form->set_database(db);
}


hk_database*        hk_kdeformpartwidget::database(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::database");
#endif
    return p_form->database();
}


list<hk_datasource*>*   hk_kdeformpartwidget::datasources(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::datasources");
#endif
    return p_form->datasources();
}


long    hk_kdeformpartwidget::new_datasource(const hk_string& name,datasourcetype dt)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::new_datasource(name,query)");
#endif
    return p_form->new_datasource(name,dt);
}


hk_datasource*  hk_kdeformpartwidget::get_datasource(long nr)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::get:datasource(nr)");
#endif
    return p_form->get_datasource(nr);
}


void hk_kdeformpartwidget::formbutton_clicked(void)
{
    set_mode(hk_presentation::viewmode);

}


void hk_kdeformpartwidget::designbutton_clicked(void)
{
    if (p_nodesignmode)  set_mode(hk_form::viewmode);
    else set_mode(hk_form::designmode);

}


bool    hk_kdeformpartwidget::set_presentationdatasource(long n, bool r)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::set_presentationdatasource(n)");
#endif
    p_rowselector->set_presentationdatasource(n,false);
    bool res=true;
    toolbar->set_datasource(p_form->get_datasource(n));
    if (r) res= p_form->set_presentationdatasource(n,false);
    return res;
}


long    hk_kdeformpartwidget::presentationdatasource(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::presentationdatasource(n)");
#endif
    return p_form->presentationdatasource();
}


void hk_kdeformpartwidget::closeEvent ( QCloseEvent* e)
{

#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::closeEvent");
//set_generaldebug(true);
#endif
if (p_dontclose || p_form->while_load_form()) 
  {
    e->ignore();
    return;
  }
save_form_when_changed();
 #ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::closeEvent nach abspeichern");
#endif
   emit signal_closed(this);
    QWidget::closeEvent(e);
}


void hk_kdeformpartwidget::save_form_when_changed(void)
{

   if (p_form &&p_form->has_changed())
    {

    if (propertyeditor())propertyeditor()->identifier_changed();
        if (toolbar->is_filter_activated())
            toolbar->deactivate_filter();
        p_form->save_form();
    }

}



void hk_kdeformpartwidget::close_form(void)
{

    close();
}


void hk_kdeformpartwidget::savedata(ofstream& s)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::savedata(s)");
#endif
    p_form->savedata(s);

}


void hk_kdeformpartwidget::loaddata(const hk_string& definition)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::loaddata");
#endif
    p_form->loaddata(definition);
    p_rowselector->set_presentationdatasource(p_form->presentationdatasource());
}


void hk_kdeformpartwidget::load_form(const hk_string& n)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::load_form");
#endif

    if (database()==NULL)
    {
        hk_class::show_warningmessage(hk_class::hk_translate("Form error: No database defined!"));
        return ;

    }
//  p_form->formname(n);
p_dontclose=true;
    p_form->load_form(n);
    p_rowselector->set_presentationdatasource(p_form->presentationdatasource(),false);
    if (p_form->datasource())toolbar->set_filter(QString::fromUtf8(l2u(p_form->datasource()->temporaryfilter()).c_str()));
    set_caption();
p_dontclose=false;
}


void hk_kdeformpartwidget::set_autoclose(bool c)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::set_autoclose");
#endif
    p_form->set_autoclose(c);
}


void hk_kdeformpartwidget::fieldbutton_clicked(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::fieldbutton_clicked");
#endif

    hk_visible::enum_visibletype thisfield =hk_visible::other;
    if (p_lineeditaction->isChecked()) thisfield=hk_visible::lineedit;
    else
    if (p_labelaction->isChecked()) thisfield=hk_visible::textlabel;
        else
        if (p_multilineeditaction->isChecked()) thisfield=hk_visible::memo;
            else
            if (p_comboboxaction->isChecked()) thisfield=hk_visible::combobox;
                else
                if (p_gridaction->isChecked()) thisfield=hk_visible::grid;
                    else
                    if (p_booleanaction->isChecked()) thisfield=hk_visible::boolean;
                        else
                        if (p_buttonaction->isChecked()) thisfield=hk_visible::button;
                            else
                            if (p_selectoraction->isChecked()) thisfield=hk_visible::rowselector;
                            else
                            if (p_subformaction->isChecked()) thisfield=hk_visible::subform;
                            else
                            if (p_imageaction->isChecked()) thisfield=hk_visible::image;
                            else
                            if (p_tabwidgetaction->isChecked()) thisfield=hk_visible::tabvisible;
                            else
                            if (p_dateaction->isChecked()) thisfield=hk_visible::date;
  p_form->set_field2create(thisfield);
}


void    hk_kdeformpartwidget::mousePressEvent(QMouseEvent*m)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::mousePressEvent");
#endif
    QWidget::mousePressEvent(m);

}


void hk_kdeformpartwidget::field_created(void)
{
    p_pointeraction->setChecked(true);
}


hk_kdesimpleform* hk_kdeformpartwidget::simpleform(void)
{
    return p_form;
}


void hk_kdeformpartwidget::set_nodesignmode(bool d)
{
    p_nodesignmode=d;
    toolbar->set_nodesignmode(d);

}


void hk_kdeformpartwidget::save_form(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::save_form");
#endif
/* if (toolbar->is_filter_activated())
    toolbar->deactivate_filter();
*/
    if (propertyeditor())propertyeditor()->identifier_changed();
    p_form->save_form("",false);
    set_caption();

}


void hk_kdeformpartwidget::saveas_form(void)
{
#ifdef HK_DEBUG
    hkdebug("hk_kdeformpartwidget::save_form");
#endif
    if (toolbar->is_filter_activated())
        toolbar->deactivate_filter();

    hk_string oldname=p_form->hk_presentation::name();
    p_form->set_name("");
    if (p_form->save_form("",true))
    {
        set_caption();
    }
    else
    {
        p_form->set_name(oldname);

    }

}


void hk_kdeformpartwidget::set_caption(void)
{

    KMdiChildView* v=dynamic_cast<KMdiChildView*>(parent());
    QString formname=i18n( "Form - "  );
    hk_datasource* d=p_form->datasource();
    if (d!=NULL)
    {
        if (!v)formname=QString::fromUtf8(l2u(d->database()->connection()->drivername()).c_str())+" "+formname;

    }
     formname+=QString::fromUtf8 (l2u(
        p_form->label().size()>0?
	p_form->label():
	p_form->hk_presentation::name()).c_str()
);
    setCaption( formname  );
    if (v) v->setCaption(formname);

}


void hk_kdeformpartwidget::bulkfont_clicked(void)
{
    p_form->set_for_all(hk_presentation::bulkfont);
}


void hk_kdeformpartwidget::bulkforegroundcolour_clicked(void)
{
    p_form->set_for_all(hk_presentation::bulkforeground);

}


void hk_kdeformpartwidget::bulkbackgroundcolour_clicked(void)
{
    p_form->set_for_all(hk_presentation::bulkbackground);

}

hk_kdeproperty* hk_kdeformpartwidget::propertyeditor(void)
{
   return p_form->propertyeditor();
}



void hk_kdeformpartwidget::grid_partinfocus(hk_kdegridpart* )
{
//createGUI(p);
}

void hk_kdeformpartwidget::grid_partoutfocus(hk_kdegridpart*)
{
//createGUI(0L);

}


void hk_kdeformpartwidget::slot_focuswidget_changed(void)
{
    p_copyaction->setEnabled(p_form->formfocus()&&p_form->formfocus()->widget());
    p_cutaction->setEnabled(p_form->formfocus()&&p_form->formfocus()->widget());
    p_deleteaction->setEnabled(p_form->formfocus()&&p_form->formfocus()->widget());
    p_resizeaction->setEnabled(mode()==hk_presentation::designmode&&p_form->focus_multipleselected());
    p_alignaction->setEnabled(mode()==hk_presentation::designmode&&p_form->focus_multipleselected());
    QWidget* gridwidget=NULL;
    QWidget* object =p_form->formfocus()->widget();
    while (object!=NULL)
    {
       if ( dynamic_cast <hk_kdegrid*>(object)!=NULL  )
       {
        gridwidget=object;
        object=NULL;
       }
       else    object=object->parentWidget();
    }
    hk_kdegrid* gr=dynamic_cast<hk_kdegrid*>(gridwidget);
    p_definegridcolumnaction->setEnabled(mode()==hk_presentation::designmode&&gr);
}

void hk_kdeformpartwidget::slot_has_changed()
{
 if (p_saveaction)p_saveaction->setEnabled(!runtime_only()&& p_form->has_changed());

}

void hk_kdeformpartwidget::clipboard_changed()
{
        if (p_pasteaction) p_pasteaction->setEnabled(QApplication::clipboard()->data()&&QApplication::clipboard()->data()->provides("application/x-hk_kdesimpleformcopy"));

}


void hk_kdeformpartwidget::taborder_clicked()
{
hk_kdetaborder* taborder=new hk_kdetaborder(p_form,0,0,true);
if (!taborder)
   {
     show_warningmessage(hk_translate("hk_kdeformpartwidget::taborder_clicked error: taborder dialog could not be created!"));
     return;
   }
taborder->exec();
delete taborder;

}


void hk_kdeformpartwidget::show_widget(void)
{
  show();
}

void hk_kdeformpartwidget::hide_widget(void)
{
  hide();
}

bool hk_kdeformpartwidget::close_widget(void)
{
  return close();
}


void hk_kdeformpartwidget::withlabelbutton_clicked(void)
{
  p_form->set_create_with_label(!p_form->create_with_label());
}

void hk_kdeformpartwidget::show_gridcolumndialog()
{
QWidget* gridwidget=NULL;
QWidget* object =p_form->formfocus()->widget();
while (object!=NULL)
{
   if ( dynamic_cast <hk_kdegrid*>(object)!=NULL  )
   {
        gridwidget=object;
        object=NULL;
   }
   else    object=object->parentWidget();
}
hk_kdegrid* gr=dynamic_cast<hk_kdegrid*>(gridwidget);
if (gr)
   gr->simplegrid()->show_gridcolumndialog();

}



void hk_kdeformpartwidget::set_caller_form(const hk_string&f)
{
 p_callerform=f;
}

hk_string hk_kdeformpartwidget::caller_form(void) const
{
    return p_callerform;
}


