#include "hk_kdedriverselect.h"
#include "hk_kdedatabasesetting.h"
#include "hk_kdepreferencesdialog.h"
#include <qlistbox.h>
#include <qnamespace.h>
#include <qpushbutton.h>
#include <qkeycode.h>
#include <qtabwidget.h>
#include <kapplication.h>
#include <hk_drivermanager.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kpushbutton.h>
#include <kurlbar.h>
#include <qlayout.h>

internalfiledialog::internalfiledialog(const QString& startDir, const QString& filter,
	QWidget *parent, const char *name,
	bool modal): KFileDialog(startDir,filter,parent,name, modal)
	{
  QStringList l;
  QString xmime="application/x-hk_connection";
  l.append(xmime);
  setMimeFilter(l,xmime);
  okButton()->hide();
  cancelButton()->hide();
  if (speedBar())speedBar()->hide();
	}
void internalfiledialog::accept()
{
KFileDialog::accept();
cerr <<"accept"<<endl;
cerr<<"selected file:"<<(selectedFile()==QString::null?QString("NULL"):selectedFile())<<endl;
cerr<<"selected file:"<<(selectedURL().url()==QString::null?QString("NULL"):selectedURL()).url()<<endl;
//emit fileSelected(selectedFile());
}

void internalfiledialog::reject()
{
cerr <<"reject"<<endl;
}

void internalfiledialog::keyPressEvent(QKeyEvent* event)
{
    if ( event->key() == Key_Escape )
    {
    event->accept();
    }
    else KFileDialog::keyPressEvent(event);

}






/*
 *  Constructs a hk_kdedriverselect which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
hk_kdedriverselect::hk_kdedriverselect( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : hk_kdedriverselectbase( parent, name, modal, fl )
{
p_driverselected=true;
    vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    int i=0;
    for(it=drv->begin();it!=drv->end();it++)
    {
        connectbutton->setEnabled(true);
        driverlist->insertItem(QString::fromUtf8(l2u((*it)).c_str()));
        if ((*it)==hk_class::defaultdriver())
            driverlist->setCurrentItem(i);
        i++;
    }
    driverlist->installEventFilter(this);
    driverlist->setFocus();
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("Driverselectdialog");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);

  tab2Layout = new QVBoxLayout( tab_2, 11, 6, "tab2Layout");


  p_filedialog=new internalfiledialog(":hkc",QString::null,this,0,false);
  //p_filedialog->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);

  p_filedialog->reparent( tab_2, QPoint( 0, 0 ) );
  p_filedialog->setMinimumSize( QSize( 10, 10 ) );
  //p_filedialog->setSize( QSize( 10, 10 ) );

  tab2Layout->addWidget( p_filedialog );

  connect(p_filedialog,SIGNAL(fileSelected(const QString&)),this,SLOT(connection_clicked()));
  connect(p_filedialog,SIGNAL(fileHighlighted(const QString&)),this,SLOT(file_selected(const QString&)));
}

/*
 *  Destroys the object and frees any allocated resources
 */
hk_kdedriverselect::~hk_kdedriverselect()
{
    // no need to delete child widgets, Qt does it all for us
}

void hk_kdedriverselect::list_clicked()
{
   if (driverlist->currentItem()>-1) accept();
}


void hk_kdedriverselect::connection_clicked()
{
cerr <<"connection_clicked()"<<endl;
   if (p_filedialog->selectedFile()!=QString::null)
   {
    p_driverselected=false;
    p_selectedfile=p_filedialog->selectedFile();
    accept();
   }

}


bool hk_kdedriverselect::eventFilter(QObject* o,QEvent* e)
{
  if (o==driverlist)
  {
     if (e->type()==QEvent::KeyPress)
     {
       QKeyEvent* k=(QKeyEvent*)(e);
       if (k->key()==Qt::Key_Return)
         {
	   accept();
	   return true;
	 }
     }
  }

  return hk_kdedriverselectbase::eventFilter(o,e);
}



void hk_kdedriverselect::keyPressEvent ( QKeyEvent * e )
{
  if (e->key()==Key_F1) help_clicked();
}

void hk_kdedriverselect::help_clicked(void)
{
kapp->invokeHelp("introduction");
}
void hk_kdedriverselect::accept(void)
{
if (tabwidget->currentPage()==tab_2/*file dialog*/)
{
   p_driverselected=false;
    if (!p_filedialog->selectedFile().isEmpty())
    p_selectedfile=p_filedialog->selectedFile();


}

KConfig* c=kapp->config();
  c->setGroup("Driverselectdialog");
  c->writeEntry("Geometry",geometry());
QDialog::accept();
}


void hk_kdedriverselect::tabwidget_changed()
{
if (tabwidget->currentPage()==tab_2/*file dialog*/)
        connectbutton->setEnabled(!p_filedialog->selectedFile().isEmpty());
else
        connectbutton->setEnabled(hk_drivermanager::driverlist()>0);

}

void hk_kdedriverselect::file_selected(const QString& f)
{
KURL url=f;
p_selectedfile=url.directory()+"/"+url.fileName();
        connectbutton->setEnabled(!p_selectedfile.isEmpty());

}

void hk_kdedriverselect::option_clicked()
{
    hk_kdepreferencesdialog* p_dialog= new hk_kdepreferencesdialog(0,0,true);
    p_dialog->exec();
    delete p_dialog;

}

