<?php
/******************************
 * Knowledgeroot
 * Michael Fields
 * 20.06.2006
 *
 * This Class inherits from the PHPMailer class
 ******************************/
require_once('system/phpmailer/class.phpmailer.php');

class knowledgeroot_notification extends PHPMailer {
	var $CLASS = array();
	var $priority = 3;
	var $to_name;
	var $to_email;
	var $From = null;
	var $FromName = null;
	var $Sender = null;
	var $html = false;
    
	function knowledgeroot_notification(&$CLASS) {
		$this->CLASS =& $CLASS;
		
		$config = $this->CLASS['vars'];
	
		if($config['email']['smtp_mode'] == 1) {
			$this->Host = $config['email']['smtp_host'];
			$this->Port = $config['email']['smtp_port'];
			if($config['email']['smtp_username'] != '') {
				$this->SMTPAuth  = true;
				$this->Username  = $config['email']['smtp_username'];
				$this->Password  =  $config['email']['smtp_password'];
			}
			$this->Mailer = "smtp";
		}
		
		if(!$this->From) {
			$this->From = $config['email']['from_email'];
		}
	
		if(!$this->FromName) {
			$this-> FromName = $config['email']['from_name'];
		}
	
		if(!$this->Sender) {
			$this->Sender = $config['email']['from_email'];
		}
		
		$parts = explode( ",", $config['email']['recipients']);
	
		foreach ( $parts as $part ) {
			$this->AddAddress($part, null);
		}
	
		// uncomment this for verbose SMTP debugging
		// $this->SMTPDebug = true;
		$this->SetLanguage($config['knowledgeroot']['language'], "system/phpmailer/language/");
		$this->Priority = $this->priority;
		
		if($config['email']['type'] == "html") {
			$this->isHTML(true);
			$this->html = true;
		}
	}

	// send email notification
	// id show the id of the modified element
	function send_email_notification($pageid, $elementType, $action, $name = "", $id = "") {
		if($this->CLASS['vars']['email']['notification'] == 1) {
			// get pagetitle
			$pageTitle = $this->CLASS['path']->getTreePageTitle($pageid);
		
			// set emailsubject
			$this->Subject = $this->CLASS['language']->sys['email']['notification'] . ' (' . $this->CLASS['language']->sys['email'][$elementType] . ' "' . $name . '" ' . $this->CLASS['language']->sys['email'][$action] . ')';
			
			// make html mail or not
			if($this->html == true) {
				// get path
				$path = $this->CLASS['path']->getPath($pageid, $this->CLASS['kr_header']->get_base_url());
				
				$mailBody = '
				<html>
					<head>
						<title>' . $this->CLASS['language']->sys['email']['notification'] . '</title>
					</head>
					<body>
						<p>' . $this->CLASS['language']->sys['email']['notification'] . ': ' . $this->CLASS['language']->sys['email'][$elementType] . ' "' . $name . '" ' . $this->CLASS['language']->sys['email']['was'] . ' ' . $this->CLASS['language']->sys['email'][$action] . '.<br /><br />
						' . $this->CLASS['language']->sys['email']['pathofmodification'] . ': ' . $path . '<br />';
				
				if($id != "") {
					$mailBody .= 'ID: ' . $id . "\n";
				}
				
				$mailBody .= '</p>	
					</body>
				</html>';
			} else {
				// get path
				$path = $this->CLASS['path']->getTextPath($pageid, $this->CLASS['kr_header']->get_base_url());
				
				$mailBody = $this->CLASS['language']->sys['email']['notification'] . ": ". $this->CLASS['language']->sys['email'][$elementType] . " \"" .$name . "\" " . $this->CLASS['language']->sys['email']['was'] . " " . $this->CLASS['language']->sys['email'][$action] . "\n";
				$mailBody .= $this->CLASS['language']->sys['email']['pathofmodification'] . ": " . $path . "\n";
				
				if($id != "") {
					$mailBody .= "ID: ".$id."\n";
				}
			}
			
			// set emailbody
			$this->Body = $mailBody;
			
			// send email
			if (!$this->Send()) {
				$this->CLASS['kr_header']->addwarning($this->CLASS['language']->sys['email']['errormessage'] . ': ' . $this->ErrorInfo);
			}
			
			// do some cleanup
			$this->ClearAddresses();
			$this->ClearAttachments();
		}
	}
}
?>