<?php
/******************************
 * Knowledgeroot
 * Frank Habermann
 * 11.04.2006
 *
 * Version 0.2
 * This Class inherits functions for easier work
 ******************************/
 
class knowledgeroot {

	var $CLASS;
	
	function start(&$CLASS) {
		$this->CLASS =& $CLASS;
	}

	/**
	 * FROM Typo3
	 * AddSlash array
	 * This function traverses a multidimentional array and adds slashes to the values.
	 * NOTE that the input array is and argument by reference.!!
	 * Twin-function to stripSlashesOnArray
	 * Usage: 8
	 *
	 * @param	array		Multidimensional input array, (REFERENCE!)
	 * @return	array
	 */
	function addSlashesOnArray(&$theArray)	{
		if(get_magic_quotes_gpc() == 0) {
			if (is_array($theArray))	{
				reset($theArray);
				while(list($Akey,$AVal)=each($theArray))	{
					if (is_array($AVal))	{
						$this->addSlashesOnArray($theArray[$Akey]);
					} else {
						$theArray[$Akey] = addslashes($AVal);
					}
				}
				reset($theArray);
			}
		}
	}
	
	function rightpanel($userid = "") {
		// check if user have rights to set rights
		if(empty($userid)) {
			// user have no rights to see the panel
			return "";
		} else {
			if($this->CLASS['db']->dbtype == "pgsql") {
				$res = $this->CLASS['db']->query("SELECT u.id as uid, g.id as gid, u.name as user,g.name as group, u.defaultrights as rights, u.rightedit as rightedit FROM users u, groups g WHERE g.id=u.defaultgroup AND u.id='$userid'");
			} else {
				$res = $this->CLASS['db']->query("SELECT u.id as uid, g.id as gid, u.name as user,g.name as `group`, u.defaultrights as rights, u.rightedit as rightedit FROM users u, groups g WHERE g.id=u.defaultgroup AND u.id='$userid'");
			}
			
			$anz = $this->CLASS['db']->num_rows($res);

			if($anz == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);
				if($row['rightedit'] == 0) {
					return "";
				}
			}
		}
		
		$users = "\n<select name=\"user\">\n";
		$resusers = $this->CLASS['db']->query("SELECT id, name FROM users ORDER BY name ASC");
		while($rowuser = $this->CLASS['db']->fetch_assoc($resusers)) {
			if($row['uid'] == $rowuser['id']) {
				$users .= "\t<option value=\"" . $rowuser['id'] . "\" selected>" . $rowuser['name'] . "</option>\n";
			} else {
				$users .= "\t<option value=\"" . $rowuser['id'] . "\">" . $rowuser['name'] . "</option>\n";
			}
		}
		$users .= "</select>\n";
		
		$groups = "\n<select name=\"group\">\n";
		$resgroups = $this->CLASS['db']->query("SELECT id, name FROM groups ORDER BY name ASC");
		while($rowgroup = $this->CLASS['db']->fetch_assoc($resgroups)) {
			if($row['gid'] == $rowgroup['id']) {
				$groups .= "\t<option value=\"" . $rowgroup['id'] . "\" selected>" . $rowgroup['name'] . "</option>\n";
			} else {
				$groups .= "\t<option value=\"" . $rowgroup['id'] . "\">" . $rowgroup['name'] . "</option>\n";
			}
		}
		$groups .= "</select>\n";
		
		if(strlen($row['rights']) == 3) {
			$userright = substr($row['rights'],0,1);
			$groupright = substr($row['rights'],1,1);
			$otherright = substr($row['rights'],2,1);
			
			// Userrechte Dropdown
			$userrights = $this->rightDropDown("userrights",$userright);

			
			// Gruppenrechte Dropdown
			$grouprights = $this->rightDropDown("grouprights",$groupright);

			
			// Otherrechte Dropdown
			$otherrights = $this->rightDropDown("otherrights",$otherright);
		}
		
		$out = "";
		$out .= "<div class=\"rightpanel\" style=\"padding:10px 0px 0px 0px;\">\n";
		$out .= '	
			<table style="border: 1px solid #000000;" border="0" cellspacing="1" cellpadding="1" width="450">
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['user'].':</td><td style="padding:2px 2px 2px 2px;">' . $users . '</td><td>'.$this->CLASS['language']->get['rightpanel']['userrights'].':</td><td>' . $userrights . '</td></tr>
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['group'].':</td><td>' . $groups . '</td><td>'.$this->CLASS['language']->get['rightpanel']['grouprights'].':</td><td>' . $grouprights . '</td></tr>
				<tr><td colspan="2">&nbsp;</td><td>'.$this->CLASS['language']->get['rightpanel']['otherrights'].':</td><td>' . $otherrights . '</td></tr>
			</table>
			';
		$out .= "</div>\n";
		return $out;
	}
	
	function editRightPanel($userid,$groupid,$rights,$recursiv = 0) {
		//if(empty($userid)) {
		if($userid == "") {
			// you have no rights
			return "";
		}

		$res = $this->CLASS['db']->query("SELECT rightedit FROM users WHERE id='".$userid."'");
		$anz = $this->CLASS['db']->num_rows($res);
		
		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
		}

		
		
		if($_SESSION['rightedit'] != 1 && $_SESSION['admin'] == 0) {
			//you have no rights
			return "";
		}
		
		//user
		$res = $this->CLASS['db']->query("SELECT id,name FROM users ORDER BY name ASC");
		
		$users = "\n<select name=\"user\">\n";
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($row['id'] == $userid) {
				$users .= "\t<option value=\"".$row['id']."\" selected>".$row['name']."</option>\n";
			} else {
				$users .= "\t<option value=\"".$row['id']."\">".$row['name']."</option>\n";
			}
		}
		$users .= "</select>\n";
		
		//group
		$res = $this->CLASS['db']->query("SELECT id,name FROM groups ORDER BY name ASC");
		
		$groups = "\n<select name=\"group\">\n";
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($row['id'] == $groupid) {
				$groups .= "\t<option value=\"".$row['id']."\" selected>".$row['name']."</option>\n";
			} else {
				$groups .= "\t<option value=\"".$row['id']."\">".$row['name']."</option>\n";
			}
		}
		$groups .= "</select>\n";
		
		//userrights
		$userrights = $this->rightDropDown("userrights",substr($rights,0,1));
		//grouprights
		$grouprights = $this->rightDropDown("grouprights",substr($rights,1,1));
		//otherrights
		$otherrights = $this->rightDropDown("otherrights",substr($rights,2,1));
		
		if($recursiv == 1) {
			$recursivhtml = "<tr><td colspan=\"4\">".$this->CLASS['language']->get['rightpanel']['recursiv']."?&nbsp;\n";
			$recursivhtml .= "<select name=\"recursiv\">\n";
			$recursivhtml .= "\t<option value=\"\">".$this->CLASS['language']->get['no']."</option>\n";
			$recursivhtml .= "\t<option value=\"1\">".$this->CLASS['language']->get['yes']."</option>\n";
			$recursivhtml .= "</select>\n";
			$recursivhtml .= "</td></tr>\n";
		}
		
		$out = "";
		$out .= "<div class=\"rightpanel\" style=\"padding:10px 0px 0px 0px;\">\n";
		$out .= '	
			<table style="border: 1px solid #000000;" border="0" cellspacing="1" cellpadding="1" width="450">
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['user'].':</td><td style="padding:2px 2px 2px 2px;">' . $users . '</td><td>'.$this->CLASS['language']->get['rightpanel']['userrights'].':</td><td>' . $userrights . '</td></tr>
				<tr><td>'.$this->CLASS['language']->get['rightpanel']['group'].':</td><td>' . $groups . '</td><td>'.$this->CLASS['language']->get['rightpanel']['grouprights'].':</td><td>' . $grouprights . '</td></tr>
				<tr><td colspan="2">&nbsp;</td><td>'.$this->CLASS['language']->get['rightpanel']['otherrights'].':</td><td>' . $otherrights . '</td></tr>
				'.$recursivhtml.'
			</table>
			';
		$out .= "</div>\n";

		return $out;
	}
	
	function getPageRights($pageid, $userid) {
		if(!isset($pageid) || !isset($userid)) {
			return 0;
		}
	
		// get userrights
		$res = $this->CLASS['db']->query("SELECT * FROM users WHERE id=".$userid."");
		$anz = $this->CLASS['db']->num_rows($res);
		
		// check if user exists, if not - no rights
		if($anz == 0 && $userid != 0) {
			return 0;
		}
		
		// userrow
		$rowuser = $this->CLASS['db']->fetch_assoc($res);
		
		// check if user is admin, if yes then give full rights
		if($rowuser['admin'] == 1) {
			return 2;
		}
		
		// get pagerights
		$res = $this->CLASS['db']->query("SELECT * FROM tree WHERE id=".$pageid."");
		$anz = $this->CLASS['db']->num_rows($res);
		
		// check if page exists, if not - no rights
		if($anz == 0) {
			return 0;
		}
		
		// pagerow
		$rowpage = $this->CLASS['db']->fetch_assoc($res);
		
		if($rowpage['owner'] == $rowuser['id']) {
			return $rowpage['userrights'];
		}
		
		if($rowpage['group'] == $rowuser['defaultgroup']) {
			return $rowpage['grouprights'];
		}
		
		$res = $this->CLASS['db']->query("SELECT groupid FROM user_group WHERE userid=".$userid."");
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($row['groupid'] == $rowpage['group']) {
				return $rowpage['grouprights'];
			}
		}
		
		return $rowpage['otherrights'];
	}
	
	function getContentRights($contentid, $userid) {
		if(!isset($contentid) || !isset($userid)) {
			return 0;
		}

		// get userrights
		$res = $this->CLASS['db']->query("SELECT * FROM users WHERE id=".$userid."");
		$anz = $this->CLASS['db']->num_rows($res);

		// check if user exists, if not - no rights
		if($anz == 0 && $userid != 0) {
			return 0;
		}

		// userrow
		$rowuser = $this->CLASS['db']->fetch_assoc($res);
		
		// check if user is admin, if yes then give full rights
		if($rowuser['admin'] == 1) {
			return 2;
		}
		
		// get contentrights
		$res = $this->CLASS['db']->query("SELECT * FROM content WHERE id=".$contentid."");
		$anz = $this->CLASS['db']->num_rows($res);
		
		// check if content exists, if not - no rights
		if($anz == 0) {
			return 0;
		}
	
		// pagerow
		$rowcontent = $this->CLASS['db']->fetch_assoc($res);
		
		if($rowcontent['owner'] == $rowuser['id']) {
			return $rowcontent['userrights'];
		}
		
		if($rowcontent['group'] == $rowuser['defaultgroup']) {
			return $rowcontent['grouprights'];
		}
		
		$res = $this->CLASS['db']->query("SELECT groupid FROM user_group WHERE userid=".$userid."");
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($row['groupid'] == $rowcontent['group']) {
				return $rowcontent['grouprights'];
			}
		}

		return $rowcontent['otherrights'];
	}
	
	function yesno($value) {
		if($value == "1") {
			return $this->CLASS['language']->get['yes'];
		}

		return $this->CLASS['language']->get['no'];
	}
	
	function yesnodropdown($name, $default = 0) {
		$defaultno = ($default==0) ? " selected" : "";
		$defaultyes = ($default==1) ? " selected" : "";
		
		$out = "<select name=\"".$name."\">\n";
		$out .= "\t<option value=\"0\"" . $defaultno . ">".$this->CLASS['language']->get['no']."</option>\n";
		$out .= "\t<option value=\"1\"" . $defaultyes . ">".$this->CLASS['language']->get['yes']."</option>\n";
		$out .= "</select>\n";
		
		return $out;
	}
	
	function getGroup($id) {
		if($id == "") {
			return "";
		}
		
		$res = $this->CLASS['db']->query("SELECT name FROM groups WHERE id=$id");
		$anz = $this->CLASS['db']->num_rows($res);
		
		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
		}
		
		return $row['name'];
	}
	
	function getOwner($id) {
		if($id == "") {
			return "";
		}
		
		$res = $this->CLASS['db']->query("SELECT name FROM users WHERE id=$id");
		$anz = $this->CLASS['db']->num_rows($res);
		
		if($anz == 1) {
			$row = $this->CLASS['db']->fetch_assoc($res);
		}
		
		return $row['name'];
	}
	
	function groupDropDown($name, $default = "", $multiple = "no", $defaultgroups = array()) {
		if($multiple == "yes") {
			$out = "<select name=\"".$name."\" multiple=\"multiple\" size=\"5\">\"";
		} else {
			$out = "<select name=\"".$name."\">\"";
		}
		
		$res = $this->CLASS['db']->query("SELECT id,name FROM groups");
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($default == $row['id'] || $this->foundIDinArray($row['id'],$defaultgroups)) {
				$out .= "<option value=\"".$row['id']."\" selected>".$row['name']."</option>";
			} else {
				$out .= "<option value=\"".$row['id']."\">".$row['name']."</option>";
			}
		}
		
		$out .= "</select>\n";
		
		return $out;
	}
	
	function foundIDinArray($id,$arr) {
		if(!is_array($arr)) {
			$arr = array();
		}
		
		foreach($arr as $key => $value) {
			if($value == $id) {
				return 1;
			}
		}
		
		return 0;
	}
	
	function rightDropDown($name,$default = "") {
		$out = "<select name=\"".$name."\">\n";
		
		$selected1 = $default == 2 ? "selected" : "";
		$selected2 = $default == 1 ? "selected" : "";
		$selected3 = $default == 0 ? "selected" : "";
		
		$out .= "\t<option value=\"2\" ".$selected1.">".$this->CLASS['language']->get['readwrite']."</option>\n";
		$out .= "\t<option value=\"1\" ".$selected2.">".$this->CLASS['language']->get['read']."</option>\n";
		$out .= "\t<option value=\"0\" ".$selected3.">".$this->CLASS['language']->get['norights']."</option>\n";
		
		$out .= "</select>\n";
		return $out;
	}
	
	function checkRecursivPerm($pageid, $userid) {
		if($userid == "") {
			$userid = 0;
		}
		
		if(strlen($pageid) > 0 && strlen($userid) > 0) {
			$res = $this->CLASS['db']->query("SELECT id,belongs_to FROM tree WHERE id=".$pageid." and deleted=0");
			$anz = $this->CLASS['db']->num_rows($res);
			
			if($anz == 1) {
				$row = $this->CLASS['db']->fetch_assoc($res);
				
				if($row['belongs_to'] == 0) {
					return $this->getPageRights($row['id'],$userid);
				} else {
					$rights = $this->getPageRights($row['id'],$userid);
					if($rights == 0) {
						return 0;
					} else {
						return $this->checkRecursivPerm($row['belongs_to'],$userid);
					}
				}
			}
		}
		
		return 0;
	}
	
	function setRightsRecursiv($pageid,$userid,$user,$group,$rights) {
		$userrights = substr($rights,0,1);
		$grouprights = substr($rights,1,1);
		$otherrights = substr($rights,2,1);

		$res = $this->CLASS['db']->query("SELECT id FROM content WHERE belongs_to=$pageid AND deleted=0");
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($this->getContentRights($row['id'],$userid) == 2) {
				if($this->CLASS['db']->dbtype == "pgsql") {
					$ressub = $this->CLASS['db']->query("UPDATE content SET owner='".$user."', \"group\"='".$group."', userrights='".$userrights."', grouprights='".$grouprights."', otherrights='".$otherrights."' WHERE id=".$row['id']."");
				} else {
					$ressub = $this->CLASS['db']->query("UPDATE content SET owner='".$user."', `group`='".$group."', userrights='".$userrights."', grouprights='".$grouprights."', otherrights='".$otherrights."' WHERE id=".$row['id']."");
				}
			}
		}
		
		$res = $this->CLASS['db']->query("SELECT id FROM tree WHERE belongs_to=$pageid AND deleted=0");
		while($row = $this->CLASS['db']->fetch_assoc($res)) {
			if($this->getPageRights($row['id'],$userid) == 2) {
				if($this->CLASS['db']->dbtype == "pgsql") {
					$ressub = $this->CLASS['db']->query("UPDATE tree SET owner='".$user."', \"group\"='".$group."', userrights='".$userrights."', grouprights='".$grouprights."', otherrights='".$otherrights."' WHERE id=".$row['id']."");
				} else {
					$ressub = $this->CLASS['db']->query("UPDATE tree SET owner='".$user."', `group`='".$group."', userrights='".$userrights."', grouprights='".$grouprights."', otherrights='".$otherrights."' WHERE id=".$row['id']."");
				}
			
				$this->setRightsRecursiv($row['id'],$userid,$user,$group,$rights);
			}
		}
		
		return 1;
	}
}

?>