<?php
/**
 * This Class inerhits functions that show content in knowledgeroot
 *
 * @package Knowledgeroot
 * @author Frank Habermann
 * @version $Id: class-knowledgeroot-content.php 349 2007-04-17 21:33:29Z lordlamer $
 */
class knowledgeroot_content {
  var $CLASS;

  /**
   * init/start class
   */
  function start(&$CLASS) {
    $this->CLASS =& $CLASS;
  }

  /**
   * this function show the content
   */
  function show_content() {
    $this->CLASS['hooks']->setHook("kr_content","show_content","start");

    if(isset ($_GET['action']) and $_GET['action'] == "newcontent") {
      $this->new_content();
    } elseif(isset ($_GET['action']) and $_GET['action'] == "newpage") {
      $this->new_page();
    } elseif(isset ($_GET['action']) and $_GET['action'] == "editpage") {
      $this->edit_page();
    } elseif(isset ($_GET['eid']) and $_GET['eid'] != "") {
      $this->edit_content();
    } elseif (isset($_GET['action']) and $_GET['action'] == "showsearch" && isset($_GET['key']) and $_GET['key'] != "") {
      $this->show_search();
    } elseif(isset ($_GET['action']) and $_GET['action'] == "login") {
      $this->show_login();
    } elseif(isset ($_GET['action']) and $_GET['action'] == "createroot" && isset ($_SESSION['admin']) and $_SESSION['admin']) {
      $this->create_root();
    } elseif(((isset ($_GET['action']) and $_GET['action'] == "options") || (isset ($_POST['action']) and $_POST['action'] == "options")) && !empty($_SESSION['userid'])) {
      $this->show_options();
    } elseif(isset ($_GET['action']) and $_GET['action'] == "users" && isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) {
      $this->list_users();
    } elseif(isset ($_GET['action']) and $_GET['action'] == "adduser" && isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) {
      $this->add_user();
    } elseif(isset ($_GET['action']) and $_GET['action'] == "edituser" && isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) {
      $this->edit_user();
    } elseif(isset ($_GET['action']) and $_GET['action'] == "addgroup" && isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) {
      $this->add_group();
    } elseif(isset ($_GET['action']) and $_GET['action'] == "editgroup" && isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) {
      $this->edit_group();
    } elseif(isset ($_GET['action']) and $_GET['action'] == "error") {
      $this->show_error();
    } elseif($this->CLASS['kr_extension']->content != "") {
      $this->CLASS['kr_extension']->show_ext_content();
    } else {
      $this->show_tree_content();
    }

    $this->CLASS['hooks']->setHook("kr_content","show_content","end");
  }

  /**
   * create form for new content
   */
  function new_content() {
    if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2) {
      $this->CLASS['hooks']->setHook("kr_content","new_content","start");

      //echo "[<a href=\"index.php\">".$this->CLASS['language']->get['back']."</a>]<br /><br />";
      echo "<form action=\"index.php\" method=\"post\">";
      echo "<input type=\"hidden\" name=\"neditid\" value=\"new\" />";
      echo "<input type=\"hidden\" name=\"belongsto\" value=\"".$_SESSION['cid']."\" />";
      echo "<input type=\"hidden\" name=\"submit\" value=\"submit\" />";
      echo "<input class=\"button\" type=\"submit\" name=\"save\" value=\"".$this->CLASS['language']->get['save']."\" />";
      echo "<input class=\"button\" type=\"submit\" name=\"saveandclose\" value=\"".$this->CLASS['language']->get['saveandclose']."\" />";
      echo "<input class=\"button\" type=\"submit\" name=\"close\" value=\"".$this->CLASS['language']->get['close']."\" />";
      echo "<br />";
      if ($this->CLASS['vars']['knowledgeroot']['showtitle'] == "yes")
        echo '<br />'.$this->CLASS['language']->get['contenttitle'].'&nbsp;<input type="text" name="title" value="" size="50" /><br />';
      echo "<br />\n";

      $this->CLASS['hooks']->setHook("kr_content","new_content","show");

      if($this->CLASS['oFCKeditor']->use == 1 && $this->CLASS['vars']['htmleditor']['editor'] == "fckeditor") {
        $this->CLASS['oFCKeditor']->Value = '';
        $this->CLASS['oFCKeditor']->Create() ;
      } else {
        echo "<textarea name=\"content\" cols=\"".$this->CLASS['vars']['htmleditor']['tinymce']['cols']."\" rows=\"".$this->CLASS['vars']['htmleditor']['tinymce']['rows']."\">\n";
        echo "</textarea>\n";
      }

      // check for inheritrights
      $inheritrights = $this->CLASS['knowledgeroot']->getInheritRights($_SESSION['cid']);
      
      $show_rights = 0;
      if((is_array($inheritrights) && $inheritrights['subinheritrightseditable'] == 1) || $inheritrights == false) {
        $show_rights = 1;
      }

      //check rights!!!
      if((!empty($_SESSION['userid']) && $show_rights == 1) || (isset($_SESSION['admin']) && $_SESSION['admin'] == 1)) {
	echo "<br /><br />\n";
        echo $this->CLASS['knowledgeroot']->rightpanel($_SESSION['userid']);
      }
      
      echo "<br /><br />\n";
      echo "<input class=\"button\" type=\"submit\" name=\"save\" value=\"".$this->CLASS['language']->get['save']."\" />";
      echo "<input class=\"button\" type=\"submit\" name=\"saveandclose\" value=\"".$this->CLASS['language']->get['saveandclose']."\" />";
      echo "<input class=\"button\" type=\"submit\" name=\"close\" value=\"".$this->CLASS['language']->get['close']."\" />";
      echo "</form>";

      $this->CLASS['hooks']->setHook("kr_content","new_content","end");
    }
  }

  /**
   * this function create form for newpage
   */
  function new_page() {
    if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2) {
      $this->CLASS['hooks']->setHook("kr_content","new_page","start");

      echo "[<a href=\"index.php\">".$this->CLASS['language']->get['back']."</a>]<br /><br />";
      echo "<form action=\"index.php\" method=\"post\">";
      echo "<input type=\"hidden\" name=\"belongsto\" value=\"".$_SESSION['cid']."\" />";

      echo "<fieldset>\n";
          echo "\t<legend>".$this->CLASS['language']->get['createpageform']['title']."</legend>\n";

      echo "<div>".$this->CLASS['language']->get['createpageform']['description']."</div>\n";

      echo "<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\" width=\"450\">\n";

      echo "<tr><td>" . $this->CLASS['language']->get['createpageform']['name'] . ":</td><td><input type=\"hidden\" name=\"newpage\" value=\"new\" />";

      // automatically open the created page
      $auto_open = isset($_SESSION['auto_open']) && $_SESSION['auto_open'] == true ? "checked='checked'" : "";

      echo "<input type=\"text\" name=\"title\" value=\"\" />&nbsp;&nbsp;<input type=\"checkbox\" name=\"auto_open\" $auto_open value=\"true\" /><span style='vertical-align:middle'> ".$this->CLASS['language']->get['createpageform']['autoopen'] . "</span></td></tr>\n";

      // check for rights to show/edit alias
      if($this->CLASS['vars']['pagealias']['use'] == 1 && (($this->CLASS['vars']['pagealias']['rights'] == 2 && isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) || ($this->CLASS['vars']['pagealias']['rights'] == 1 && $_SESSION['userid'] != 0) || ($this->CLASS['vars']['pagealias']['rights'] == 0))) {
        echo "<tr><td>" . $this->CLASS['language']->get['createpageform']['alias'] . ":</td><td><input type=\"text\" name=\"alias\" value=\"\" /></td></tr>\n";
      }

      $this->CLASS['hooks']->setHook("kr_content","new_page","show");

      echo "<tr><td></td><td><input class=\"button\" type=\"submit\" name=\"submit\" value=\"".$this->CLASS['language']->get['createpageform']['button']."\" />";

      echo "</table>\n";

      // check for inheritrights
      $inheritrights = $this->CLASS['knowledgeroot']->getInheritRights($_SESSION['cid']);
      
      $show_rights = 0;
      if((is_array($inheritrights) && $inheritrights['subinheritrightseditable'] == 1) || $inheritrights == false) {
        $show_rights = 1;
      }

      //check rights!!!
      if((!empty($_SESSION['userid']) && $show_rights == 1) || (isset($_SESSION['admin']) && $_SESSION['admin'] == 1)) {
        $panel = $this->CLASS['knowledgeroot']->rightpanel($_SESSION['userid']);
	
	if($panel != "") {
          echo "<fieldset><legend>".$this->CLASS['language']->get['rightpanel']['pagerights']."</legend>\n";
          echo $panel;
	  echo "</fieldset>\n";
	}
      }
      
      if(isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) {
        echo "<fieldset><legend>".$this->CLASS['language']->get['rightpanel']['pagerightsforsubpages']."</legend>\n";
        echo $this->CLASS['knowledgeroot']->rightpanelsubinherit($_SESSION['userid']);
	echo "</fieldset>\n";
      }

      echo "</fieldset>\n";

      echo "</form>";

      $this->CLASS['hooks']->setHook("kr_content","new_page","end");
    }
  }

  /**
   * this function create form for edit page
   */
  function edit_page() {
    if($this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']) == 2) {
      $this->CLASS['hooks']->setHook("kr_content","edit_page","start");

      $res = $this->CLASS['db']->query(sprintf("SELECT * FROM tree WHERE id=%d",$_SESSION['cid']));
      $anz = $this->CLASS['db']->num_rows($res);

      if($anz == 1) {
        $row = $this->CLASS['db']->fetch_assoc($res);

        echo "[<a href=\"index.php\">".$this->CLASS['language']->get['back']."</a>]<br /><br />";
        echo "<form action=\"index.php\" method=\"post\">";
        echo "<input type=\"hidden\" name=\"editpage\" value=\"".$_SESSION['cid']."\" />\n";

        echo "<fieldset>\n";
        echo "\t<legend>".$this->CLASS['language']->get['editpageform']['title']."</legend>\n";

        echo "<div>".$this->CLASS['language']->get['editpageform']['description']."</div>\n";

        echo "<table border=\"0\" cellspacing=\"1\" cellpadding=\"1\" width=\"450px\">\n";

        echo "<tr><td style=\"width:100px\">".$this->CLASS['language']->get['editpageform']['name'].":</td><td><input type=\"text\" name=\"title\" value=\"".$row['title']."\" /></td></tr>\n";

        // check for rights to show/edit alias
        if($this->CLASS['vars']['pagealias']['use'] == 1 && (($this->CLASS['vars']['pagealias']['rights'] == 2 && isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) || ($this->CLASS['vars']['pagealias']['rights'] == 1 && $_SESSION['userid'] != 0) || ($this->CLASS['vars']['pagealias']['rights'] == 0))) {
          echo "<tr><td>".$this->CLASS['language']->get['editpageform']['alias'].":</td><td><input type=\"text\" name=\"alias\" value=\"".$row['alias']."\" /></td></tr>\n";
        }

        if ($this->CLASS['vars']['knowledgeroot']['collapsecontent'] == "yes") {
          echo "<tr><td colspan=\"2\"><input type=\"checkbox\" name=\"contentcollapsed\" ". ($row['contentcollapsed'] == 1 ? "checked" : "").">&nbsp;&nbsp;".$this->CLASS['language']->get['editpageform']['collapsecontent']."</td></tr>\n";
        }

        $this->CLASS['hooks']->setHook("kr_content","edit_page","show");

        echo "<tr><td></td><td><input class=\"button\" type=\"submit\" name=\"submit\" value=\"".$this->CLASS['language']->get['editpageform']['button']."\" /></tr>\n";

        echo "</table>\n";

      // check for inheritrights
      $inheritrights = $this->CLASS['knowledgeroot']->getInheritRights($_SESSION['cid']);

      $show_rights = 0;
      if((is_array($inheritrights) && $inheritrights['subinheritrightseditable'] == 1) || $inheritrights == false) {
        $show_rights = 1;
      }
      
        //check rights
        if((!empty($_SESSION['userid']) && $show_rights == 1) || (isset($_SESSION['admin']) && $_SESSION['admin'] == 1)) {
	  $panel = $this->CLASS['knowledgeroot']->editRightPanel($row['owner'],$row['group'],$row['userrights'].$row['grouprights'].$row['otherrights'],1);
	  if($panel != "") {
	    echo "<fieldset><legend>".$this->CLASS['language']->get['rightpanel']['pagerights']."</legend>\n";
            echo $panel;
	    echo "</fieldset>\n";
	  }
        }
	
      if(isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) {
        echo "<fieldset><legend>".$this->CLASS['language']->get['rightpanel']['pagerightsforsubpages']."</legend>\n";
        echo $this->CLASS['knowledgeroot']->editRightPanelSubInherit($row['subinheritrights'],$row['subinheritrightseditable'],$row['subinheritrightsdisable'],$row['subinheritowner'],$row['subinheritgroup'],$row['subinherituserrights'],$row['subinheritgrouprights'],$row['subinheritotherrights']);
	echo "</fieldset>\n";
      }

        echo "</fieldset>\n";

        echo "</form>";
      }

      $this->CLASS['hooks']->setHook("kr_content","edit_page","end");
    }
  }

  /**
   * this function create form for edit content
   */
  function edit_content() {
    if($this->CLASS['knowledgeroot']->getContentRights($_GET['eid'],$_SESSION['userid']) == 2) {
      $this->CLASS['hooks']->setHook("kr_content","edit_content","start");

      // save that this content is edited
      $this->CLASS['knowledgeroot']->openContent($_GET['eid'],$_SESSION['userid']);

      // show warning if another user is editing this content
      if($this->CLASS['knowledgeroot']->isOpenContent($_GET['eid'],$_SESSION['userid'])) {
        echo '
          <div id="contentwarning">
          '.$this->CLASS['language']->get['messagebox']['warning'].'
          </div>
        ';
      }

      // show content
      //echo "[<a href=\"index.php\">".$this->CLASS['language']->get['back']."</a>]<br /><br />";
      echo "<form action=\"index.php\" method=\"post\">";
      echo "<input type=\"hidden\" name=\"editid\" value=\"".$_GET['eid']."\" />\n";
      echo "<input type=\"hidden\" name=\"submit\" value=\"submit\" />\n";
      echo "<input class=\"button\" type=\"submit\" name=\"save\" value=\"".$this->CLASS['language']->get['save']."\" />\n";
      echo "<input class=\"button\" type=\"submit\" name=\"saveandclose\" value=\"".$this->CLASS['language']->get['saveandclose']."\" />\n";
      echo "<input class=\"button\" type=\"submit\" name=\"close\" value=\"".$this->CLASS['language']->get['close']."\" />\n";

      $res = $this->CLASS['db']->query(sprintf("SELECT * FROM content WHERE id=%d ORDER BY id ASC",$_GET['eid']));

      while($row = $this->CLASS['db']->fetch_assoc($res)) {
        echo "<br />";
        if ($this->CLASS['vars']['knowledgeroot']['showtitle'] == "yes")
          echo "<br />".$this->CLASS['language']->get['contenttitle']."&nbsp;<input type=\"text\" name=\"title\" value=\"" . $row['title'] . "\" size=\"50\" /><br />\n";

        $this->CLASS['hooks']->setHook("kr_content","edit_content","show");

        echo "<br />\n";

        if($this->CLASS['oFCKeditor']->use == 1 && $this->CLASS['vars']['htmleditor']['editor'] == "fckeditor") {
          $this->CLASS['oFCKeditor']->Value = $row['content'];
          $this->CLASS['oFCKeditor']->Create() ;
        } else {
          echo "<textarea name=\"content\" cols=\"".$this->CLASS['vars']['htmleditor']['tinymce']['cols']."\" rows=\"".$this->CLASS['vars']['htmleditor']['tinymce']['rows']."\">\n";
          echo stripslashes($row['content']);
          echo "</textarea>\n";
        }

      // check for inheritrights
      $inheritrights = $this->CLASS['knowledgeroot']->getInheritRights($_SESSION['cid']);
      
      $show_rights = 0;
      if((is_array($inheritrights) && $inheritrights['subinheritrightseditable'] == 1) || $inheritrights == false) {
        $show_rights = 1;
      }
      
        //check rights
        if((!empty($_SESSION['userid']) && $show_rights == 1) || (isset($_SESSION['admin']) && $_SESSION['admin'] == 1)) {
          echo "<br /><br />\n";
          echo $this->CLASS['knowledgeroot']->editRightPanel($row['owner'],$row['group'],$row['userrights'].$row['grouprights'].$row['otherrights']);
        }
      }

      $this->CLASS['hooks']->setHook("kr_content","edit_content","show_after");

      echo "<br /><br />\n";
      echo "<input class=\"button\" type=\"submit\" name=\"save\" value=\"".$this->CLASS['language']->get['save']."\" />\n";
      echo "<input class=\"button\" type=\"submit\" name=\"saveandclose\" value=\"".$this->CLASS['language']->get['saveandclose']."\" />\n";
      echo "<input class=\"button\" type=\"submit\" name=\"close\" value=\"".$this->CLASS['language']->get['close']."\" />\n";
      echo "</form>\n";

      $this->CLASS['hooks']->setHook("kr_content","edit_content","end");
    }
  }

  /**
   * this function shows search
   */
  function show_search() {
    $this->CLASS['hooks']->setHook("kr_content","show_search","start");

    if(!isset($_SESSION['search'][$_GET['key']])) $searchword = "";
    else $searchword = $_SESSION['search'][$_GET['key']];

    if($this->CLASS['vars']['knowledgeroot']['charset'] == "utf8") {
      $charset = "UTF-8";
    } else {
      $charset = $this->CLASS['vars']['knowledgeroot']['charset'];
    }

    $searchwordhtml = @htmlentities($searchword,ENT_NOQUOTES,$charset);

    echo $this->CLASS['language']->get['searchfor'] . " <b>'" . stripslashes($searchword) . "'</b><br /><br />";

    // contentsearch

    echo "<h3>" . $this->CLASS['language']->get['searchcontent'] . ":</h3>\n";

    $this->CLASS['hooks']->setHook("kr_content","show_search","content_search_start");

    $_SESSION['userid'] = $_SESSION['userid'] == "" ? 0 : $_SESSION['userid'];
    $_SESSION['groupid'] = $_SESSION['userid'] == "" ? 0 : $_SESSION['groupid'];

    if(isset($_SESSION['admin']) && $_SESSION['admin'] == 1) {
      if($this->CLASS['db']->dbtype == "pgsql") {
        $sql = sprintf("SELECT id,belongs_to,content,title FROM content WHERE (content ilike '%%%s%%' OR content ilike '%%%s%%' OR title ilike '%%%s%%' OR title ilike '%%%s%%') AND deleted=0",$searchword,$searchwordhtml,$searchword,$searchwordhtml);
      } else {
        $sql = sprintf("SELECT id,belongs_to,content,title FROM content WHERE (content like '%%%s%%' OR content like '%%%s%%' OR title like '%%%s%%' OR title like '%%%s%%') AND deleted=0",$searchword,$searchwordhtml,$searchword,$searchwordhtml);
      }
    } else {
      // get groups from user
      $res = $this->CLASS['db']->query(sprintf("SELECT groupid FROM user_group WHERE userid=%d",$_SESSION['userid']));
      $orclause = "";
      while($rowuser = $this->CLASS['db']->fetch_assoc($res)) {
        if($this->CLASS['db']->dbtype == "pgsql") {
          $orclause .= sprintf("OR (\"group\"=%d  AND grouprights > 0) ",$rowuser['groupid']);
        } else {
          $orclause .= sprintf("OR (`group`=%d  AND grouprights > 0) ",$rowuser['groupid']);
        }
      }

      if($this->CLASS['db']->dbtype == "pgsql") {
        $sql = sprintf("SELECT id,belongs_to,content,title FROM content WHERE (content ilike '%%%s%%' OR content ilike '%%%s%%' OR title ilike '%%%s%%' OR title ilike '%%%s%%') AND deleted=0 AND ((otherrights > 0) OR (\"group\"=%d AND grouprights > 0) %sOR (owner=%d AND userrights>0))",$searchword,$searchwordhtml,$searchword,$searchwordhtml,$_SESSION['groupid'],$orclause,$_SESSION['userid']);
      } else {
        $sql = sprintf("SELECT id,belongs_to,content,title FROM content WHERE (content like '%%%s%%' OR content like '%%%s%%' OR title like '%%%s%%' OR title like '%%%s%%') AND deleted=0 AND ((otherrights > 0) OR (`group`=%d AND grouprights > 0) %sOR (owner=%d AND userrights>0))",$searchword,$searchwordhtml,$searchword,$searchwordhtml,$_SESSION['groupid'],$orclause,$_SESSION['userid']);
      }
    }

    $res = $this->CLASS['db']->query($sql);
    $anz = $this->CLASS['db']->num_rows($res);

    if($anz != 0) {
      $x = 0;
      while($row = $this->CLASS['db']->fetch_assoc($res)) {
        //echo $row['id'];
        if($this->CLASS['knowledgeroot']->checkRecursivPerm($row['belongs_to'],$_SESSION['userid']) != 0) {
          echo $this->CLASS['path']->getPath($row['belongs_to']) . "&nbsp;/&nbsp;". (($row['title'] != "") ? "\"<a href=\"index.php?highlight=".urlencode($searchword)."&amp;id=" . $row['belongs_to'] . "#" . $row['id'] . "\">".$row['title']."</a>\"&nbsp;" : "") ."[<a href=\"index.php?highlight=".urlencode($searchword).
"&amp;id=" . $row['belongs_to'] . "#" . $row['id'] . "\">" . $this->CLASS['language']->get['searchshow'] . "</a>]<br />\n";
          $x++;
        }
      }

      if($x == 0) {
        echo $this->CLASS['language']->get['nothingfound'] . "<br />\n";
      }
    } else {
      echo $this->CLASS['language']->get['nothingfound'];
    }

    $this->CLASS['hooks']->setHook("kr_content","show_search","content_search_end");

    echo "<hr>\n";

    // tree search

    echo "<h3>" . $this->CLASS['language']->get['searchmenu'] . ":</h3>\n";

    $this->CLASS['hooks']->setHook("kr_content","show_search","tree_search_start");

    if($this->CLASS['db']->dbtype == "pgsql") {
      $sql = sprintf("SELECT id,belongs_to,title FROM tree WHERE title ilike '%%%s%%'",$searchword);
    } else {
      $sql = sprintf("SELECT id,belongs_to,title FROM tree WHERE title like '%%%s%%'",$searchword);
    }

    $res = $this->CLASS['db']->query($sql);
    $anz = $this->CLASS['db']->num_rows($res);

    if($anz != 0) {
      $x = 0;
      while($row = $this->CLASS['db']->fetch_assoc($res)) {
        if($this->CLASS['knowledgeroot']->checkRecursivPerm($row['id'], $_SESSION['userid']) != 0) {
          echo $this->CLASS['path']->getPath($row['id']) . "<br />\n";
          $x++;
        }
      }

      if($x == 0) {
        echo $this->CLASS['language']->get['nothingfound'] . "<br />\n";
      }
    } else {
      echo $this->CLASS['language']->get['nothingfound'] . "<br />\n";
    }

    $this->CLASS['hooks']->setHook("kr_content","show_search","tree_search_end");

    echo "<hr>\n";

    // file search

    echo "<h3>" . $this->CLASS['language']->get['searchfiles'] . ":</h3>\n";

    $this->CLASS['hooks']->setHook("kr_content","show_search","file_search_start");

    if($this->CLASS['db']->dbtype == "pgsql") {
      $sql = sprintf("SELECT f.id as id,t.id as tid,f.filename,f.filesize, to_char(f.date,'DD.MM.YYYY HH24:MI:SS') AS dateform, f.owner AS owner FROM files f, tree t, content c WHERE f.belongs_to = c.id AND c.belongs_to = t.id AND f.deleted=0 AND filename ilike '%%%s%%'",$searchword);
    } else {
      $query = "SELECT f.id AS id, t.id AS tid, f.filename, f.filesize,
                  DATE_FORMAT(f.date,'%d.%m.%Y %H:%i:%s') AS dateform, f.owner AS owner
                FROM (files f, tree t, content c)";
      $sql = $query.sprintf(" WHERE f.belongs_to = c.id AND c.belongs_to = t.id AND f.deleted=0 AND
                filename like '%%%s%%'",
                $searchword);
    }

    $res = $this->CLASS['db']->query($sql);
    $anz = $this->CLASS['db']->num_rows($res);

    if($anz != 0) {
      $x = 0;
      while($row = $this->CLASS['db']->fetch_assoc($res)) {
        // get file information
        $title = "";
        if($row['owner'] == NULL || $row['owner'] == 0 || $row['owner'] == "") {
          $title = $row['dateform'];
        } else {
          $title = $this->CLASS['knowledgeroot']->getOwner($row['owner']) . " - " . $row['dateform'];
        }

        // show file
        if($this->CLASS['knowledgeroot']->checkRecursivPerm($row['tid'], $_SESSION['userid']) != 0) {
          echo $this->CLASS['path']->getPath($row['tid']) . "&nbsp;/\n";
          echo "<a href=\"index.php?download=".$row['id']."\" title=\"".$title."\"><img src=\"images/file.gif\" class=\"upload\" /> ".$row['filename']."</a>&nbsp;<font class=\"text\">[".getfilesize($row['filesize'])."]&nbsp;[".$title."]</font><br />\n";
          $x++;
        }
      }

      if($x == 0) {
        echo $this->CLASS['language']->get['nothingfound'] . "<br />\n";
      }
    } else {
      echo $this->CLASS['language']->get['nothingfound'] . "<br />\n";
    }

    $this->CLASS['hooks']->setHook("kr_content","show_search","file_search_end");

    $this->CLASS['hooks']->setHook("kr_content","show_search","end");
  }

  /**
   * form for login
   */
  function show_login() {
    $this->CLASS['hooks']->setHook("kr_content","show_login","start");

    echo '
      <div class="loginform">

      <fieldset>
            <legend><b>'.$this->CLASS['language']->get['loginform']['title'].'</b></legend>

      <form action="index.php" method="post" name="loginformular">
      <input type="hidden" name="'.session_name().'" value="'.session_id().'" />
      <table class="loginform" border="0" cellspacing="0" cellpadding="0" width="300">
        <tr><td><b style="color:#FFFFFF">Login</b></td></tr>
        <tr><td>'.$this->CLASS['language']->get['loginform']['user'].':</td><td align="right" style="padding:2px 2px 2px 2px;"><input type="text" name="user" value="" size="20" /></td></tr>
        <tr><td>'.$this->CLASS['language']->get['loginform']['password'].':</td><td align="right" style="padding:2px 2px 2px 2px;"><input type="password" name="password" value="" size="20" /></td></tr>
        <tr><td colspan="2" align="right" style="padding:2px 2px 2px 2px;"><input class="button" type="submit" name="login" value="'.$this->CLASS['language']->get['loginform']['submit'].'" /></td></tr>
      </table>
      </form>

      </fieldset>
      </div>
    ';

    echo '<script type="text/javascript">
      <!--
      document.loginformular.user.focus();
      //-->
    </script>'."\n";

    $this->CLASS['hooks']->setHook("kr_content","show_login","end");
  }

  /**
   * form for create root
   */
  function create_root() {
    $this->CLASS['hooks']->setHook("kr_content","create_root","start");

    // rechte checken -> adminrechte
    echo '
      <h2>'.$this->CLASS['language']->get['rootform']['title'].'</h2>
      <div class="createroot">
      <form action="index.php" method="post">
      <input type="hidden" name="action" value="createroot" />
      <input type="hidden" name="'.session_name().'" value="'.session_id().'" />

      <fieldset>
            <legend><b>'.$this->CLASS['language']->get['rootform']['title'].'</b></legend>

      <table border="0" cellspacing="1" cellpadding="1" width="300">
        <tr><td>'.$this->CLASS['language']->get['rootform']['name'].':</td><td style="padding:2px 2px 2px 2px;" colspan="3"><input type="text" name="title" value="" size="20" /></td></tr>';

    echo '    <tr><td>'.$this->CLASS['language']->get['rootform']['alias'].':</td><td style="padding:2px 2px 2px 2px;" colspan="3"><input type="text" name="alias" value="" size="20" /></td></tr>';

    echo '    <tr><td></td><td><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['rootform']['submit'].'" /></td></tr>
      </table><p />';

    if(!empty($_SESSION['userid'])) {
        echo "<fieldset><legend>".$this->CLASS['language']->get['rightpanel']['pagerights']."</legend>\n";
        echo $this->CLASS['knowledgeroot']->rightpanel($_SESSION['userid']);
	echo "</fieldset>\n";
        echo "<fieldset><legend>".$this->CLASS['language']->get['rightpanel']['pagerightsforsubpages']."</legend>\n";
        echo $this->CLASS['knowledgeroot']->rightpanelsubinherit($_SESSION['userid']);
	echo "</fieldset>\n";
      }
    
    echo '</fieldset></form>
      </div>
    ';

    $this->CLASS['hooks']->setHook("kr_content","create_root","end");
  }

  /**
   * form for options
   */
  function show_options() {
    $this->CLASS['hooks']->setHook("kr_content","show_options","start");

    echo '
      <h2>'.$this->CLASS['language']->get['optionform']['title'].'</h2>
      <fieldset>
            <legend><b>'.$this->CLASS['language']->get['optionform']['subtitle'].'</b></legend>

      <form action="index.php" method="post">
      <input type="hidden" name="action" value="options" />
      <table border="0" cellpadding="0" cellspacing="0" width="300">
        <tr><td>'.$this->CLASS['language']->get['optionform']['newpassword'].':</td><td align="right" style="padding:2px 2px 2px 2px;"><input type="password" name="password" value="" /></td></tr>
        <tr><td>'.$this->CLASS['language']->get['optionform']['newpassword2'].':</td><td align="right" style="padding:2px 2px 2px 2px;"><input type="password" name="password1" value="" /></td></tr>
        <tr><td>'.$this->CLASS['language']->get['optionform']['theme'].':</td><td align="right" style="padding:2px 2px 2px 2px;">'.$this->CLASS['themes']->theme_dropdown($_SESSION['theme']).'</td></tr>
        <tr><td>'.$this->CLASS['language']->get['optionform']['language'].':</td><td align="right" style="padding:2px 2px 2px 2px;">'.$this->CLASS['language']->lang_dropdown("language",$_SESSION['language']).'</td></tr>
        <tr><td align="right" colspan="2" style="padding:2px 2px 2px 2px;"><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['optionform']['submit'].'" /></td></tr>
      </table>
      </form>

      </fieldset>
    ';

    $this->CLASS['hooks']->setHook("kr_content","show_options","end");
  }

  /**
   * list users
   */
  function list_users() {
    $this->CLASS['hooks']->setHook("kr_content","list_users","start");

    // list users
    echo '
      <h2>'.$this->CLASS['language']->get['userform']['usertitle'].'</h2>
      [<a href="index.php?action=adduser">'.$this->CLASS['language']->get['userform']['adduser'].'</a>]<br />
      <table style="border:1px solid #000000;" cellpadding="1" cellspacing="1">
        <tr><td>'.$this->CLASS['language']->get['userform']['username'].'</td><td>'.$this->CLASS['language']->get['userform']['defaultgroup'].'</td><td>'.$this->CLASS['language']->get['userform']['defaultrights'].'</td><td>'.$this->CLASS['language']->get['userform']['admin'].'</td><td>'.$this->CLASS['language']->get['userform']['rightedit'].'</td><td>'.$this->CLASS['language']->get['userform']['enabled'].'</td><td>'.$this->CLASS['language']->get['userform']['action'].'</td></tr>
    ';

    $res = $this->CLASS['db']->query("SELECT * FROM users");
    while($row = $this->CLASS['db']->fetch_assoc($res)) {
      echo "<tr><td>".$row['name']."</td><td>".$this->CLASS['knowledgeroot']->getGroup($row['defaultgroup'])."</td><td>".$row['defaultrights']."</td><td>".$this->CLASS['knowledgeroot']->yesno($row['admin'])."</td><td>".$this->CLASS['knowledgeroot']->yesno($row['rightedit'])."</td><td>".$this->CLASS['knowledgeroot']->yesno($row['enabled'])."</td><td>[<a href=\"index.php?action=edituser&amp;uid=".$row['id']."\">".$this->CLASS['language']->get['userform']['edit']."</a>]&nbsp;[<a href=\"index.php?action=deluser&amp;uid=".$row['id']."\" onclick=\"return confirm('" . $this->CLASS['language']->get['userform']['deluserask'] . "');\">".$this->CLASS['language']->get['userform']['delete']."</a>]</td></tr>\n";
    }

    echo '
      </table>
    ';

    // list groups
    echo '
      <h2>'.$this->CLASS['language']->get['userform']['grouptitle'].'</h2>
      [<a href="index.php?action=addgroup">'.$this->CLASS['language']->get['userform']['addgroup'].'</a>]<br />
      <table style="border:1px solid #000000;" cellpadding="1" cellspacing="1">
        <tr><td>'.$this->CLASS['language']->get['userform']['groupname'].'</td><td>'.$this->CLASS['language']->get['userform']['action'].'</td></tr>
    ';

    $res = $this->CLASS['db']->query("SELECT * FROM groups");
    while($row = $this->CLASS['db']->fetch_assoc($res)) {
      echo "<tr><td>".$row['name']."</td><td>[<a href=\"index.php?action=editgroup&amp;gid=".$row['id']."\">".$this->CLASS['language']->get['userform']['edit']."</a>]&nbsp;[<a href=\"index.php?action=delgroup&amp;gid=".$row['id']."\" onclick=\"return confirm('" . $this->CLASS['language']->get['userform']['delgroupask'] . "');\">".$this->CLASS['language']->get['userform']['delete']."</a>]</td></tr>\n";
    }

    echo '
      </table>
    ';

    $this->CLASS['hooks']->setHook("kr_content","list_users","end");
  }

  /**
   * add user
   */
  function add_user() {
    $this->CLASS['hooks']->setHook("kr_content","add_user","start");

    echo '
      <h2>'.$this->CLASS['language']->get['userform']['adduser'].'</h2>

      <form action="index.php" method="post">
      <input type="hidden" name="action" value="adduser">

      <fieldset>
            <legend><b>'.$this->CLASS['language']->get['userform']['newuser'].'</b></legend>
      <table border="0" cellpadding="1" cellspacing="3">
      <tr><td>'.$this->CLASS['language']->get['userform']['username'].': </td><td><input type="text" name="name" value="" /></td></tr>
      <tr><td>'.$this->CLASS['language']->get['userform']['password'].': </td><td><input type="password" name="password" value="" /></td></tr>
      <tr><td>'.$this->CLASS['language']->get['userform']['theme'].': </td><td>' . $this->CLASS['themes']->theme_dropdown() . '</td></tr>
      <tr><td>'.$this->CLASS['language']->get['userform']['defaultgroup'].': </td><td>' . $this->CLASS['knowledgeroot']->groupdropdown("defaultgroup") . '</td></tr>
      <tr><td>'.$this->CLASS['language']->get['userform']['admin'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("admin") . '</td></tr>
      <tr><td>'.$this->CLASS['language']->get['userform']['rightedit'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("rightedit") . '</td></tr>
      <tr><td>'.$this->CLASS['language']->get['userform']['enabled'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("enabled") . '</td></tr>
      <tr><td valign="top">'.$this->CLASS['language']->get['userform']['groups'].': </td><td> ' . $this->CLASS['knowledgeroot']->groupDropDown("groups[]","","yes") . ' </td></tr>
      <tr><td>'.$this->CLASS['language']->get['userform']['defaultrights'].': </td><td></td></tr>
      <tr><td>&nbsp;'.$this->CLASS['language']->get['userform']['user'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("userrights",2).'</td></tr>
      <tr><td>&nbsp;'.$this->CLASS['language']->get['userform']['group'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("grouprights",1).'</td></tr>
      <tr><td>&nbsp;'.$this->CLASS['language']->get['userform']['others'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("otherrights",1).'</td></tr>
    ';

    $this->CLASS['hooks']->setHook("kr_content","add_user","show");

    echo '  <tr><td></td><td align="left"><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['userform']['submit'].'" /></td></tr>
      </table>
        </fieldset>
      </form>

    ';

    $this->CLASS['hooks']->setHook("kr_content","add_user","end");
  }

  /**
   * edit user
   */
  function edit_user() {
    $this->CLASS['hooks']->setHook("kr_content","edit_user","start");

    $res = $this->CLASS['db']->query(sprintf("SELECT * FROM users WHERE id=%d",$_GET['uid']));
    $anz = $this->CLASS['db']->num_rows($res);

    if($anz == 1) {
      $row = $this->CLASS['db']->fetch_assoc($res);

      //fetch groups
      $res = $this->CLASS['db']->query(sprintf("SELECT * FROM user_group WHERE userid=%d",$row['id']));
      $x = 0;
      $grouparr = array();
      while($rowgroup = $this->CLASS['db']->fetch_assoc($res)) {
        $grouparr[$x] = $rowgroup['groupid'];
        $x++;
      }

      echo '
        <h2>'.$this->CLASS['language']->get['userform']['edituser'].'</h2>

        <form action="index.php" method="post">
        <input type="hidden" name="action" value="edituser" />
        <input type="hidden" name="uid" value="'.$row['id'].'" />

        <fieldset>
          <legend><b>'.$this->CLASS['language']->get['userform']['edituser'].'</b></legend>

        <table border="0" cellpadding="1" cellspacing="3">
        <tr><td>'.$this->CLASS['language']->get['userform']['username'].': </td><td><input type="text" name="name" value="'.$row['name'].'" /></td></tr>
        <tr><td>'.$this->CLASS['language']->get['userform']['password'].': </td><td><input type="password" name="password" value="" /></td></tr>
        <tr><td>'.$this->CLASS['language']->get['userform']['theme'].': </td><td>' . $this->CLASS['themes']->theme_dropdown($row['theme']) . '</td></tr>
        <tr><td>'.$this->CLASS['language']->get['userform']['defaultgroup'].': </td><td>' . $this->CLASS['knowledgeroot']->groupdropdown("defaultgroup",$row['defaultgroup']) . '</td></tr>
        <tr><td>'.$this->CLASS['language']->get['userform']['admin'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("admin", $row['admin']) . '</td></tr>
        <tr><td>'.$this->CLASS['language']->get['userform']['rightedit'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("rightedit",$row['rightedit']) . '</td></tr>
        <tr><td>'.$this->CLASS['language']->get['userform']['enabled'].': </td><td>' . $this->CLASS['knowledgeroot']->yesnodropdown("enabled",$row['enabled']) . '</td></tr>
        <tr><td valign="top">'.$this->CLASS['language']->get['userform']['groups'].': </td><td>' . $this->CLASS['knowledgeroot']->groupDropDown("groups[]","","yes",$grouparr) . ' </td></tr>
        <tr><td>'.$this->CLASS['language']->get['userform']['defaultrights'].': </td><td></td></tr>
        <tr><td>&nbsp; '.$this->CLASS['language']->get['userform']['user'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("userrights",substr($row['defaultrights'],0,1)).'</td></tr>
        <tr><td>&nbsp; '.$this->CLASS['language']->get['userform']['group'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("grouprights",substr($row['defaultrights'],1,1)).'</td></tr>
        <tr><td>&nbsp; '.$this->CLASS['language']->get['userform']['others'].': </td><td>'.$this->CLASS['knowledgeroot']->rightDropDown("otherrights",substr($row['defaultrights'],2,1)).'</td></tr>
      ';

      $this->CLASS['hooks']->setHook("kr_content","edit_user","show");

      echo '  <tr><td></td><td><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['userform']['submit'].'" /></td></tr>

        </table>
        </fieldset>
        </form>
      ';
    }

    $this->CLASS['hooks']->setHook("kr_content","edit_user","end");
  }

  /**
   * add group
   */
  function add_group() {
    $this->CLASS['hooks']->setHook("kr_content","add_group","start");

    echo '
      <h2>'.$this->CLASS['language']->get['userform']['addgroup'].'</h2>
      <fieldset>
        <legend><b>'.$this->CLASS['language']->get['userform']['addgroup'].'</b></legend>
      <form action="index.php" method="post">
        <input type="hidden" name="action" value="addgroup" />
        <table border="0" cellpadding="1" cellspacing="3">
        <tr><td>'.$this->CLASS['language']->get['userform']['groupname'].': </td><td><input type="text" name="name" value="" /></td></tr>
    ';

    $this->CLASS['hooks']->setHook("kr_content","add_group","show");

    echo '    <tr><td></td><td><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['userform']['submit'].'" /></td></tr>
        </table>
      </form>
    ';

    $this->CLASS['hooks']->setHook("kr_content","add_group","end");
  }

  /**
   * edit group
   */
  function edit_group() {
    $this->CLASS['hooks']->setHook("kr_content","edit_group","start");

    $res = $this->CLASS['db']->query(sprintf("SELECT * FROM groups WHERE id=%d",$_GET['gid']));
    $anz = $this->CLASS['db']->num_rows($res);

    if($anz == 1) {
      $row = $this->CLASS['db']->fetch_assoc($res);
      echo '
        <h2>'.$this->CLASS['language']->get['userform']['editgroup'].'</h2>
        <fieldset>
          <legend><b>'.$this->CLASS['language']->get['userform']['editgroup'].'</b></legend>
        <form action="index.php" method="post">
          <input type="hidden" name="action" value="editgroup" />
          <input type="hidden" name="gid" value="'.$row['id'].'" />
          <table border="0" cellpadding="1" cellspacing="3">
          <tr><td>'.$this->CLASS['language']->get['userform']['groupname'].': </td><td><input type="text" name="name" value="'.$row['name'].'" /></td></tr>
      ';

      $this->CLASS['hooks']->setHook("kr_content","edit_group","show");

      echo '    <tr><td></td><td><input class="button" type="submit" name="submit" value="'.$this->CLASS['language']->get['userform']['submit'].'" /></td></tr>
          </table>
        </form>
      ';
    }

    $this->CLASS['hooks']->setHook("kr_content","edit_group","end");
  }

  /**
   * show tree content
   */
  function show_tree_content($count = 0) {
    if($_SESSION['cid'] != "" && $this->CLASS['path']->isTree($_SESSION['cid']) && $this->CLASS['knowledgeroot']->checkRecursivPerm($_SESSION['cid'], $_SESSION['userid']) != 0) {
      $this->CLASS['hooks']->setHook("kr_content","show_tree_content","start");

      // get my rights - possible is 0,1,2
      $mypagerights = $this->CLASS['knowledgeroot']->getPageRights($_SESSION['cid'],$_SESSION['userid']);

      $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_page_menu_start");

      // show page menu
      $this->CLASS['kr_extension']->show_menu("page", $_SESSION['cid'], $mypagerights);

      $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_page_menu_end");

      //check if userid and groupid is set, if not set to 0
      if($_SESSION['userid'] == "" || $_SESSION['groupid'] == "") {
        $_SESSION['userid'] = 0;
        $_SESSION['groupid'] = 0;
      }

      // get page content collapse info
      $res = $this->CLASS['db']->query(sprintf("SELECT contentcollapsed FROM tree WHERE id=%d",$_SESSION['cid']));
      $anz = $this->CLASS['db']->num_rows($res);
      if($anz == 1) {
        $treedata = $this->CLASS['db']->fetch_assoc($res);
      }

      // select the content in table content with userrights
      if (isset ($_SESSION['admin']) and $_SESSION['admin'] == 1) {
        if($this->CLASS['db']->dbtype == "pgsql") {
          $query = sprintf("SELECT ct.id as id, ct.content as content, ct.title as title, ct.type as type, u.name as lastupdatedby, to_char(ct.lastupdated,'DD.MM.YYYY HH24:MI:SS') as lastupdated FROM content ct left outer join users u ON ct.lastupdatedby = u.id WHERE belongs_to=%d AND ct.deleted=0 ORDER BY ct.sorting ASC",$_SESSION['cid']);
        } else {
          $query = "SELECT ct.id AS id, ct.content AS content, ct.title AS title, ct.type AS type,
                      u.name AS lastupdatedby, DATE_FORMAT(ct.lastupdated,'%d.%m.%Y %H:%i:%s') as lastupdated
                    FROM content ct";
          $query .= sprintf(" LEFT OUTER JOIN users u ON ct.lastupdatedby = u.id
                      WHERE belongs_to=%d AND ct.deleted=0
                      ORDER BY ct.sorting ASC",
                      $_SESSION['cid']);
        }
      } else {
        // get groups from user
        $res = $this->CLASS['db']->query(sprintf("SELECT groupid FROM user_group WHERE userid=%d",$_SESSION['userid']));
        $orclause = "";
        while($rowuser = $this->CLASS['db']->fetch_assoc($res)) {
          if($this->CLASS['db']->dbtype == "pgsql") {
            $orclause .= sprintf("OR (ct.\"group\"=%d  AND ct.grouprights > 0) ",$rowuser['groupid']);
          } else {
            $orclause .= sprintf("OR (ct.`group`=%d  AND ct.grouprights > 0) ",$rowuser['groupid']);
          }
        }

        if($this->CLASS['db']->dbtype == "pgsql") {
          $query = sprintf("SELECT ct.id as id, ct.content as content, ct.title as title, ct.type as type, u.name as lastupdatedby, to_char(ct.lastupdated,'DD.MM.YYYY HH24:MI:SS') as lastupdated FROM content ct left outer join users u ON ct.lastupdatedby = u.id WHERE belongs_to=%d AND ct.deleted=0 AND ((ct.otherrights > 0) OR (ct.\"group\"=%d AND ct.grouprights > 0) %sOR (ct.owner=%d AND ct.userrights>0)) ORDER BY ct.sorting ASC",$_SESSION['cid'],$_SESSION['groupid'],$orclause,$_SESSION['userid']);
        } else {
          $query = "SELECT ct.id AS id, ct.content AS content, ct.title AS title, ct.type AS type,
                      u.name AS lastupdatedby, DATE_FORMAT(ct.lastupdated,'%d.%m.%Y %H:%i:%s') AS lastupdated
                    FROM content ct";
          $query .= sprintf(" LEFT OUTER JOIN users u ON ct.lastupdatedby = u.id
                    WHERE belongs_to=%d AND ct.deleted=0 AND
                      ((ct.otherrights > 0) OR (ct.`group`=%d AND ct.grouprights > 0) %s OR (ct.owner=%d AND ct.userrights>0))
                    ORDER BY ct.sorting ASC",
                    $_SESSION['cid'], $_SESSION['groupid'], $orclause,$_SESSION['userid']);
        }
      }

      $res = $this->CLASS['db']->query($query);
      $anz = $this->CLASS['db']->num_rows($res);

      // needed for up and down arrows
      $firstcontent = 1;
      $maxcontent = $anz;
      $contentcounter = 0;

      // check if some table is on the page
      if($anz != 0) {
        while($row = $this->CLASS['db']->fetch_assoc($res)) {
          $contentcounter++;
          if ($row['title'] == null || $row['title'] == "") {
            if($row['type'] == "" || $row['type'] == "text") {
              //$contentType = "HTML/text";
              $contentType = '';
            } else {
              $contentType = $row['type'] . " " . "content";
            }
            $titleText = $contentType;
          } else {
            $titleText = $row['title'];
          }

          // init booleans
          $show_files = 1;
          $showtitle = ($this->CLASS['vars']['knowledgeroot']['showtitle'] == "yes");
          $collapse = ($this->CLASS['vars']['knowledgeroot']['collapsecontent'] == "yes");
          $showlastupdated = ($this->CLASS['vars']['knowledgeroot']['showlastupdated'] == "yes");

          // get content rights
          $mycontentrights = $this->CLASS['knowledgeroot']->getContentRights($row['id'],$_SESSION['userid']);

          echo "<div class=\"ContentItem\" id=\"contentid_".$row['id']."\">\n
  <div class=\"ContentHeader\">\n";

          $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_title_start");

          // display content header based on configuration
          if ($collapse)
                  echo "<a href=\"#\" onclick=\"return ExpandOrCollapseContent(this, 'ContentCollapseWrapper".$row['id']."');\" title=\"".$this->CLASS['language']->get['collapseexpandcontent']."\"><img class=\"ContentCollapse\" src=\"images/".($treedata['contentcollapsed'] == 1 ? "plus" : "minus").".jpg\" style=\"border-width: 0px;\" /></a>&nbsp;\n";
          if ($collapse && $showtitle)
            echo "<a href=\"#\" onclick=\"return ExpandOrCollapseContent(this, 'ContentCollapseWrapper".$row['id']."');\" title=\"".$this->CLASS['language']->get['collapseexpandcontent']."\">";
          if ($showtitle)
            echo "<span class=\"ContentTitle\">".$titleText."</span>";
          if ($collapse && $showtitle)
            echo "</a>\n";
          if ($showlastupdated)
            echo "&nbsp;&nbsp;&nbsp;<span class=\"Date\">(".$this->CLASS['language']->get['lastmodifiedby']." <strong>". ($row['lastupdatedby'] != null ? $row['lastupdatedby'] : $this->CLASS['language']->get['guest']) ."</strong> ".$this->CLASS['language']->get['on']." <span>".$row['lastupdated']."</span>)</span>\n";
          if (!$collapse && !$showtitle && !$showlastupdated)
            echo "&nbsp;";

          $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_title_end");

          echo "</div>
  <div class=\"ContentBodyWrapper\" id=\"ContentCollapseWrapper".$row['id']."\" ".($treedata['contentcollapsed'] == 1 ? "style=\"display:none\"" : "").">
    <span class=\"ContentBody\">\n";

          // check if content is an extension
          if($row['type'] == "" || $row['type'] == "text") {
            // show content
            $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_content_start");

		// adding colored highlighting
		if(isset($_GET['highlight']) && $_GET['highlight'] != "") {
			$highlight = explode(",", $_GET['highlight']);

			foreach($highlight as $hkey => $hvalue) {
				$hvalue = preg_replace('/[^a-zA-Z0-9 \-_]/m', '', $hvalue);
				$row['content'] = preg_replace("/(.*)(".$hvalue.")(.*)/mU","$1<span class=\"highlightword\">$2</span>$3",$row['content']);
			}
		}

            echo "<a name=\"" . $row['id'] . "\"></a>\n";
            echo $row['content'];

            $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_content_end");
          } else {
            // check if extension is loaded
            if(isset($this->CLASS['extension'][$row['type']]) and $this->CLASS['extension'][$row['type']]['init'] == TRUE) {
              $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_extension_start");

              // run extension
              echo $this->CLASS['extension'][$row['type']]['class']->show_content($row['id']);

              $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_extension_end");

              // check if added files should be shown
              if($this->CLASS['extension'][$row['type']]['class']->show_addedfiles != 1) {
                $show_files = 0;
              }
            } else {
              $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_extension_not_loaded");
              continue;
            }
          }

          echo "</span>
  </div>
  <div class=\"ContentPreFooterMenu\">
    <span class=\"Date\">\n";


          if($show_files == 1) {
            $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_content_files_start");

            // select added files
            if($this->CLASS['db']->dbtype == "pgsql") {
              $result = $this->CLASS['db']->query(sprintf("SELECT *, to_char(date,'DD. Mon YYYY HH24:MI:SS') AS dateform FROM files WHERE belongs_to=%d AND deleted=0 ORDER BY id ASC",$row['id']));
            } else {
              $query = "SELECT *, DATE_FORMAT(date,'%d. %M %Y %H:%i:%s') AS dateform
                        FROM files";
              $query .= sprintf(" WHERE belongs_to=%d AND deleted=0
                                  ORDER BY id ASC",
                                  $row['id']);
              $result = $this->CLASS['db']->query($query);
            }

            // read all select files
            while($zeile = $this->CLASS['db']->fetch_assoc($result)) {
              $title = "";
              if($zeile['owner'] == NULL || $zeile['owner'] == 0 || $zeile['owner'] == "") {
                $title = $zeile['dateform'];
              } else {
                $title = $this->CLASS['knowledgeroot']->getOwner($zeile['owner']) . " - " . $zeile['dateform'];
              }

              if($mycontentrights == 2) {
                echo "<a href=\"index.php?delfile=".$zeile['id']."\" onclick=\"return confirm('" . $this->CLASS['language']->get['delete'] . "');\"><img src=\"images/delete.gif\" title=\"".$this->CLASS['language']->get['del']."\" class=\"upload\" /></a>&nbsp;<a href=\"index.php?download=".$zeile['id']."\" title=\"".$title."\"><img src=\"images/file.gif\" class=\"upload\" /> ".$zeile['filename']."</a>&nbsp;<font class=\"text\">[".getfilesize($zeile['filesize'])."]&nbsp;[".$title."]</font><br />\n";
              } else {
                echo "<a href=\"index.php?download=".$zeile['id']."\" title=\"".$title."\"><img src=\"images/file.gif\" class=\"upload\" /> ".$zeile['filename']."</a>&nbsp;<font class=\"text\">[".getfilesize($zeile['filesize'])."]&nbsp;[".$title."]</font><br />\n";
              }
            }

            $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_content_files_end");
          }

          $includeFileLink = false;
          if($show_files == 1) {
            // show form for adding new files
            if($mycontentrights == 2) {
              $includeFileLink = true;
              echo "<div id=\"fileform_".$row['id']."\" style=\"display:none\"><form class=\"AddFileForm\" action=\"index.php\" method=\"post\" enctype=\"multipart/form-data\">\n<b>".$this->CLASS['language']->get['addfile']."</b>\n<input type=\"hidden\" name=\"upload\" value=\"yes\" /><input type=\"hidden\" name=\"contentid\" value=\"".$row['id']."\" /><input type=\"file\" name=\"datei\" />&nbsp;\n<input class=\"button\" type=\"submit\" name=\"submit\" value=\"".$this->CLASS['language']->get['add']."\" /></form></div>";
            }
          }

          echo '<div class="ContentMenu" style="float:left;">';

          $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_content_menu_start");

          // show content menu
          $this->CLASS['kr_extension']->show_menu("content",$row['id'],$mypagerights,$mycontentrights,$row['type']);

          $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_content_menu_end");

          echo "</div>\n";
          echo "<div class=\"ContentMenu\" style=\"float:right;\">\n";

          $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_contentline_menu_start");

          // show contentline menu
          $this->CLASS['kr_extension']->show_menu("contentline");

          $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_contentline_menu_end");

          echo "</div>";

          if($mycontentrights == 2 && $mypagerights == 2) {
              if ($maxcontent != $contentcounter) {
                echo "<div class=\"downarrow\"><a href=\"index.php?movedown=".$row['id']."\" title=\"".$this->CLASS['language']->get['movecontentdown']."\"><img src=\"images/down_arrow.gif\" border=\"0\" alt=\"".$this->CLASS['language']->get['movecontentdown']."\" /></a></div>\n";
              }

              if ($firstcontent != 1) {
                echo "<div class=\"uparrow\"><a href=\"index.php?moveup=".$row['id']."\" title=\"".$this->CLASS['language']->get['movecontentup']."\"><img src=\"images/up_arrow.gif\" border=\"0\" alt=\"".$this->CLASS['language']->get['movecontentup']."\" /></a></div>\n";
              }

              $firstcontent = 0;
          }

          echo "</span><br />
              </div>
              <div class=\"ContentFooter\">
              </div>
            </div>\n";
        }

        $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_page_menu_start");

        // show page menu
        $this->CLASS['kr_extension']->show_menu("page", $_SESSION['cid'], $mypagerights);

        $this->CLASS['hooks']->setHook("kr_content","show_tree_content","show_page_menu_end");

        echo "<br /><br />";
      } else {
        $this->CLASS['hooks']->setHook("kr_content","show_tree_content","no_content_start");

        // show notification if no content is present
        echo "<h3>" . $this->CLASS['language']->get['nocontent'] . "</h3>\n";

        $this->CLASS['hooks']->setHook("kr_content","show_tree_content","no_content_end");
      }

      // form for move page
                  echo "<form name=\"move\" action=\"index.php\" method=\"post\">\n";
                  echo "<input type=\"hidden\" name=\"move\" value=\"move\" />\n";
                  echo "<input type=\"hidden\" name=\"to\" value=\"".$_SESSION['cid']."\" />\n";
      echo "<input type=\"hidden\" name=\"contentid\" value=\"\" />\n"; // use for move pagecontent
                  echo "</form>\n";


    } else {
      $this->CLASS['hooks']->setHook("kr_content","show_tree_content","welcome_msg_start");

      // show welcome message
      echo "<div class=\"welcome\">".$this->CLASS['language']->get['welcome']."</div>\n";

      $this->CLASS['hooks']->setHook("kr_content","show_tree_content","welcome_msg_end");
    }

    $this->CLASS['hooks']->setHook("kr_content","show_tree_content","end");
  }
}
?>
