/***************************************************************************
                          knutinstcomms.h  -  description
                             -------------------
    begin                : ct rj 24 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTINSTCOMMS_H
#define KNUTINSTCOMMS_H

#include "knutnet.h"

#include <kdialogbase.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <klocale.h>

//#include <qstring.h>

class QString;


/**
 * Tato trida je graficke rozhrani pro spusteni okamzitych prikazu.
 *
 * @author Daniel Prynych
 * @short Okamzite prikazy
 * @version 0.3
*/
class KNutInstComms : public KDialogBase  {
public: 


/**
 * Konstruktor - vytvori okno pro vyber okamziteho prikazu.
 *
 * @param uName Urcuje uzivatelske jmeno.
 * @param password Urcuje heslo.
 * @param upsNet Je odkaz na instanci tridy KNutNet.
 *
 * @since  0.3
 **/
  KNutInstComms(QString* userName, QString* userPassword, const QString uName, const QString password, KNutNet* const upsNet, QWidget* parent = 0, const char* name = 0, bool const modal = TRUE);
  
/**
 * Destruktor
 *
 * @since  0.3
 **/
  ~KNutInstComms();


/**
 * Vraci true pokud existuje pripojeni na server a vytvorilo se
 * ovladaci okno pro odeslani prikazu.
 *
 * @since  0.3
 **/
  bool upsOk (void);

    
private slots:
/**
 * @internal
 *
 * Provede akci, da prikaz k provedeni okamziteho prikazu.
 */
  virtual void slotOk();


private:  
  KLineEdit *lineEditName;
  KLineEdit *lineEditPassword;
  KComboBox *instCommBox;

  KNutNet* myUpsNet;
  bool upsConnectOk;

  QString* oldUserName;
  QString* oldUserPassword;

};

#endif
