/***************************************************************************
                          knutmainwindow.h  -  description
                             -------------------
    begin                : Po cen 16 2003
    copyright            : (C) 2003 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTMAINWINDOW_H
#define KNUTMAINWINDOW_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "knutprefdlg.h"
#include "knutupsdata.h"
#include "knutvardata.h"
#include "knutfrontpanel.h"
#include "knutnet.h"
#include "kanalog.h"
#include "knutpanelmeter.h"

#include <kapp.h>
#include <kmainwindow.h>
#include <kaction.h>


#include <qwidget.h>
#include <qdatetime.h>
#include <qstringlist.h>
#include <qprogressbar.h>
#include <qsplitter.h>


/**
  *@author Daniel Prynych
  */

/** Trida slouzi pro zobrazeni okna s informacemi o UPS.
 *
 * @author Daniel Prynych
 * @short Hlavni okno
 * @version 0.2.1
 */
class KNutMainWindow : public KMainWindow {
  Q_OBJECT
  public:

/**
 * Konstruktor - vytvori hlavni okno.
 *
 * @param tListKNutEvent ukazatel na QStringList obsahuje textove udaje o udalostech (ztrata spojeni, prepnuti atd.)
 * @param tActiveUpsInfo ukazatel na data o aktivni UPS
 * @param tSettingData ukazatel na zakladni data programu (barvy pozadi, mezikruzi, rucicky ... ,fonty atd )
 * @param tAnalogRecords ukazatel na tridu ktera pracuje s daty o upsekach
 *
 * @since  0.3
 **/
   KNutMainWindow(QStringList* tListKNutEvent, struct upsInfo* tActiveUpsInfo, SettingDataDef* tSettingData, KNutUpsData* tUpsRecords, KNutVarData* tAnalogRecords, QWidget* parent=0,const char *name=0);

/**
 * Destruktor
 *
 * @since  0.1.1
 **/
    ~KNutMainWindow();

/**
 * Prekresli informace hlavniho panelu.
 *
 * @since  0.1.2
 **/
  void repaintPanel(void);


/**
 * Prekresli analogove panely na zaklade jejich stavu.
 *
 * @since  0.3
 **/
  void repaintAnalogs (void);

/**
 * Da prikaz k prekresleni analogovych panelu, hlavniho panelu a nastavi jejich hodnoty na
 * zaklade XFer hodnot.
 *
 * @since  0.3.1
 **/
  void showUpsData (void);


/**
 * Prida dalsi radku do seznamu udalosti a zobrazi je v dolni casti panelu.
 *
 * @param text udava text udalosti.
 * @param name udava jmeno UPS-ky tak jak je vedena v seznamu UPS-ek tohoto programu
 *
 * @since  0.1
 **/
  void addComboStatusItem (const QString text, const QString name = QString::null);

/**
 * Prestavi hlavni panel na zaklade hodnotu changeSetting.
 * Tuto hodnotu generuje konfiguracni okno.
 *
 * @param changeSetting udava jake nstaveni bylo zmeneno.
 *
 * @since  0.1.1
 **/
  void setConfig (unsigned int changeSetting);

/**
 * Nastavi Combo (pro jmeno UPSky).
 *
 * &param name je jmeno UPSky ktere bude nastavena.
 *
 * @since  0.1
 **/
  void setCombo(QString name);
  
/**
 * Nastavi vsechny panely na nulovo hodnotu
 *
 * @since  0.2
 **/
  void zeroingPanels (void);


  
  signals:
/**
 * Tento signal je vyslan pokud byla vybrana jina UPS-ka.
 *
 * @since  0.1
 **/
  void UPSChanged (QString);

/**
 * Tento signal je vyslan pokud byl z menu zadan pozadavek na zobrazeni okna
 * pro nastaveni programu (preference).
 *
 * @since  0.1
 **/
  void preferenceUps (void);

/**
 * Tento signal je vyslan pokud byl z menu zadan pozadavek na zobrazeni seznamu promennych.
 *
 * @since  0.1
 **/
  void showUPSVars (void);

/**
 * Tento signal je vyslan pokud byl z menu zadan pozadavek na zmenu RW promennych.
 *
 * @since  0.1
 **/
  void makeRWVars();

/**
 * Tento signal je vyslan pokud byl z menu zadan pozadavek na provedeni okamzitych prikazu.
 *
 * @since  0.1
 **/
  void makeInstComms();

/**
 * Tento signal je vyslan pokud byl z menu zadan pozadavek na ukonceni cele aplikace.
 *
 * @since  0.1
 **/
 void endApplication();
  

  private slots:
  void slotDescription();
  void slotShowToolBar();
  void slotShowStatusBar();
  void slotPreferencesUps();
  void slotPrintUPSVars();
  void slotInstComms();
  void slotRWVars();
  void slotChangeRWVars ( QString varName);
  void closeEvent( QCloseEvent *e );
  void slotCloseKnutClient (void);
  void slotChangeUPS (const QString &name);
  void slotConfigureKeys();




  private:
/************** private functions ************************/

  void activeConfiguration (void);
  int activeMainCombo (void);
  void hideUpsData (void);

/************ inicializacni funkce ********************/
  void initVars ( void );
  void initAction ( void );
  void initStatusBar ( void );
  void initToolBar ( void );
  void initStatusBarMessage ( void );


/************** private vars **************************/
// Nazvy promenych UPS cislovany jsou od 0 do 10 "NONE", "UTILITY", "BATTPCT", "UPSTEMP", "ACFREQ", "LOADPCT", "AMBTEMP", "AMBHUMID", "BATTVOLT", "OUTVOLT", "CURRENT"

  struct upsInfo* activeUpsInfo; // hodnoty pro vybrane ups
  SettingDataDef* settingData;  // v teto strukture jsou ulozeny promene ktere nastavuji konfiguraci

  KAction *quit;
  KAction *preferencesUps;
  KToggleAction *descriptionAction;

  KNutPrefDlg* prefDlg;
  KNutUpsData* upsRecords;
  KNutVarData* analogRecords;

  int activeUpsIndex;
  QLabel* area; // hlavni plocha na ni umistime panel a analogove ukazatele

  QSplitter* mainSplit;
  KNutFrontPanel* frontPanel;

  // nactene hodnoty promenych UPS, tyto promene se ctou jen jednou
  QString manufacturer, upsModel, serial, firmrev;
  bool existLowHighXfer;
  float lowXfer, highXfer;
  QPalette mainPalette, areaPalette, mPanelPalette, aPanelPalette;

  // Combo a pomocne struktury pro dolni radku
  KComboBox *infoCombo;

  QStringList *listKNutEvent;

  KNutPanelMeter* panelMeter;
  };
#endif

