/***************************************************************************
                          knutprintupsvar.h  -  description
                             -------------------
    begin                : St cec 3 2002
    copyright            : (C) 2002 by Daniel Prynych
    email                : Daniel.Prynych@alo.cz
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNUTPRINTUPSVAR_H
#define KNUTPRINTUPSVAR_H

//Od verze 3 je kapp jen odkaz na kapplication
//#include <kapplication.h>
#include <kapp.h>
#include "knutupsdata.h"
#include "knutnet.h"

#include <kdialogbase.h>
#include <kcombobox.h>
#include <kpushbutton.h>
#include <klistview.h>


#include <qvariant.h>
#include <qlayout.h>
#include <qvaluelist.h>


#include <qvaluevector.h>

class QLabel;
class QPixmap;
class QFramel;
class QString;

/**
  *@author Daniel Prynych
  */

/**
 * Tato trida zajistuje zobrazeni vsech promenych,
 * ktere podporuje prislusny ovladac/driver/model (ovladac) NUTu
 * pro urcenou UPS-ku
 * @author Daniel Prynych
 * @short NUT show UPS vars
 * @version 0.3.2
*/
class KNutPrintUpsVar : public KDialogBase  {

    Q_OBJECT

public:
/**
 * Constructor - makes window, reads values of variables
 * and will write names and values of variables
 * Konstruktor - vytvori okno, nacte hodnoty promennych,
 * a vypise jmena a hodnoty promenych.
 * @param upsnet Je odkaz na instanci KNutNet - obsahuje hodnoty promennych systemu NUT.
 * @param useDescription Urcuje zda pouzit pro promenne a prikazy taky popis.
 * pokud data o UPS-kach neexistuji vraci funkce upsOk vzdy false.
 *
 * since 0.3.1
 **/
  KNutPrintUpsVar(KNutNet* const upsNet, const bool useDescription, QWidget* parent = 0, const char* name = 0, const bool modal = true);

/**
 * @since  0.1
 **/
  ~KNutPrintUpsVar();


  

/**
 * Vrati zda se povedlo pripojit na server NUT-u a nacist udaje.
 *
 * @since  0.1
 **/
  bool upsOk (void);


protected:

/****** protected vars ************/

  int countVars;
  int countIComms;
  int countRWVars;

  KNutNet* myUpsNet;

  KPushButton* reloadButton;

  struct dataVar {
    QString myName;
    KListViewItem* myValue;
    };
  QValueVector<dataVar> dataList;
  KListViewItem* ROVarsList;
  KListViewItem* RWVarsList;
  KListViewItem* ICommList;

  QFrame *page;
  KListView* table;

  QPixmap dirPixmap;
  

  bool upsConnectOk;

/********** protected functions ****************/
  
/**
 * @internal
 * adds name into part of tree
 * Prida jmeno do casti stromu.
 * @param table is top of tree's part
 * @param varName is text which is addes into tree on the first column
 * @param varName is text which is addes into tree on the second column
 * @param table je vrchol casti stromu.
 * @param varName je text ktere se prida do stromu na prvni sloupec.
 * @param value je text ktere se prida do stromu na druhy sloupec.
 *
 * @since  0.2.1
 **/
    KListViewItem* addListItem (KListViewItem* table, QString varName, QString value);

/**
 * @internal
 * Zjisti existenci jmena ve vetvi stromu
 *
 * listItem je vrcholovy prvek vetve.
 * @param name je jmeno ktere se hleda ve strome.
 *
 * @since  0.2
 **/
    KListViewItem* existListItem (KListViewItem* listItem, QString name);
  
protected slots:

/**
 * @internal
 * Nacte a prepise hodnoty promenych
 *
 * @since  0.3
 **/
  void slotReloadVars (void);

};

#endif
