h55761
s 00001/00000/00155
d D 1.12 00/11/04 20:41:48 nitehawk 13 12
c Include koalatypes header
cC
cHwinghove.1ststep.net
cK01889
cZ-08:00
e
s 00043/00007/00112
d D 1.11 00/09/10 19:32:13 nitehawk 12 11
c d
cC
cK65305
e
s 00020/00002/00099
d D 1.10 00/08/20 21:58:09 nitehawk 11 10
c Add new module information structures
c Update prototypes
cC
cK07232
e
s 00002/00000/00099
d D 1.9 00/08/08 22:03:51 nitehawk 10 9
c Add getmodlisthead function
cC
cK32969
e
s 00010/00001/00089
d D 1.8 00/08/07 20:27:36 nitehawk 9 8
c Add initfunc pointer type
c Change startup functions to require pointer to init function
cC
cK28072
e
s 00006/00000/00084
d D 1.7 00/08/01 20:26:50 nitehawk 8 7
c Add prototypes for module load functions
cC
cK10478
e
s 00031/00001/00053
d D 1.6 00/07/29 23:23:31 nitehawk 7 6
c Add new enums and structs for new module loader
cC
cHlocalhost.1ststep.net
cK56804
cZ-07:00
e
s 00008/00000/00046
d D 1.5 00/03/12 21:45:53 nitehawk 6 5
c Add prototypes for module list state change functions
cC
cK05943
e
s 00019/00000/00027
d D 1.4 00/03/12 09:41:26 nitehawk 5 4
c Add module definition type
cC
cK43486
e
s 00008/00011/00019
d D 1.3 00/03/07 23:05:32 nitehawk 4 3
c Convert modstate to simple enum
cC
cK50373
e
s 00005/00000/00025
d D 1.2 00/03/07 13:05:06 nitehawk 3 2
c Comment modstate_t structure
cC
cK53311
e
s 00025/00000/00000
d D 1.1 00/03/07 12:31:58 nitehawk 2 1
cF1
cK37344
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/03/07 12:31:58 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/include/module.h
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK16443
cPinclude/module.h
cR9f6cd823dc316646
cV3
cX0xa1
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*
D 7
*	Module: MODULE
E 7
I 7
*	Module: KOALAMOD
E 7
\***************************************************************/

#ifndef _KOALAMUD_MODULE_H
#define _KOALAMUD_MODULE_H "%Z% %K% %Z%"

I 7
/* Ensure config.h is included */
D 12
#include "config.h"
I 8
#include "koalatypes.h"
I 10
#include "llist.h"
E 12
I 12
#include "all.h"
I 13
#include "koalatypes.h"
E 13
E 12
E 10
E 8

/* This type defines the various module types that are possible */
typedef enum {
	MODTYPE_NULL = 0,
	MODTYPE_GENERIC,
	MODTYPE_DATABASE,
	MODTYPE_NETWORK,
} modtype_t;

/* Possible errors during module loading */
typedef enum {
	LOADERERR_SUCCESS=0,
	LOADERERR_BADARGS=ERRKOALAMODBASE,
	LOADERERR_NOACCESS,
	LOADERERR_LOADFAIL,
	LOADERERR_BADMOD,
	LOADERERR_NOMEM,
I 8
	LOADERERR_STARTUPFAIL,
	LOADERERR_UNKNOWNMOD,
E 8
} loadererr_t;
E 7
I 3

/* This structure is used by various modules to keep track of their current
 * state.  Two values are defined for each state to serve as protection for
 * multithreaded apps
 */
E 3
D 4
typedef struct TAG_MODSTATE_T
{
	enum {
		MODSTATE_UNDEFINED = 0,
		MODSTATE_STARTUPINPROGRESS,
		MODSTATE_STARTED,
		MODSTATE_LINKUPINPROGRESS,
		MODSTATE_LINKED,
		MODSTATE_SHUTDOWNINPROGRESS,
		MODSTATE_STOPPED,
	} status;
E 4
I 4
typedef enum {
	MODSTATE_UNDEFINED = 0,
	MODSTATE_STARTUPINPROGRESS,
	MODSTATE_STARTED,
	MODSTATE_LINKUPINPROGRESS,
	MODSTATE_LINKED,
	MODSTATE_SHUTDOWNINPROGRESS,
	MODSTATE_STOPPED,
E 4
} modstate_t;

I 5
/* This structure is used to describe modules.  Each module should define one
 * of these structures for use in status tracking and startup/linkup/shutdown
 * handling
 */
/* Note:  it is relatively important that the type of function pointer used
 * for this structure does not change.  *If* for some reason it does need to
 * change, Make sure that all modules are updated to reflect the new type
 */
typedef struct TAG_MODULE_T
{
	char *		name;		// Name of the module - for printing
	char *		version;	// Version - Should be SCCS version
	modstate_t	state;
	int (*startupfn)(void);
	int (*linkupfn)(void);
	int (*shutdownfn)(void);
} module_t;
typedef module_t *pmodule;
I 7

I 11
D 12
/* Function pointer table */
E 12
I 12
/* Function pointer table - All APIs need to be listed */
E 12
typedef struct FUNCTABLE_T
{
D 12
	int (*modstartup)(pmodule, pmodule, int *, int *);
	int (*modlinkup)(pmodule, pmodule, int *, int *);
	int (*modshutdown)(pmodule, pmodule, int *, int *);
E 12
I 12
	/* Log Functions */
	void (*logmsg)(logmsgpri, char *, ...);

	/* Buffer Functions */
	koalaerror (*buffer_queue)(pdescriptor, const char *, int);
	koalaerror (*buffer_sendbytes)(pdescriptor, int);
	bool (*buffer_outbufempty)(pdescriptor);
	koalaerror (*buffer_receive)(pdescriptor);
	koalaerror (*buffer_readbytes)(pdescriptor, char *, int *, bool);
	char (*buffer_readchar)(pdescriptor);
	koalaerror (*buffer_readword)(pdescriptor, char *, int);
	koalaerror (*buffer_readline)(pdescriptor, char *, int);
	koalaerror (*buffer_isalinein)(pdescriptor);
	int (*buffer_linesize)(pdescriptor);
	
	/* Configuration Functions */
	koalaerror (*gendefaultconfig)(const char *);
	koalaerror (*readxmlconfig)(const char *);
	koalaerror (*finddaemonconfig)(void);
	koalaerror (*confgetnodeid)(void);
	koalaerror (*confcreatelisten)(listnodeptr);
	koalaerror (*confopenlogs)(void);
	bool (*confquerybackground)(void);
	koalaerror (*confcreateuplink)(listnodeptr);
	koalaerror (*confgetoptions)(void);
	koalaerror (*confgetoptionsfromsection)(char *, confoption_t *, int);
	
	/* Linked List Functions */
	listnodeptr (*listcreate)(void *);
	int (*listaddnode)(listnodeptr, void *);
	int (*listremovenode)(listnodeptr, void *);
	listnodeptr (*listnextnode)(listnodeptr);
	listnodeptr (*listprevnode)(listnodeptr);
	void (*listdestroy)(listnodeptr list);
	void (*listdestroywithfree)(listnodeptr list);
	
	/* Module Functions */
	int (*modstartup)(pmodule *, pmodule, int *, int *);
	int (*modlinkup)(pmodule *, pmodule, int *, int *);
	int (*modshutdown)(pmodule *, pmodule, int *, int *);

E 12
} functable_t;
extern functable_t functab;

/* Module info Struct */
typedef struct MODULEINFO_T
{
	koalaoptions *pdopts;
	koalastate *pdstate;
	functable_t *pfunc;
} moduleinfo_t; 
extern moduleinfo_t modinf;

E 11
I 9
/* This funtion pointer is used to initialize modules with appropriate
 * pointers.
 */
typedef void (*initfunc)(modtype_t type);

E 9
/* This structure is used to track loaded modules */
typedef struct {
	char *		path;
	char *		modname;
	void *		modhandle;
	modtype_t	type;
	module_t	module;
D 9
	int 		(*startupfunc)(void);
E 9
I 9
D 11
	int 		(*startupfunc)(initfunc init);
E 11
I 11
	int 		(*startupfunc)(moduleinfo_t *pmodinfo);
E 11
E 9
} dynmod_t;
E 7

I 9
D 11

E 11
E 9
I 6
/* Define setinal module - List terminator */
extern module_t nullmodule;

/* API */
I 11
void modinfoinit(void);
E 11
int modstartup(pmodule modlist[], pmodule listend, int *num, int *errors);
int modlinkup(pmodule modlist[], pmodule listend, int *num, int *errors);
int modshutdown(pmodule modlist[], pmodule listend, int *num, int *errors);
I 8
loadererr_t loadmodule(char *modname, char *path, modtype_t modtype,
		pdescriptor desc);
loadererr_t unloadmodule(char *modname, pdescriptor desc);
I 10
listnodeptr getmodlisthead(void);
E 10
I 9

/* Init functions */
void initgeneric(modtype_t type);
E 9
E 8

E 6
E 5
#endif
E 2
I 1
E 1
