h57070
s 00005/00004/00112
d D 1.4 00/11/04 18:51:41 nitehawk 5 4
c free -> kmfree
c Change > to < in insert search
cC
cK48820
e
s 00087/00000/00029
d D 1.3 00/11/04 15:43:18 nitehawk 4 3
c Finish registercommand function
cC
cHwinghove.1ststep.net
cK41532
cZ-08:00
e
s 00009/00000/00020
d D 1.2 00/10/21 06:01:13 nitehawk 3 2
c Add skeleton for registercommand
cC
cK48186
e
s 00020/00000/00000
d D 1.1 00/10/20 04:36:55 nitehawk 2 1
cF1
cK35222
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 00/10/20 04:36:55 nitehawk 1 0
c BitKeeper file /home/nitehawk/src/koalamud/lib/koala/commandtablehandler.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHparanor.1ststep.net
cK30078
cPlib/koala/commandtablehandler.c
cRf890897cb854b010
cV3
cX0x80
cZ+00:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999-00 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMAND
*
*	Handle manipulation of the command table(s)
\***************************************************************/

#define _KOALAMUD_PARSER_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "log.h"
#include "koalatypes.h"
#include "buffer.h"
#include "memory.h"
I 3
#include "kparser.h"

pcommandentry ctablehead = NULL;

I 4
/* When inserting a command into the list, it will be inserted after the
 * 'back' pointer and before the 'front' pointer. */
E 4
koalaerror registercommand(pcommandentry cmd, dynmod_t *ownermod)
{
I 4
	pcommandentry front = ctablehead, back=front, new = NULL;
	int i;
	
	/* Allocate memory for a new command */
	if ((new = kmalloc(sizeof(commandentry), ALLOC_CMDTABLE)) ==NULL)
	{
		/* Bad things going on.  No memory available. */
		logmsg(LOGCRIT, "Unable to allocate memory for new command: %s",
				strerror(errno));
		return KENOMEM;
	}

	/* Copy the new command into the list */
	new->next = NULL;
	if ((new->command = kmalloc(strlen(cmd->command), ALLOC_STRING))
				== NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for new command: %s",
				strerror(errno));
D 5
		free(new);
E 5
I 5
		kmfree(new, ALLOC_CMDTABLE);
E 5
		return KENOMEM;
	}
	strcpy(new->command, cmd->command);
	new->handler = cmd->handler;
	new->numargs = cmd->numargs;
I 5
	new->commandtype = cmd->commandtype;
E 5

	/* The argument list needs to be cloned in its entirety.  */
	if ((new->arglist = kmalloc(sizeof(argument)*new->numargs, ALLOC_CMDTABLE))
				== NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for argument list: %s",
				strerror(errno));
D 5
		free(new->command);
		free(new);
E 5
I 5
		kmfree(new->command, ALLOC_STRING);
		kmfree(new, ALLOC_CMDTABLE);
E 5
		return KENOMEM;
	}
	for (i=0; i < new->numargs; i++)
	{
		new->arglist[i].argtype = cmd->arglist[i].argtype;
		new->arglist[i].argdata.argint = 0;
		new->arglist[i].strlen = 0;
	}
	new->unlock = cmd->unlock;	/* Since the key is stored separately, we don't
								 * need clone the key separately */
	new->owner = ownermod;

	if (front == NULL)
	{
		/* If front is null, it means that we don't have a head pointer yet.
		 * In this case, we simply need to point ctablehead to new and we are
		 * done.
		 */
		ctablehead = new;
		return KESUCCESS;
	}
	else
	{
		/* Otherwise, we need to search through the command list for the
		 * correct place to insert the command */
		while (front && strncasecmp(front->command, new->command,
D 5
				strlen(new->command)) > 0)
E 5
I 5
				strlen(new->command)) < 0)
E 5
		{
			back = front;
			front = front->next;
		}

		if (front == ctablehead)
		{
			/* In this case, the new command comes earlier in the list then
			 * the head.  Move the head out a level
			 */
			new->next = front;
			ctablehead = new;
		}
		else
		{
		/* At this point, back points the the location immediatly before the
		 * insert, and front points the the location immediatly after, or NULL
		 * if we are adding to the end of the list.
		 */
			new->next = front;
			back->next = new;
		}
	}
	
E 4
	return KESUCCESS;
}

E 3
E 2
I 1
E 1
