h11146
s 00001/00001/00151
d D 1.9 00/11/04 21:08:15 nitehawk 10 9
c Fix word builder code for when the word is longer then WORDLENSTEP
cC
cK50671
e
s 00000/00086/00152
d D 1.8 00/11/04 19:07:45 nitehawk 9 8
c Remove defunct commandparsecommand code
cC
cK50513
e
s 00093/00002/00145
d D 1.7 00/11/04 18:51:41 nitehawk 8 7
c Fill in command parser - Still need to parse out arguments to commands
c Normal search mostly complete.  Need to verify string lengths match
c before comparing
c clsearch now calls clsearchnorm when the abbreviation flag on the
c character is false - Note: This flag should be moved into a flags
c variable since it only requires a single bit.
cC
cHwinghove.1ststep.net
cK28198
cZ-08:00
e
s 00022/00000/00125
d D 1.6 00/10/21 06:01:12 nitehawk 7 6
c skeleton for clsearchnorm
c Verification code added to clsearch for list head
cC
cHparanor.1ststep.net
cK60021
cZ+00:00
e
s 00011/00000/00114
d D 1.5 00/10/15 13:33:53 nitehawk 6 5
c Skeletonize clsearch
cC
cK58613
e
s 00011/00000/00103
d D 1.4 00/09/10 21:59:55 nitehawk 5 4
c Prototype added for new command parser
cC
cK25396
e
s 00085/00001/00018
d D 1.3 00/09/10 19:32:13 nitehawk 4 3
c Move clientparsecommand in
cC
cK04841
e
s 00003/00208/00016
d D 1.2 00/09/10 19:06:26 nitehawk 3 2
c Clear out llist.c code used to generate headers
cK27035
e
s 00224/00000/00000
d D 1.1 00/09/10 19:05:31 nitehawk 2 1
cF1
cK38883
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 00/09/10 19:05:31 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/src/koalamud/lib/koala/parser.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHlocalhost.1ststep.net
cK36176
cPlib/koala/parser.c
cR527a9a09eb035ee9
cV3
cX0xa1
cZ-07:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
D 4
*	Copyright (c) 1999 First Step Internet Services, Inc.
E 4
I 4
*	Copyright (c) 1999-00 First Step Internet Services, Inc.
E 4
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
D 3
*	Module: CORE
E 3
I 3
*	Module: PARSER
E 3
*
D 3
*	Doubly, Circly linked list driver
E 3
I 3
*	Command parsers
E 3
\***************************************************************/

D 3
#define _KOALAMUD_LLIST_C "%Z% %K% %Z%"
E 3
I 3
#define _KOALAMUD_PARSER_C "%Z% %K% %Z%"
E 3

#include "autoconf.h"

#include "version.h"
D 3
#include "llist.h"
E 3
#include "log.h"
I 5
#include "koalatypes.h"
#include "buffer.h"
#include "memory.h"
#include "kparser.h"

/* commandparser - parse an incoming command into arguments and call
 * handler */
koalaerror commandparser(pdescriptor desc)
{
I 8
	char *wordbuf = NULL;
	char *wordcur = NULL;
	int wordlen = WORDLENSTEP;
	koalaerror kerr;
	pcommandentry cmd;
	argument *arglist = NULL;

	/* verify that the client has a line of input */
	if (!buffer_isalinein(desc))
	{
		return KESUCCESS;
	}

	/* Allocate memory to read a word from the buffer */
	wordbuf = kmalloc(sizeof(char) * WORDLENSTEP, ALLOC_TEMP);
	if (wordbuf == NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for word buffer");
		return KENOMEM;
	}
	wordcur = wordbuf;

	/* Get a word from the buffer */
	while ((kerr = buffer_readword(desc, wordcur, WORDLENSTEP)) == KENOMEM)
	{
		wordcur = krealloc(wordbuf, wordlen + WORDLENSTEP, ALLOC_TEMP);
		if (wordcur == NULL)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for word buffer");
			return KENOMEM;
		}
		wordbuf = wordcur;
D 10
		wordcur = wordbuf + wordlen;
E 10
I 10
		wordcur = wordbuf + wordlen - 1;
E 10
		wordlen += WORDLENSTEP;
	}
	if (kerr == KENOTENOUGH)
	{
		/* There wasn't any data buffered.  Return success, even though we
		 * didn't do anything */
		kmfree(wordbuf, ALLOC_TEMP);
		return KESUCCESS;
	}

	/* At this point, we have a full word read in from the buffer - Pass it
	 * though the search algorithm for a match */
	if ((cmd = clsearch(wordbuf, desc->data.character->abbreviate)) == NULL)
	{
		/* No match was found */
		buffer_queue(desc, UNKNOWNCOMMANDRESPONSE,
				strlen(UNKNOWNCOMMANDRESPONSE));
		buffer_flushline(desc);
		/* Free memory used by word buffer */
		kmfree(wordbuf, ALLOC_TEMP);

		return KESUCCESS;
	}

	/* Need to parse remainder of input line into requested arguments */

	/* Call out to command handler */
	cmd->handler(desc, &arglist);

	/* Free memory used by word buffer */
	kmfree(wordbuf, ALLOC_TEMP);
	
E 8
	return KESUCCESS;
}
E 5
D 3
#include "memory.h"
E 3

I 6
/* clsearch - Preform a linear search on the command table
 *   This function will do abbreviation matching if requested */
/* Returns a pointer to the command entry or null if it is not found */
I 7
/* Note, this is simply a wrapper around clsearchnorm and clsearchabbrev */
E 7
pcommandentry clsearch(char *word, bool matchabbrev)
{
I 7
	/* Time Saver - If no commands are currently loaded, short cycle and
	 * return NULL
	 */
	if (ctablehead == NULL)
		return NULL;

E 7
	/* There are two search sets here.
	 *   1) Search for exact match.
	 *   2) Search for first part match of a command */
I 8
	if (matchabbrev)
	{

	}
	else
	{
		return clsearchnorm(word);
	}

E 8
I 7
	return NULL;
}
/* clsearchnorm - Preform a linear search on the command table
 *   This function will do abbreviation matching if requested */
/* Returns a pointer to the command entry or null if it is not found */
pcommandentry clsearchnorm(char *word)
{
D 8
	pcommandentry cur, bak;
E 8
I 8
	pcommandentry cur = ctablehead;
E 8
	int cmpres;
I 8

	/* Verify the command table exists */
	if (ctablehead == NULL)
		return NULL;

E 8
	/* initially, we just search the entire loop.  At some point, this
	 * should be optimized to include starting characters so we only
	 * search starting at the first command alphabetically (maintain
D 8
	 * an ordered list), and break out when the strcmp returns < 0
E 8
I 8
	 * an ordered list), and break out when the strcmp returns > 0
	 */

	/* We are searching for an exact match.  Fall out as soon as the compare
	 * returns > 0
E 8
	 */
I 8
	while (cur && (cmpres = strncasecmp(cur->command, word,
					strlen(cur->command))) < 0)
	{
		cur = cur->next;
	}

	if (cmpres == 0)
		return cur;
E 8

E 7
	return NULL;
}
D 9

E 6
I 4
/* clientparsecommand - Read a word from the buffer and parse it into a
 * command.  Send UNKNOWNCOMMANDREPONSE if no match for the input is found
 */
koalaerror clientparsecommand(pdescriptor desc)
{
	char *wordbuf = NULL;
	char *wordcur = NULL;
	int wordlen = WORDLENSTEP;
	koalaerror kerr;
	int charnum;	// Used as an index into the command table
	int x;

	/* verify that the client has a line of input */
	if (!buffer_isalinein(desc))
	{
		return KESUCCESS;
	}

	/* Allocate memory to read a word from the buffer */
	wordbuf = kmalloc(sizeof(char) * WORDLENSTEP, ALLOC_TEMP);
	if (wordbuf == NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for word buffer");
		return KENOMEM;
	}
	wordcur = wordbuf;

	/* Get a word from the buffer */
	while ((kerr = buffer_readword(desc, wordcur, WORDLENSTEP)) == KENOMEM)
	{
		wordcur = krealloc(wordbuf, wordlen + WORDLENSTEP, ALLOC_TEMP);
		if (wordcur == NULL)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for word buffer");
			return KENOMEM;
		}
		wordbuf = wordcur;
		wordcur = wordbuf + wordlen;
		wordlen += WORDLENSTEP;
	}
	if (kerr == KENOTENOUGH)
	{
		/* There wasn't any data buffered.  Return success, even though we
		 * didn't do anything */
		kmfree(wordbuf, ALLOC_TEMP);
		return KESUCCESS;
	}

	/* At this point we know we have a word from the buffer, now we need to
	 * find the command that the user specified */
	charnum = toupper(wordbuf[0]) - 'A';
	/* If it isn't in bounds, set charnum to 26, table 26 contains commands
	 * starting with special symbols */
	if (charnum < 0 || charnum > 25)
	{
		charnum = 26;
	}

	for(x = 0; commandtable[charnum][x].command; x++)
	{
		if (strcasecmp(wordbuf, commandtable[charnum][x].command) == 0)
		{
			/* we have a match.  If the handler is not null, call it */
			if (commandtable[charnum][x].handler)
			{
				commandtable[charnum][x].handler(desc);
			}
			break;
		}
	}

	if (commandtable[charnum][x].command == NULL)
	{
		/* No match was found */
		buffer_queue(desc, UNKNOWNCOMMANDRESPONSE,
				strlen(UNKNOWNCOMMANDRESPONSE));
		buffer_flushline(desc);
	}

	/* Free memory used by word buffer */
	kmfree(wordbuf, ALLOC_TEMP);

	return KESUCCESS;
}
E 4
D 3
/* listcreate
 * 	Create the head pointer for the linked list and point the data
 * 	appropriatly.
 *
 * 	Return:
 * 		Pointer to the linked list or NULL on failure.
 */
listnodeptr listcreate(void *data)
{
	listnodeptr list;
E 3

E 9
D 3
	/* Allocate memory for the list pointer */
	if ((list = kmalloc(sizeof(listnode), ALLOC_LLIST)) == NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for linked list.");
		return NULL;
	}
	
	/* Set the pointers to point where things are. */
	list->data.generic = data;
	list->next = list;
	list->prev = list;
	list->head = list;
	
	/* Return a pointer to the new list. */
	return list;
}

/* listaddnode
 * 	Add a node to the linked list without sorting.
 *
 * 	Return 0 on success and non-zero on failure.
 */
int listaddnode(listnodeptr list, void *data)
{
	listnodeptr newnode;

	/* Validate the list pointer */
	if ( ! list)
	{
		logmsg(LOGERR, "llist_addn caught invalid pointer");
		return 1;
	}

	/* If the list is 'empty', simply use the head node for the new data */
	if (list->data.generic == NULL)
	{
			list->data.generic = data;
			return 0;
	}

	/* Allocate memory for the node */
	if ((newnode = kmalloc(sizeof(listnode), ALLOC_LLIST)) == NULL)
	{
		logmsg(LOGCRIT, "Unable to allocate memory for new llist node.");
		return 1;
	}

	/* Point things in the right direction */
	newnode->head = list;
	newnode->prev = list;
	newnode->next = list->next;
	list->next->prev = newnode;
	list->next = newnode;
	
	/* Hook the data in */
	newnode->data.generic = data;
	
	return 0;
}

/* llist_remove
 * 	Remove an entry out of the linked list.  Destroy the llist struct.
 *
 * 	Return 0 on success and non-zero on failure
 *
 * 	Problems:
 * 		Nothing to remove the only node of a list.  What needs to be
 * 		done in this case.
 */
int listremovenode(listnodeptr list, void *data)
{
	listnodeptr tmp= list;
	
	/* Validate the list and data */
	if ((!list) || (!data))
	{
		logmsg(LOGERR, "llist_remove caught caught bad list or"
				" data pointer");
		return 1;
	}

	/* Is the current node the one with the data? */
	if (list->data.generic == data)
	{
		/* Move the data from the next node and delete the
		 * next node.
		 */
		if ((tmp = list->next))
		{
			// If tmp == list, set the data to null because out list is empty
			if (tmp == list)
			{
				list->data.generic = NULL;
				return 0;
			}
			else
			{
				// Move the data.
				list->data.generic = tmp->data.generic;
			}
			
			// Remove 'tmp' (list->next)
			list->next = tmp->next;
			tmp->next->prev = list;
			kmfree(tmp, ALLOC_LLIST);

			/* Node has been removed */
			return 0;
		}
		else
		{
			/* Last Node in list.  How to remove without causing a
			 * destroy?
			 */

			list->data.generic = NULL;

			return 0;
		}
	}

	/* Start off one position offset */
	tmp = list->next;

	/* Loop through the list to find the data */
	while (tmp != list)
	{
		/* We found the node. */
		if (data == tmp->data.generic)
		{
			/* Remove the node from the linkage */
			tmp->prev->next = tmp->next;
			tmp->next->prev = tmp->prev;

			/* Free the memory for the node */
			kmfree(tmp, ALLOC_LLIST);

			/* return that we found the node */
			return 0;
		}
		tmp = tmp->next;
	}

	/* We didn't find the node */
	return 1;
}

/* listnextnode
 * 	Return the next node in the linked list.
 * 	Returns NULL if there is no next node.
 */
KPRODINLINE listnodeptr listnextnode(listnodeptr list)
{
	if (list->next == list->head)
		return NULL;
	return ((list) ? (list->next) : (NULL));	
}

/* listprevnode
 * 	Return the previous node in the linked list.
 */
KPRODINLINE listnodeptr listprevnode(listnodeptr list)
{
	return ((list) ? (list->prev) : (NULL));	
}

/* listdestroy
 * 	Cleanup memory allocated by the linked list functions.
 *
 * 	ASSUMES:
 * 		All data items are either already cleaned up or otherwise
 * 		tracked.  No cleanup is done for the data.
 */
void listdestroy(listnodeptr list)
{
	listnodeptr tmp = list;
	listnodeptr nxt = tmp->next;
	
	/* Validate the list */
	if (! list)
	{
		logmsg(LOGERR, "listdestroy caught invalid list pointer");
		return;
	}

	/* Loop through the list and free all the center nodes */
	while (nxt != list)
	{
		nxt = tmp->next;
		kmfree(tmp, ALLOC_LLIST);
		tmp = nxt;
	}
}
E 3
E 2
I 1
E 1
