/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Thu Oct 24 19:35:22 IST 2002
    copyright            : (C) 2002 by Matti
    email                : hei00rhe@syd.kth.se
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "koctave3.h"

#include "logo.h"		//nice start logo ;)


static const char *description = I18N_NOOP("kOctave3");
	
static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
};

int main(int argc, char *argv[])
{

	KAboutData aboutData( "kOctave", 
			    I18N_NOOP("kOctave"),
			    VERSION, 
			    description, 
			    KAboutData::License_GPL,
			    "IDE for Octave\nFeaturing Editor, helpsystem etc\n(c) 2002/2003, Matias Henttunen", 
			    "Mirror site: http://bubben.homelinux.net/~matti/koctave",
			    "http://gaillimh.mine.nu/kde/koctave");

	aboutData.addAuthor("Matias Henttunen",0,"hei00rhe@syd.kth.se");
	aboutData.addAuthor("The Octave developers",0, "");
	aboutData.addAuthor("The KDE Kate developers",0, "");
        aboutData.addAuthor("The KDE Konsole developers",0, "");
	aboutData.addCredit("Rex A. Dieter","RH7 Packages",0,"http://www.math.unl.edu/linux/redhat/apt/7.3/RPMS.kde3-extras/");  
	aboutData.addCredit("Giuseppe Borzi'","Mandrake Packages",0,"");  


	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;

 
  if (app.isRestored())
  {
    RESTORE(Koctave3App);
  }
  else 
  {
    //show the nice logo..
    logo l;
    l.show();
    Koctave3App *koctave3 = new Koctave3App();
    QObject::connect(koctave3, SIGNAL( hidelogo() ), &l, SLOT( hide() ) );


    koctave3->show();
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		
		if (args->count())
		{
    		    qDebug("opening file");
		    koctave3->slotOpen(args->arg(0));
		}
		else
		{
		  koctave3->openDocumentFile();
		}
		args->clear();
  }

  return app.exec();
}  
