/* This file is part of the KDE libraries
    Copyright (C) 2001 David Faure <faure@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KoPartSelectAction.h"
#include "KoPartSelectDia.h"

#include <kdebug.h>
#include <kactioncollection.h>
#include <kicon.h>
#ifdef __GNUC__
#warning "KDE4: TODO change argument as kactionmenu (when all will compile)"
#endif

KoPartSelectAction::KoPartSelectAction( const QString& text, KActionCollection* parent, const char* name )
    : KActionMenu( text, parent)
{
    init(parent, name);
}

KoPartSelectAction::KoPartSelectAction( const QString& text, const QString& icon,
                                        KActionCollection* parent, const char* name )
    : KActionMenu( KIcon(icon),text, parent)
{
    init(parent, name);
}

KoPartSelectAction::KoPartSelectAction( const QString& text, const QString& icon,
                                        QObject* receiver, const char* slot,
                                        KActionCollection* parent, const char* name )
    : KActionMenu( KIcon(icon),text, parent)
{
    if (receiver)
        connect( this, SIGNAL( activated() ), receiver, slot );
    init(parent, name);
}

void KoPartSelectAction::init(KActionCollection *ac, const char *name)
{
    Q_ASSERT(ac);
    // Query for documents
    m_lstEntries = KoDocumentEntry::query(KoDocumentEntry::OnlyEmbeddableDocuments);
    QList<KoDocumentEntry>::const_iterator it = m_lstEntries.begin();
    for( ; it != m_lstEntries.end(); ++it ) {
        KService::Ptr serv = (*it).service();
        if (!serv->genericName().isEmpty()) {
            KAction *action = new KAction(KIcon(serv->icon()), serv->genericName().replace('&',"&&"), ac);
            ac->addAction(serv->name().toLatin1(), action);
            connect(action, SIGNAL(triggered()), this, SLOT(slotActionActivated()));
            addAction( action );
        }
    }
    ac->addAction(name, this);
}

// Called when selecting a part
void KoPartSelectAction::slotActionActivated()
{
    QString servName = sender()->objectName();
    KService::Ptr serv = KService::serviceByName( servName );
    m_documentEntry = KoDocumentEntry( serv );
    trigger();
}

// Called when activating the toolbar button
void KoPartSelectAction::slotActivated()
{
    m_documentEntry = KoPartSelectDia::selectPart( 0L );
    trigger();
}

#include "KoPartSelectAction.moc"
