<?php

/*  
 *  COPYRIGHT
 *  ---------
 *
 *  See docs/AUTHORS file
 *
 *
 *  LICENSE
 *  -------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Revision: 1.14 $
 *
 *  ABOUT
 *  -----
 *
 *  This file provides configuration settings for both the
 *  kolabfilter.php and the kolabmailboxfilter.php scripts.
 *
 */

$conf = array();

/* Cyrus server connection string */
$conf['filter']['imap_server'] = 'localhost';

/* LMTP settings (Cyrus IMAPd usually offers LMTP on port 2003) */
$conf['filter']['lmtp_host'] = 'localhost';
$conf['filter']['lmtp_port'] = 2003;

/* SMTP settings (Kolab Postfix usually offers reinjection port on
 * 10025)
 */
$conf['filter']['smtp_host'] = 'localhost';
$conf['filter']['smtp_port'] = 10025;

/* Local IP address of the mailserver for bypassing content filters */
$conf['filter']['local_addr'] = 'localhost';

/* What is our default mail domain? This is used if any users do not
 * have '@domain' specified after their username as part of their
 * email address.
 */
$conf['filter']['email_domain'] = 'example.com';

/* List of kolab hosts that are privileged */
$conf['filter']['kolabhosts'] = 'one.example.com,two.example.com,three.example.com';

/* List privileged networks */
$conf['filter']['privileged_networks'] = '';

/* Are we using virtual domains with Cyrus? */
$conf['filter']['virtual_domains'] = true;

/* Should we append domains to mailbox URIs? This only applies when
 * virtual_domains is true, and when using manager accounts.
 */
$conf['filter']['append_domains'] = false;

/* Should we make sure that the sender and From header match for mail
 * that origins on this server?
 */
$conf['filter']['verify_from_header'] = true;

/* Should we perform this check on mail from our
 * subdomains too?
 */
$conf['filter']['verify_subdomains'] = true;

/* Should the Sender: header be used over From: if present? */
$conf['filter']['allow_sender_header'] = true;

/* Should reject messages with From headers that dont match
 * the envelope? Default is to rewrite the header
 */
$conf['filter']['reject_forged_from_header'] = false;

/* Text to be inserted in From: when rewriting untrusted mails */
// $conf['filter']['untrusted_subject_insert'] = "(UNTRUSTED, sender is <%s>)";
// $conf['filter']['unauthenticated_subject_insert'] = "(UNTRUSTED, sender <%s> is not authenticated)";

/* Should we allow forwarded ical messages from Outlook
 * by encapsulating them in a MIME multipart
 */
$conf['filter']['allow_outlook_ical_forward']  = true;

/* What is the address of the LDAP server address where user objects
 * reside
 */
$conf['filter']['ldap_uri'] = 'ldaps://ldap.example.com';

/* What is the Base DN of our LDAP database? */
$conf['filter']['base_dn'] = 'dc=example,dc=com';

/* What DN should we use to bind to the LDAP server? */
$conf['filter']['bind_dn'] = 'cn=nobody,cn=internal,dc=example,dc=com';

/* What password should we use with the above DN when binding? */
$conf['filter']['bind_pw'] = 'xyz';

/* What account should we use to read/write calendar data? This
 * account should have access to the calendar mailbox of all
 * resource/group mailboxes.
 */
$conf['filter']['calendar_id'] = 'calendar';
$conf['filter']['calendar_pass'] = 'zyx';

/* What is the name of the users' calendar mailbox?  This is only used
 * when the user does not already have a primary calendar folder
 * (search via Kolab annotation)
 */
$conf['filter']['calendar_store'] = 'Calendar';

/* Where can we get free/busy information from? */
$conf['filter']['freebusy_url'] = 'https://example.com/freebusy/${USER}.xfb';
 
/* PFB url to trigger creation of pfb */
$conf['filter']['pfb_trigger_url'] = 'https://example.com/freebusy/trigger/${USER}/${FOLDER}.pfb';

/* Temporary data storage for the scripts */
$conf['filter']['tempdir'] = '';

/* PHP error logging */
$conf['filter']['error_log'] = '/kolab/var/kolab-filter/log/fatal.log';

/* Horde::Log configuration
 *
 * PEAR_LOG_INFO is the suggested setting for tracking what happens to
 * your mails in the filters.
 */
$conf['log']['enabled']          = true;
$conf['log']['priority']         = PEAR_LOG_DEBUG; // Leave this on DEBUG for now. We just restructured the package...
$conf['log']['type']             = 'file';
$conf['log']['name']             = '/kolab/var/kolab-filter/log/filter.log';
$conf['log']['ident']            = 'Kolab Filter';
$conf['log']['params']['append'] = true;

//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// If you modify this file, please do not forget to modify both the
// template in kolabd and the source file in kolab-freebusy
//
// In order to check if both are in sync:
//
// cd server
// diff -Nau kolab-filter/filter/config.php kolabd/kolabd/templates/resmgr.conf.template.in
//
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
?>
