/***************************************************************************
                          smbconfig.cpp  -  description
                             -------------------
    begin                : Mon Oct 18 1999
    copyright            : (C) 1999 by 
    email                : 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qstringlist.h>
#include <kapp.h>
#include <klocale.h>
#include <kprocio.h>

#include "smbconfig.h"

smbConfig::smbConfig (QObject * parent, const char *name):
QObject (parent, name),
MyWorkgroup (""),
smbconfpath (""), lmhostspath (""), smbmounttext (""), smbumounttext ("")
{

  setMyWorkgroup ();
  nmblookuppath = findProgram ("nmblookup");
  smbclientpath = findProgram ("smbclient");
  testparmpath = findProgram ("testparm");
  smbmountpath = findProgram ("smbmount");
}

smbConfig::~smbConfig ()
{
}


bool smbConfig::setMyWorkgroup ()
{
  KShellProcess
    p;
  out = "";
  p << "testparm" << "-s" << "|" << "grep" << "workgroup" << "|" << "sed" <<
    "'s/\\workgroup//; s/\\=//'";
  connect (&p, SIGNAL (receivedStdout (KProcess *, char *, int)), this,
	   SLOT (smbConfigStdout (KProcess *, char *, int)));
  p.start (KShellProcess::Block, KShellProcess::AllOutput);
  MyWorkgroup = out;
  MyWorkgroup = MyWorkgroup.stripWhiteSpace ();
  MyWorkgroup.replace (QRegExp ("\""), "");

  return (MyWorkgroup.contains ("") != 0);
}

void
smbConfig::smbConfigStdout (KProcess *, char *buf, int len)
{
  out.append (QString::fromLocal8Bit (buf, len));
}

/**  */
bool smbConfig::checkSmbmount ()
{
  char
    smbmntpath[1024];
  strncpy (smbmntpath, findProgram ("smbmnt"), sizeof (smbmntpath));
  if (strlen (smbmntpath) == 0)
    {
      smbmounttext = "I can't find it in $PATH.";
      return false;
    }
  else
    {
      //only if komba is not root
      if (getuid () != 0)
	{
	  struct stat
	    buf;
	  stat (smbmntpath, &buf);
	  if ((buf.st_mode & S_ISUID) == 0)
	    {
	      smbmounttext = "You must set the suid bit.";
	      return false;
	    }
	}
    }
  return true;
}

bool smbConfig::checkSmbUmount ()
{
  char
    smbumountpath[1024];
  strncpy (smbumountpath, findProgram ("smbumount"), sizeof (smbumountpath));
  if (strlen (smbumountpath) == 0)
    {
      smbumounttext = "I can't find it in $PATH.";
      return false;
    }
  else
    {
      //only if komba is not root
      if (getuid () != 0)
	{
	  struct stat
	    buf;
	  stat (smbumountpath, &buf);
	  if ((buf.st_mode & S_ISUID) == 0)
	    {
	      smbumounttext = "You must set the suid bit.";
	      return false;
	    }
	}
    }
  return true;
}

/* This funktion is copied from Kdevelop */
QString smbConfig::findProgram (QString name)
{
  QString
    file;
  QStringList
    complete_path;
  complete_path =
    QStringList::split (QString (":"), QString (getenv ("PATH")), false);

  for (QStringList::Iterator it = complete_path.begin ();
       it != complete_path.end (); ++it)
    {
      file = QString ((*it).latin1 ()) + "/" + name;
      if (QFile::exists (file))
	{
	  return file;
	}
    }
  return "";
}
