/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel   *
 *   the_docter@gmx.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "menulistviewitem.h"
#include <kiconloader.h>
#include <qdom.h>
#include <iostream>

MenuListViewItem::MenuListViewItem(QListViewItem* parent, QString col1, ItemType type, QString iconPath, QString col2)
	: QListViewItem(parent,col1,col2),mType(type)
{
	if(iconPath!=NULL){
		setIcon(iconPath);
	}
}

MenuListViewItem::MenuListViewItem(QListView* parent, QString col1, ItemType type, QString iconPath, QString col2)
	: QListViewItem(parent,col1,col2),mType(type),mIconPath(iconPath)
{
	if(iconPath!=NULL){
		setIcon(iconPath);
	}
}


MenuListViewItem::~MenuListViewItem()
{
}

void MenuListViewItem::setIcon(const QString& path)
{
	mIconPath = path;
	setPixmap(0,SmallIcon(mIconPath));
}

void MenuListViewItem::toXML(QDomDocument& doc, QDomElement& parent)
{
	QDomElement root = doc.createElement("");
	
	if(mType==Menu){
		root.setTagName("menu");
		MenuListViewItem* temp = static_cast<MenuListViewItem*>(firstChild());
		while(temp){
			temp->toXML(doc,root);
			temp=static_cast<MenuListViewItem*>(temp->nextSibling());
		}
	} else if(mType==Button){
		root.setTagName("button");
			if(text(1)!=""){
				QDomElement command=doc.createElement("command");
				command.appendChild(doc.createTextNode(text(1)));
				root.appendChild(command);
			}
	}
	if(mIconPath!=""){
		QDomElement icon=doc.createElement("icon");
		icon.appendChild(doc.createTextNode(mIconPath));
		root.appendChild(icon);
	}
	parent.appendChild(root);
}

void MenuListViewItem::fromXML(const QDomElement & ownNode)
{
	QDomNode temp = ownNode.firstChild();
	
	while(!temp.isNull()){
		if(temp.isElement()){
			QDomElement temp2=temp.toElement();
			if(temp2.tagName()=="icon"){
				setIcon(temp2.firstChild().nodeValue());
			} else if((temp2.tagName()=="command")&&(mType==Button)){
				setText(1,temp2.firstChild().nodeValue());
			} else if((temp2.tagName()=="menu")&&(mType==Menu)){
				MenuListViewItem* child=new MenuListViewItem(this,"Menu",MenuListViewItem::Menu);
				child->setOpen(true);
				child->fromXML(temp2);
			} else if((temp2.tagName()=="button")&&(mType==Menu)){
				MenuListViewItem* child=new MenuListViewItem(this,"Button",MenuListViewItem::Button);
				child->fromXML(temp2);
			}
		}
		temp=temp.nextSibling();
	}
}
