/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   daniel@Docter                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#include "roundbutton.h"

#include <kiconloader.h>
#include <kpixmapeffect.h>
#include <qbitmap.h>

#include "kommando.h"

RoundButton::RoundButton( QWidget* parent, int rad, const char* name, WFlags f)
	: QButton(parent, name, f)
{
	setRadius(rad);
	setBackgroundMode(NoBackground);
	setBackgroundColor(QColor(0,0,0));

	background.resize(width(),height());
}

RoundButton::~RoundButton()
{
}

void RoundButton::drawButton( QPainter *Painter )
{
	bitBlt( this, 0, 0, &background );
	
	drawButtonLabel(Painter);
}

void RoundButton::drawButtonLabel( QPainter *Painter )
{
	/*
	 * TODO: if the button is a submenu, it should be distinguishable
	 * from the other ones, maybe add overlays
	 */
	
	//Do we have a pixmap?
	if(!pixmap()){
		Painter->drawText(radius,radius,"n/a",5);
	} else {	
		Painter->drawPixmap(rect(),*pixmap());
	}
}

bool RoundButton::hitButton ( const QPoint & pos ) const
{
	/*if ( (pos.x()-radius)*(pos.x()-radius) + (pos.y()-radius)*(pos.y()-radius)  <= radius*radius){
		return true;
	}
	return false;*/
	//the button is masked anyway, so a simple rect().contains() should do the job
	return rect().contains(pos);
}

void RoundButton::move( int x, int y )
{
	QButton::move(x-radius,y-radius);
}

void RoundButton::setRadius( int rad )
{
	radius=rad;
	resize(radius*2,radius*2);
	setFixedSize(radius*2,radius*2);
}

/*const QRegion RoundButton::mask(bool tight) const
{
	if((pixmap()!=NULL)&&tight&&pixmap()->hasAlpha()){
		QRegion temp(*pixmap()->mask());//QRegion temp(pixmap()->createHeuristicMask());
		temp.translate(x(),y());
		return temp;
	} else {
		return QRegion(x(),y(),radius*2,radius*2,QRegion::Ellipse);
	}
}*/

void RoundButton::setIcon( QString path )
{
	icon=MainBarIcon(path,KIcon::SizeHuge);
	setMask(icon.createHeuristicMask());
	setPixmap(icon);
}

void RoundButton::show()
{
	//get the buttons part of the screenshot
	copyBlt(&background,0,0,static_cast<Kommando*>(parent())->screenshot(),pos().x(),pos().y(),width(),height());
	
	QButton::show();
}

bool RoundButton::event( QEvent * evt )
{
	switch(evt->type()){
		case QEvent::Enter:
			emit mouseIn(this);
			setActive(true);
			return true;
		case QEvent::Leave:
			emit mouseOut(this);
			setActive(false);
			return true;
		case QEvent::Paint:
			drawButton(&QPainter(this));
			return true;
		default:
			return QButton::event(evt);
	}
}

void RoundButton::setActive( bool mode )
{
	if(mode){
		setPixmap(effect.apply(icon,KIcon::Desktop,KIcon::ActiveState));
	} else {
		setPixmap(effect.apply(icon,KIcon::Desktop,KIcon::DefaultState));
	}
}

void RoundButton::keyPressEvent( QKeyEvent * evt )
{
	evt->ignore();
}

#include "roundbutton.moc"
