/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   daniel@Docter                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ROUNDBUTTON_H
#define ROUNDBUTTON_H

#include <qbutton.h>
#include <qpainter.h>
#include <kiconeffect.h>
#include <kpixmap.h>

class RoundButton : public QButton
{
	Q_OBJECT
	public:
    RoundButton( QWidget* parent=0, int rad= 32, const char* name= 0, WFlags f = 0);

    ~RoundButton();

		//virtual const QRegion mask(bool tight=true) const;
		virtual void setRadius(int rad);
		virtual void setIcon(QString path);
		virtual void setActive(bool mode);
		
	public slots:
		virtual void move(int x, int y);
		virtual void show();

	signals:
		void mouseIn(RoundButton* emitter);
		void mouseOut(RoundButton* emitter);
		
		
	protected:
		int radius;
		QPixmap icon;
		KPixmap background;
		KIconEffect effect;

		virtual void keyPressEvent(QKeyEvent* evt);
		
		virtual void drawButtonLabel(QPainter*);
		virtual void drawButton(QPainter*);
		virtual bool hitButton ( const QPoint & pos ) const;
		virtual bool event(QEvent* evt);
};

#endif
