/***************************************************************************
 *   Copyright (C) 2005-2006 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KOMPARATORWIDGET_H_
#define _KOMPARATORWIDGET_H_

#include <kio/jobclasses.h>

#include "komparatorpreset.h"
#include "komparatorwidgetbase.h"

class KompareJob;
class KFileItem;
class KFileItemExt;
class KListViewItemDups;
class QColor;
class QTimer;

enum STATUS
{
	CLEAN = 0,
	SEARCHING_URL_1,
	SEARCHING_URL_2,
	COMPARING,
	READY,
	INTERACTING
};

enum URL_MODE
{
	URL_URL = 0,
	URL_DIR_OR_URL,
	URL_DIR_OR_URL_ONLY,
	URL_FILE_NAME,
	URL_REPLACE_1,
	URL_REPLACE_2
};

enum LIST_VIEW
{
	DUPLICATES = 0,
	MISSING,
	NEWER
};

enum FILE_REMOVE
{
	IDLE = 0,
	TRASH,
	DELETE,
	TRASH_COREF,
	DELETE_COREF
};

class KQuery;
class KPopupMenu;

class KomparatorWidget : public KomparatorWidgetBase
{
	Q_OBJECT

	public:
		KomparatorWidget( const KURL &url1, const KURL &url2, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
		~KomparatorWidget();

		void keyPressEvent( QKeyEvent *event );

		void customEvent( QCustomEvent *event );

		KListView *currentListView; // public for key event handler.

		KompareJob *kompare;        // public for byte comparison (KFileItemExt::getFile(...))

		bool isEnabled( LIST_VIEW list_view ); // public for komparatorpreset

		QImage transparentImage(); // public for komparedialog
		QIconSet broadIconSet( const QPixmap pm1, const QPixmap pm2, const QPixmap pm3 );

	public slots:
    // USER INTERFACE SLOTS
		virtual void slotSearch();
		virtual void slotAbout();
		virtual void slotWhatsThis();
		virtual void slotKListViewDropped( KListView *list_view, QDropEvent *, QListViewItem * );
		virtual void slotContextMenu( KListView *list_view, QListViewItem *item, const QPoint &p );
		virtual void slotCompareEqual();
		virtual void slotCompareSelected();
		virtual void slotRemoveFromList();
		virtual void slotOpenBinding();
		virtual void slotExecute( QListViewItem *item );
		virtual void slotOpenFolder();
		virtual void slotCopySelection();
		virtual void slotTrashFiles();
		virtual void slotDeleteFiles();
		virtual void slotTrashCoreferenceFiles();
		virtual void slotDeleteCoreferenceFiles();
		virtual void slotRemoveNext( KIO::Job *finished_job );
		virtual void slotOpenWith();
		virtual void slotFileProperties();
		virtual void slotFilePropertiesRenamed( const KURL &old_url, KURL &new_url );
		virtual void slotFilePropertiesChanged();
		virtual void slotFilePropertiesNextStat( KIO::Job *finished_job );
		virtual void slotCopyNewerR2L();
		virtual void slotCopyNewerL2R();
		virtual void slotCopyMissingR2L();
		virtual void slotCopyMissingL2R();
		virtual void slotCopyToOtherSide();
		virtual void slotCopyNext( KIO::Job *finished_job );
		virtual void slotCopyNextStat( KIO::Job *finished_job );
		virtual void slotMoveMissingL2R();
		virtual void slotMoveMissingR2L();
		virtual void slotMoveNewerL2R();
		virtual void slotMoveNewerR2L();
		virtual void slotMoveToOtherSide();
		virtual void slotMoveNext( KIO::Job *finished_job );
		virtual void slotMoveNextStat( KIO::Job *finished_job );
		virtual void slotTrashDuplicates();
		virtual void slotDeleteDuplicates();
		virtual void slotRemoveSelectionMissing1();
		virtual void slotRemoveSelectionMissing2();
		virtual void slotRemoveSelectionNewer1();
		virtual void slotRemoveSelectionNewer2();
		virtual void slotReferenceLeft( bool is_ref );
		virtual void slotDuplicateSelected();
		virtual void slotPresetSelected( int sel );
		virtual void slotAddPreset();
		virtual void slotRemovePreset();
		virtual void slotUpdatePreset();

		// KQUERY SLOTS
		virtual void slotResult( int error_code, QString error_string );
		virtual void slotAddFile( const KFileItem* item, const QString & );

		// KOMPAREJOB SLOTS
		virtual void slotFileDownloaded( KIO::Job *job );

		// KOMPARATOR FILE FILTER SLOTS
		virtual void slotFilterChanged( KomparatorFileFilter *filter, const QString &name, const QString &path,
			const QString &owner, const QString &group, const unsigned long &min_size, const unsigned long &max_size,
			const bool &consider_date, const QDate &date, const bool &newer_real, const bool &newer_equal, const bool &newer_same_time );
		virtual void slotFilterChanged( KomparatorFileFilter *, const QString &/*name*/,
			const QString &/*path*/, const QString &/*owner*/, const QString &/*group*/, const unsigned long &/*min_size*/,
			const unsigned long &/*max_size*/, const bool &/*consider date*/, const QDate &/*date*/,
			const bool &/*duplicates_normal*/, const bool &/*duplicates_multiple*/ );
		virtual void slotFilterChanged( KomparatorFileFilter *filter, const QString &name, const QString &path,
			const QString &owner, const QString &group, const unsigned long &min_size, const unsigned long &max_size,
			const bool &consider_date, const QDate &date );

		// INTERNAL SLOTS
		virtual void slotSizeTypeChanged( int i );
		virtual void slotMD5ChecksumEnabled( bool e );
		virtual void slotSizeEnabled( bool e );
		virtual void slotEmptyFolder( KIO::Job *job, const KIO::UDSEntryList &list );
		virtual void slotEmptyFolderFinished( KIO::Job *job );
		virtual void slotProgress( QString str, int percent );
		virtual void slotProgressUndefined();
		virtual void slotSaveListViewColumnWidth();
		virtual void slotCount( LIST_VIEW list_view, int which, int visible_items ); // -1 visible_items means: calculate it.

	signals:
		void signalProgress( QString, int );
		void signalSaveListViewColumnWidth();
		void signalCount( LIST_VIEW, int, int );

	private:
		KQuery *m_query;
		STATUS m_status;
		FILE_REMOVE m_file_remove_action;
	
		KURL::List m_symlinked_directories;
	
		KPopupMenu *m_popup_menu;
	
		KFileItemExt *m_files;
		KFileItemExt *m_dirs_dupes;
	
		QStringList m_unreadable_files;
		uint m_number_of_files;
	
		int m_duplicates1_width[7];
		int m_duplicates2_width[8];
		int m_missing1_width[7];
		int m_missing2_width[7];
		int m_newer1_width[7];
		int m_newer2_width[7];
	
		QPtrList< KomparatorPreset > m_preset_list;
	
		QColor m_red, m_green, m_blue, m_purple;
	
		bool m_interaction_cancel;
		uint m_interaction_progress;
		QString m_interaction_progress_str;
		uint m_interaction_total;
		QPtrList< QListViewItem > m_interaction_copy_remaining_items;
		QPtrList< KFileItemExt > m_interaction_remove_remaining_items;
		KURL::List m_interaction_empty_dirs;

		void addWhatsThisHelp();
	
		void removeFirst();

		bool m_properties_renamed;
	
		void removeDeletedFromLists( KFileItemExt *item, bool duplicates_only = false );
		void checkEmptyDirs( KURL::List &urls );
	
		bool initializeQuery();
		bool isDateValid();
		void enable( bool e );
		void resizeListViewColumns();
		void updateFilters();
	
		QString prettyURL( const KURL &url, URL_MODE mode );
	
		KFileItemExt *m_requested_download;
		KIO::Job *m_requested_download_job;
	
		QTimer *m_progress_timer;
};

#endif
