/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kmainwindow.h>
#include <klocale.h>
#include <kfileitem.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <ksystemtray.h>
#include <kmessagebox.h>

#include <qstringlist.h>
#include <qfile.h>

#include <qtooltip.h>

#include "kompile.h"
#include "kompilewidget.h"


#include <stdlib.h>

Kompile::Kompile(QString &filename, const int operation, bool default_installation) : KMainWindow( 0, "Kompile" )
{
    QStringList tokens = QStringList::split(" ", filename);
    
    if (!setSourcesTarball(filename)) 
    {
        KMessageBox::error(this, "You have forgot to specify a valid sources tarball or specified file isn't a valid sources tarball!\nSpecify an existing and valid source tarball please.\nMaual selection of sources tarball and building options manual setup will be avaiable in future version.", "Sources archive missing");
        exit(-1);
    }
    
    if (default_installation) {
        if (operation == OPERATION_INSTALL)
            widget = new KompileWidget( tarball, FALSE, this );
        else
            widget = new KompileWidget( tarball, TRUE, this );

        setCentralWidget( widget );
    }
    
    setFixedWidth(400);
    setFixedHeight(220);

    setIcon(KGlobal::iconLoader()->loadIcon("kpackage", KIcon::MainToolbar));
    trayicon = new KSystemTray(this, "ecikontrolsystemtray");
    trayicon->setPixmap(KGlobal::iconLoader()->loadIcon("kpackage", KIcon::MainToolbar));
    setTrayiconTooltip("");
}

Kompile::~Kompile()
{
    delete widget;
    delete trayicon;
}

bool Kompile::setSourcesTarball(QString &filename) 
{
    QFile file(filename);

    if (file.exists() && (filename.endsWith(".gz") || filename.endsWith(".bz2") || filename.endsWith(".bz") || filename.endsWith(".tgz"))) {
        tarball = filename;
        return TRUE;
    }
    
    return FALSE;
    
}

QString Kompile::sourcesTarball() 
{
    return tarball;
}

void Kompile::startInstallation()
{
    widget->compileAndInstall();
}

bool Kompile::event(QEvent* e)
{
    if( (int)e->type() == QEvent::Hide) 
    {
   	trayicon->setInactive();
	trayicon->show();
    }
    else if( (int)e->type() == QEvent::Show) 
    {
	    trayicon->hide();
    } 
    if( (int)e->type() == QEvent::Close) 
    {
            widget->btnAbort_clicked();
    }
  
    return KMainWindow::event( e );
}

void Kompile::setTrayiconTooltip(QString message) {
    message.prepend("<b>Kompile</b><br><br>Installing " + tarball + "<br>");
    QToolTip::add( trayicon, message);
}
#include "kompile.moc"
