/***************************************************************************
 *   Copyright (C) 2005 by Tommaso Frazzetto   *
 *   tommaso.frazzetto@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KOMPILEWIDGET_H_
#define _KOMPILEWIDGET_H_

#include <kdialogbase.h>
#include <kprocess.h>

#include <qstringlist.h>
#include <qtimer.h>
#include <qdatetime.h>

#include "kompilewidgetbase.h"

class KompileWidget : public KompileWidgetBase
{
  Q_OBJECT
  KDialogBase * parent;
  QString tarball;
  KProcess * process;
  int status;
  bool do_uninstall;
  int installation_type;
  QString user_dir;
  QTimer * finish_timer;
  QTimer * kompile_timer;
  QTime installation_time;
  int operation_time;
  QString path;
  KConfig * profile;

  void decompress();
  void configure();
  void make();
  void install();
  void uninstall();

public:
  int seconds_left;
  KompileWidget(KConfig * profile, bool uninstall=FALSE, QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~KompileWidget();
  void compileAndInstall();
  bool removeSources();
  void searchInfoFiles();
  int getStatus();

public slots:
  virtual void btnDetails_clicked();
  virtual void processReadFromStdout( KProcess * proc, char * buffer, int buflen );
  virtual void btnAbout_clicked();
  virtual void btnAbort_clicked();
  virtual void processReadFromStderr( KProcess * proc, char * buffer, int buflen );
  virtual void processExited( KProcess * proc );
  virtual void autoclose_timeout();
  virtual void total_timeout();
  virtual void btnSuspend_clicked();
  virtual void btnShowChangelog_clicked();
  virtual void btnShowInstall_clicked();
  virtual void btnShowReadme_clicked();


protected slots:
  virtual void txtConsole_textChanged();

public:
  static const bool OPERATION_INSTALL = FALSE;
  static const bool OPERATION_UNINSTALL = TRUE;

  static const int STATUS_INITIALIZING = 0;
  static const int STATUS_DECOMPRESSING = 1;
  static const int STATUS_CONFIGURING = 2;
  static const int STATUS_BUILDINGING = 3;
  static const int STATUS_INSTALLING = 4;
  static const int STATUS_UNINSTALLING = 5;
  static const int STATUS_FINISHED = 6;
  static const int STATUS_ABORTED = 7;
  static const int STATUS_ERROR = 8;
};

#endif

