/**************************************************************************
*   Copyright (C) 2005 by Conrad Hoffmann                                 *
*   conrausch@gmx.de                                                      *
*   http://conrausch.doesntexist.org                                      *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/


#include <qlayout.h>
#include <qptrlist.h>
#include <qsize.h>
#include <qevent.h>
#include <qapplication.h>
#include <qdesktopwidget.h>

#include <kapplication.h>
#include <krootpixmap.h>
#include <ksharedpixmap.h>
#include <kwin.h>
#include <kdebug.h>

#include "kopetedesklistitem.h"
#include "kopetedesklistgroup.h"
#include "kopetedesklistrootwidget.h"
#include "kopetedesklistrootpixmap.h"
#include "kopete_desklist.h"


KopeteDesklistRootWidget::KopeteDesklistRootWidget( QWidget* parent, const char* name)
		: QWidget( parent, "desklist_root", Qt::WGroupLeader | Qt::WStyle_Customize | Qt::WStyle_NoBorder | Qt::WDestructiveClose )
{
	KRootPixmap* rootPixmap = new KRootPixmap( this );
	rootPixmap->start();

	m_rootLayout = new QVBoxLayout( this );
	m_rootLayout->setMargin( 10 );
	m_rootLayout->setSpacing( KopeteDesklistKcfg::contactBoxSpacing() );

	KWin::setState( winId(), NET::KeepBelow | NET::SkipTaskbar | NET::SkipPager );
	KWin::setOnAllDesktops( winId(), true );
	setFocusPolicy( QWidget::NoFocus );
}


KopeteDesklistRootWidget::~KopeteDesklistRootWidget()
{
}


void KopeteDesklistRootWidget::reposition()
{
	setMinimumSize( m_rootLayout->minimumSize() );
	resize( m_rootLayout->minimumSize().width(), m_rootLayout->minimumSize().height() );

	/* determine horizontal position */
	int x;
	if ( KopeteDesklistKcfg::listHGrowToRight() )
	{
		x = KopeteDesklistKcfg::referencePositionX();
	}
	else
	{
		x = QApplication::desktop()->width() - this->width() + KopeteDesklistKcfg::referencePositionX();
	}

	/* determine vertical position */
	int y;
	if ( KopeteDesklistKcfg::listVGrowToBottom() )
	{
		y = KopeteDesklistKcfg::referencePositionY();
	}
	else if ( KopeteDesklistKcfg::listVGrowToTop() )
	{
		y = QApplication::desktop()->height() - this->height() + KopeteDesklistKcfg::referencePositionY();
	}
	else
	{
		y = ( QApplication::desktop()->height() >> 1 ) - ( this->height() >> 1 ) + KopeteDesklistKcfg::referencePositionY();
	}

	move( x, y );
	lower();
}


QVBoxLayout* KopeteDesklistRootWidget::rootLayout()
{
	return m_rootLayout;
}


#include "kopetedesklistrootwidget.moc"
