/*
 * Copyright (C) 2006 Bernhard Beschow <bbeschow @ cs.tu-berlin.de>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */
#ifndef THINKLIGHTPLUGIN_H
#define THINKLIGHTPLUGIN_H

#include <kopete/kopeteplugin.h>

#include <qfile.h>
#include <qtimer.h>
#include <qprocess.h>

/**
 * @author Bernhard Beschow <bbeschow @ cs.tu-berlin.de>
 *
 * @short Kopete Thinklight Plugin.
 *
 * @todo really toggle thikpad light
 */
class ThinkLightPlugin : public Kopete::Plugin
{
	Q_OBJECT
public:
	ThinkLightPlugin( QObject *parent, const char *name, const QStringList &args );

protected slots:
	/**
	 * @short Starts flashing on Kopete::ChatSessionManager::aboutToReceive() events.
	 */
	void handleEvent();

	/**
	 * @short Toggles Thinkpad light on or off.
	 */
	void toggle();

	/**
	 * @short Re-read plugin configuration and immediately apply changes.
	 */
	void settingsChanged();

	/**
	 * @short Check if initialization script finished successfully.
	 */
	void initFinished();

private:
	QTimer m_timer;
	int m_toggles;

	uint m_msecs;
	uint m_numFlashes;

	QProcess m_initProcess;

	static ThinkLightPlugin *s_pPlugin;
};

#endif
