//              -*- mode: C++ -*-
// Copyright(C) 2005 Stefan Siegl <stesie@brokenpipe.de>
// kopete_silc - silc plugin for kopete messenger
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "silccontactmanager.h"
#include "silcaddcontactpage.h"
#include "silcaccount.h"

#include <kopeteaccount.h>

//layout
#include <qlayout.h>
#include <qcheckbox.h>
#include <qlineedit.h>

SilcAddContactPage::SilcAddContactPage(QWidget *parent, SilcAccount *account)
  : AddContactPage(parent)
{
  (void) account;

  (new QVBoxLayout(this))->setAutoAdd(true);
  this->silcAddContactUI = new silcAddContact(this);
}

SilcAddContactPage::~SilcAddContactPage()
{

}

bool 
SilcAddContactPage::apply(Kopete::Account *account, Kopete::MetaContact *m)
{ 
  SilcAccount *_account = (SilcAccount*)account;
  SilcContactManager *cm = _account->contactManager();

  if(this->silcAddContactUI->ischannel->isChecked()) {
     cm->createChannel(this->silcAddContactUI->addID->text(),m);
  } else {
     SilcBuddyContact *buddy;
     QString nick = this->silcAddContactUI->addID->text();
     QString finger = this->silcAddContactUI->fingerprint->text();
     if(not finger.isEmpty()) {
        //user provided a fingerprint
        buddy = new SilcBuddyContact(_account, nick, finger, m);
        cm->addBuddy(buddy);
        buddy->watchme(true);
     } else {
        cm->createBuddy(nick,m);
     }
     _account->sendSilcCommand(QString("WHOIS %1").arg(nick));
  }
  return true;
}

bool 
SilcAddContactPage::validateData(void)
{
	return true;
}

#include "silcaddcontactpage.moc"
