/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* pref.h
 */
#ifndef koverartist_pref_h
#define koverartist_pref_h

#include <kdialogbase.h>
#include <qframe.h>

class QCheckBox;
class QLineEdit;

class KoverArtistPrefGeneral;
class KoverArtistPrefCdDb;
class KoverArtistPrefDefaultProject;

namespace KoverArtist { class Settings; }


/** Preferences/setup dialog main class.
 */
class KoverArtistPreferences: public KDialogBase
{
   Q_OBJECT
public:
   KoverArtistPreferences();

public slots:
   /** Set preferences widgets from config. */
   void fromConfig(KoverArtist::Settings* = 0);

   /** Store preferences in config. */
   void toConfig();

   /** A standard dialog button was clicked (Ok/Apply/Default/...) */
   virtual void slotOk();
   virtual void slotApply();
   virtual void slotDefault();

private:
   KoverArtistPrefGeneral *mPgGen;
   KoverArtistPrefCdDb *mPgCdDb;
   KoverArtistPrefDefaultProject *mPgDefProj;
};


#endif /*koverartist_pref_h*/
