/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// prefcddb.cpp

#include "prefcddb.h"

#include "cddbchooser.h"
#include "settings.h"

#include <klocale.h>

#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>


KoverArtistPrefCdDb::KoverArtistPrefCdDb(QWidget *parent)
:QFrame(parent)
{
   QVBoxLayout *vbox = new QVBoxLayout(this, 8, 8);
   QGroupBox *grp;
   QPushButton *btn;
   QLabel *lbl;

   // CD-Drive
   grp = new QGroupBox(2, Qt::Horizontal, i18n("Audio-CD Device"), this);
   vbox->addWidget(grp, Qt::AlignLeft);

   lbl = new QLabel(i18n("Device")+": ", grp);
   lbl->setFixedSize(lbl->sizeHint());

   mEdtCdDrive = new QLineEdit(grp);
   mEdtCdDrive->setFixedHeight(mEdtCdDrive->sizeHint().height());

   vbox->addSpacing(16);

   // CDDB-Server
   grp = new QGroupBox(4, Qt::Horizontal, i18n("Server For CDDB Queries"), this);
   vbox->addWidget(grp, Qt::AlignLeft);

   lbl = new QLabel(i18n("CDDB-Server")+":", grp);
   lbl->setFixedSize(lbl->sizeHint());

   mEdtCddbServer = new QLineEdit(grp);
   mEdtCddbServer->setFixedHeight(mEdtCddbServer->sizeHint().height());

   lbl = new QLabel(i18n("Port")+":", grp);
   lbl->setFixedSize(lbl->sizeHint());

   mEdtCddbPort = new QLineEdit("99999", grp);
   mEdtCddbPort->setFixedSize(mEdtCddbPort->sizeHint());

   lbl = new QLabel(i18n("Mirrors")+":", grp);
   lbl->setFixedSize(lbl->sizeHint());

   btn = new QPushButton(i18n("Select a mirror..."), grp);
   connect(btn, SIGNAL(clicked()), this, SLOT(selectMirror()));
   btn->setFixedSize(btn->sizeHint());

   vbox->addSpacing(16);

   // Options
   mCbxAutoSetTitle = new QCheckBox(i18n("Set project title from CDDB information "
      "if the project title is empty."), this);
   mCbxAutoSetTitle->setFixedSize(mCbxAutoSetTitle->sizeHint());
   vbox->addWidget(mCbxAutoSetTitle, Qt::AlignLeft);

   vbox->addStretch(1000);
   vbox->activate();
}


void KoverArtistPrefCdDb::selectMirror()
{
   QStringList lst;
   lst.append("http://at.freedb.org");
   lst.append("http://au.freedb.org");
   lst.append("http://ca.freedb.org");
   lst.append("http://es.freedb.org");
   lst.append("http://fi.freedb.org");
   lst.append("http://fr.freedb.org");
   lst.append("http://jp.freedb.org");
   lst.append("http://jp2.freedb.org");
   lst.append("http://ru.freedb.org");
   lst.append("http://uk.freedb.org");
   lst.append("http://uk2.freedb.org");
   lst.append("http://us.freedb.org");

   CddbChooser dlg(lst, i18n("Select a CDDB Mirror"),
         i18n("Please select a CDDB mirror from\nthe list below:"), this);
   if (dlg.exec()!=QDialog::Accepted) return;

   QString srv = dlg.currentItem();
   
   if (!srv.isEmpty())
   {
      mEdtCddbServer->setText(srv);
      mEdtCddbPort->setText("80");
   }
}


#include "prefcddb.moc"
