;;;; -*- mode: lisp -*-
;;;;
;;;; $Id: run.lisp,v 1.1 2004/06/15 07:48:38 sven Exp $
;;;;
;;;; Code to run the server in development mode
;;;;
;;;; Copyright (C) 2004 Sven Van Caekenberghe, Beta Nine BVBA. All Rights Reserved.
;;;;
;;;; You are granted the rights to distribute and use this software
;;;; as governed by the terms of the Lisp Lesser GNU Public License
;;;; (http://opensource.franz.com/preamble.html), also known as the LLGPL.
;;;;

(in-package :kpax)

(export '(start-kpax))

(defun start-kpax (&key (server-class 'mod-lisp-server) (port 2001) (logstream *standard-output*))
  "Do init-kpax & run-kpax in debug mode with extra logging"
  (init-kpax server-class)
  (let ((server (run-kpax :debug-mode t :port port)))
    (setf (get-debug-stream server) logstream)
    server))

;;;; eof