//
// C++ Implementation: kpgdatatablesettings
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdatatablesettings.h"

#include <klocale.h>
#include <kconfig.h>
#include <kdebug.h>


#include <qframe.h>
#include <qcheckbox.h>
#include <qspinbox.h>

#include "kpgdatatablesettingspage.h"

#define CONF_ENTRY_NAME_CONFIRM_DEL_ROW "ConfirmDeleteRow"
#define DFLT_VALUE_CONFIRM_DEL_ROW true

#define CONF_ENTRY_NAME_LOB_BUFFER_SIZE "LOB_BufferSize"
#define DFLT_VALUE_LOB_BUFFER_SIZE 1

KPGDataTableSettings::KPGDataTableSettings( QObject * pParent, const char * pszName )
 : KPGSettings( "Datatable", pParent, pszName ),
   m_bConfirmDelRow( DFLT_VALUE_CONFIRM_DEL_ROW ),
   m_iLobBufferSize( DFLT_VALUE_LOB_BUFFER_SIZE ),
   m_pDialogPage(0)
{
}

KPGDataTableSettings::~KPGDataTableSettings()
{
}

void KPGDataTableSettings::write( KConfig * pConfig ) const
{
	pConfig->writeEntry( CONF_ENTRY_NAME_CONFIRM_DEL_ROW, m_bConfirmDelRow );
	pConfig->writeEntry( CONF_ENTRY_NAME_LOB_BUFFER_SIZE, m_iLobBufferSize );
}

void KPGDataTableSettings::read( const KConfig * pConfig )
{
	m_bConfirmDelRow = pConfig->readBoolEntry( CONF_ENTRY_NAME_CONFIRM_DEL_ROW, DFLT_VALUE_CONFIRM_DEL_ROW );
	m_iLobBufferSize = pConfig->readNumEntry( CONF_ENTRY_NAME_LOB_BUFFER_SIZE, DFLT_VALUE_LOB_BUFFER_SIZE );
}

QString KPGDataTableSettings::dialogPageName() const
{
  	return i18n( "Datatable" );
}

QString KPGDataTableSettings::dialogPageHeader() const
{
  	return i18n( "Datatable setting" );
}

QString KPGDataTableSettings::dialogPageIcon() const
{
  	return "data";
}


QWidget * KPGDataTableSettings::dialogPage( QFrame * pParent )
{
	if ( ! m_pDialogPage )
	{
		// create the page if necessary
		m_pDialogPage = new KPGDataTableSettingsPage( pParent, "datatable setting config.dialog page" );
	
		// and fill its widgets with the corresponding values
		updatePage();
	
		connect( m_pDialogPage->m_pCheckBoxConfirmDelRow, SIGNAL(toggled(bool)), this, SIGNAL(sigDialogPageChanged()) );
		connect( m_pDialogPage->m_pSpinBoxLobBufferSize, SIGNAL(valueChanged(int)), this, SIGNAL(sigDialogPageChanged()) );
	}
	
	return m_pDialogPage;
}

void KPGDataTableSettings::setFromPage()
{
	if ( m_pDialogPage )
	{
		m_bConfirmDelRow = m_pDialogPage->m_pCheckBoxConfirmDelRow->isChecked();
		m_iLobBufferSize = m_pDialogPage->m_pSpinBoxLobBufferSize->value();
	}
}

void KPGDataTableSettings::updatePage() const
{
	if ( m_pDialogPage )
	{
		m_pDialogPage->m_pCheckBoxConfirmDelRow->setChecked( m_bConfirmDelRow );
		m_pDialogPage->m_pSpinBoxLobBufferSize->setValue( m_iLobBufferSize );
	}
}


