//
// C++ Interface: kpgschema
//
// Description: 
//
//
// Author: Lumir Vanek <lvanek@users.sourceforge.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef KPGSCHEMA_H
#define KPGSCHEMA_H

#include "kpgobject.h"

/**
  * Forward references
  */
class KPGTablesFolder;
class KPGViewsFolder;
class KPGSequencesFolder;
class KPGFunctionsFolder;
class KPGOperatorsFolder;
class KPGOperatorClassesFolder;
class KPGAggregatesFolder;
class KPGDomainsFolder;
class KPGTypesFolder;
class KPGConversionsFolder;
class KPGSchemaPropPage;
class KPGDatabase;
class QTable;

/**
  * Database schema (aka namespace). A schema is essentially a namespace: 
  * it contains named objects (tables, data types, functions, and operators) 
  * whose names may duplicate those of other objects existing in other schemas. 
  * Named objects are accessed either by "qualifying" their names with the schema 
  * name as a prefix, or by setting a search path that includes the desired schema(s).
  * Unqualified objects are created in the current schema (the one at the front of 
  * the search path, which can be determined with the function current_schema). 
  *
  * @author Lumir Vanek
  */
class KPGSchema : public KPGObject
{
public:
    KPGSchema(KPGDatabase *, const QString, pqxx::oid);
	KPGSchema(KPGDatabase *, KPGSchema *, const QString, pqxx::oid);
    ~KPGSchema();
		
	virtual eNodeType type() const { return nodeSchema; }
	
	// Get SQL object type 
  	virtual const char * getObjectType() const { return "SCHEMA"; }
	
    virtual bool isSystemObject() const { return m_bIsSystemObject; }
	
	void setProperties(const pqxx::result::tuple &);
		
	// Refresh item, ald also childs objects
	void refresh() throw(const KPGSqlException &);
	
	// Refresh only this item, not childs
	void refreshItem() throw(const KPGSqlException &);
		    
	/*
	 * Functions for accessing nested folders
	 */
		  
    KPGTablesFolder * getTablesFolder() { return m_pFolderTables; }
    KPGViewsFolder * getViewsFolder() { return m_pFolderViews; }
    KPGSequencesFolder * getSequencesFolder() { return m_pFolderSequences; }
    KPGFunctionsFolder * getFunctionsFolder() { return m_pFolderFunctions; }
    KPGOperatorsFolder * getOperatorsFolder() { return m_pFolderOperators; }
    KPGOperatorClassesFolder * getOperatorClassesFolder() { return m_pFolderOperatorClasses; }
    KPGAggregatesFolder * getAggregatesFolder() { return m_pFolderAggregates; }
    KPGDomainsFolder * getDomainsFolder() { return m_pFolderDomains; }
    KPGTypesFolder * getTypesFolder() { return m_pFolderTypes;  }
    KPGConversionsFolder * getConversionsFolder() { return m_pFolderConversions; }
    
    /*
	 * Functions for accessing nested results
	 */
	 
    const pqxx::result & resultAggregates() const;
    const pqxx::result & resultConversions() const;
    const pqxx::result & resultDomains() const;
    const pqxx::result & resultFunctions() const;
    const pqxx::result & resultOperatorClasses() const;
    const pqxx::result & resultOperators() const;
    const pqxx::result & resultSequences() const;
    const pqxx::result & resultTables() const;
    const pqxx::result & resultTypes() const;
    const pqxx::result & resultViews() const;
    
    /*
	 * Functions for accessing properties
	 */
	 
    const QString & owner() const { return m_strOwner; }
    bool isLoaded() const { return m_bIsLoaded; }
    bool canCreate() const { return m_bCanCreate; }
    const QString & acl() const { return m_strACL; }
    
    void fillListOfObjectsForCodeCompletion(KPGOidNameList &);
    
protected:
	
  	virtual void activate();
    
protected:
	KPGTablesFolder *m_pFolderTables;
	KPGViewsFolder *m_pFolderViews;
	KPGSequencesFolder *m_pFolderSequences;
  	KPGFunctionsFolder *m_pFolderFunctions;
	KPGOperatorsFolder *m_pFolderOperators;
	KPGOperatorClassesFolder *m_pFolderOperatorClasses;
	KPGAggregatesFolder *m_pFolderAggregates;
	KPGDomainsFolder *m_pFolderDomains;
	KPGTypesFolder *m_pFolderTypes;	
	KPGConversionsFolder *m_pFolderConversions;

	/*
	 * Properties
	 */
	QString m_strOwner;
	bool m_bCanCreate;
	QString m_strACL;
  
	bool m_bIsSystemObject;
  	bool m_bIsLoaded;
};

#endif
