/***************************************************************************
                          kpgconnectdialog.h  -  description
                             -------------------
    begin                : So led 10 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPGCONNECTDIALOG_H
#define KPGCONNECTDIALOG_H

#include <qwidget.h>
#include <qstring.h>

#include <kpgconnectdialogbase.h>

/**Dialog for connecting to database
  *@author Lumir Vanek
  */

// forward references
class QString;

class KPGConnectDialog : public KPGConnectDialogBase
{
   Q_OBJECT
public: 
	KPGConnectDialog(QWidget *parent=0, const char *name=0);
	~KPGConnectDialog();

  QString		hostName() const { return m_strHostName; }
  QString		portNumber() const { return m_strPortNumber; }
  QString		databaseName() const { return m_strDatabaseName; }
  QString		userName() const { return m_strUserName; }
	QString		password() const { return m_strPassword; }
  
  
  void setHostName(const QString strHostName) { m_strHostName = strHostName; }
  void setPortNumber(const QString strPortNumber) { m_strPortNumber = strPortNumber; }
  void setUserName(const QString strUserName) { m_strUserName = strUserName; }
  void setDatabaseName(const QString strDatabaseName) { m_strDatabaseName = strDatabaseName; }
  
  void setGui();
      
protected:
  void toggleAcceptButton();

  // fired, when user press OK button
  virtual void accept();

protected slots:
		void slotContextChanged( const QString & );

    
protected:

  QString		m_strHostName;
  QString		m_strPortNumber;
  QString   m_strDatabaseName;
  QString		m_strUserName;
	QString		m_strPassword;
};

#endif
