/***************************************************************************
                          kpgsettings.cpp  -  description
                             -------------------
    begin                : Ne led 18 2004
    copyright            : (C) 2004 by Lumir Vanek
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpgsettings.h"

#include <kconfig.h>

KPGSettings::KPGSettings( const QString & strConfigGroup,  QObject * pParent, const char * pszName )
 : QObject( pParent, pszName ),
   m_bPageChanged( false ),
   m_strConfigGroup( strConfigGroup )
{
	connect( this, SIGNAL(sigDialogPageChanged()), this, SLOT(slotDialogPageChanged()) );
}

void KPGSettings::setConfigGroup( KConfig * pConfig ) const
{
	pConfig->setGroup( m_strConfigGroup );
}

void KPGSettings::store( KConfig * pConfig ) const
{
	setConfigGroup( pConfig );
	write( pConfig );
}

void KPGSettings::restore( KConfig * pConfig )
{
	setConfigGroup( pConfig );
	read( pConfig );

	// update the corresponding config.dialog page
	blockSignals( true ); // block this object's signals (especially sigDialogPageChanged)
	updatePage();
	blockSignals( false ); // unblock the signals

	emit sigChanged();
}

void KPGSettings::slotDialogPageChanged()
{
	m_bPageChanged = true;
}

void KPGSettings::apply()
{
	if ( m_bPageChanged )
	{
		setFromPage();
		m_bPageChanged = false;
		emit sigChanged();
	}
}
