/***************************************************************************
                          kpreglistbox.h  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright          : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPREGLISTBOX_H
#define KPREGLISTBOX_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qlabel.h>
#include <qstring.h>
#include <qlistbox.h>
#include <qclipboard.h>
#include <qpixmap.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qdir.h>
#include <qdom.h>
#include <qobject.h>
#include <qptrlist.h>
#include <qtabwidget.h>
#include <kapp.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <kpopupmenu.h>
#include <kclipboard.h>
#include <qdragobject.h>
#include "kpregitem.h"

class KpregItem;
/**
  *@author Huberto Gastal Mayer
  */

class KpregListBox : public QWidget
{
  Q_OBJECT
public:
	KpregListBox(QWidget *parent = 0, const char *name=0);
	~KpregListBox();
	void setParentWidgets ( QTabWidget * _qtw, KPopupMenu *_hierMenu );
	void atualizeViewCategory();
	void setNewItem (QDomDocument);
	void setNewItem (QDomNode);
	void setItens (QDomNode);
	void deleteItem ();
	void moveUp ();
	void moveDown ();
	QDomDocumentFragment save (QDomDocument);
	KpregItem* getCurrentItem ();
	void clearItens ();

	void setCategoryIcon (QString);
	QString getCategoryIcon ();
	void setCategoryLabel (QString);
	QString getCategoryLabel ();
	KPopupMenu * getSubMenu() { return subMenu; };
	void  setIcons (QPixmap *_blue, QPixmap *_yellow, QPixmap *_red);

public slots:
	void clicked_list_box (int item_int=-1);
	void clicked_sub_menu (int item_int=-1);
	void startDrag();

protected:
	virtual  void resizeEvent ( QResizeEvent * );

private:
	QPtrList<KpregItem> kpi_list;
	QListBox *qlb;
	QString *categoryLabel;
	QString *categoryIcon;
	QClipboard * qcb;
	QDomNode *itens;
	KPopupMenu *subMenu;
	QPixmap *blue_pm;
	QPixmap *red_pm;
	QPixmap *yellow_pm;
	QTabWidget *qtw;
	KPopupMenu *hierMenu;
};

#endif
