/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Seg Jul 30 00:39:14 EDT 2001
    copyright            : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kpreg.h"

static const char *description =
	I18N_NOOP("Kpreg\nKPreg is a helper application for completing web forms and other programs.\nIt provides an interface for entering commonly-required data,\nsuch as name, email, address, etc.\nWith a simple click of the mouse, any item in the text list is copied to the clipboard,\nand can then be easily pasted in any form or application.\nKPreg can dock in the panel for easy access.");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE


static KCmdLineOptions options[] =
{
  { "+[File]", I18N_NOOP("file to open"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

	KAboutData aboutData( "kpreg", I18N_NOOP("Kpreg"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2001, 2002, 2003, Huberto Gastal Mayer", 0, 0, "beto@debian-rs.org");
	aboutData.addAuthor("Huberto Gastal Mayer",0, "beto@debian-rs.org");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;

  if (app.isRestored())
  {
    RESTORE(KpregApp);
  }
  else
  {
    KpregApp *kpreg = new KpregApp();
    kpreg->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

		if (args->count())
		{
//        kpreg->openDocumentFile(args->arg(0));
		}
		else
		{
//		  kpreg->openDocumentFile();
		}
		args->clear();
  }

  return app.exec();
}
