/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "stationlistwidget.h"
#include <KXmlGuiWindow>

/** \brief The mainwindow.
*
* This class provides the mainwindow and handels the actions, session
* management, the global setting dialog, the <i>Tip of the day</i> and so on. */
class MainWindow : public KXmlGuiWindow
{

    Q_OBJECT

  public:
    /** The constructor.
    *
    * <ul>
    * <li>Constructs the central widget (see #m_streamlistwidget).</li>
    * <li>Sets up the actions.
    *     <ul>
    *     <li>Makes the actions availeble to the XML-GUI framework
    *         (See <tt>KXmlGuiWindow</tt> documentation).</li>
    *     <li>Makes the actions availeble in the context menu of the
    *         central widget (see stationlistWidget).</li>
    *     </ul></li>
    * <li>Set up the XML GUI.</li>
    * <li>Display <i>Tips of the Day</i> (if not disabled by the user).</li>
    * </ul> */
    MainWindow(QWidget *parent=0);
    /** The destructor. */
    virtual ~MainWindow();

  protected:
    /** TODO documentation! */
    virtual bool queryClose();
    /** TODO documentation! */
    virtual void readProperties(const KConfigGroup & m_configGroup);
    /** TODO documentation! */
    virtual void saveProperties(KConfigGroup & m_configGroup);

  private:
    /** A pointer to the central widget.
    *
    * The central widget is created in the constructor
    * of this class, and the constructor also sets
    * this pointer.
    *
    * To access the central widget, we could use
    * QMainWindow::centralWidget() and typecast to
    * stationlistWidget - but using this pointer,
    * we don't have to typecast all the time! */
    QPointer<stationlistWidget> m_streamlistwidget;

  private slots:
    /** Actualizes the bandwidth in the status bar. */
    void actualize_bandwidth_in_statusBar();
    /** Actualizes the number of active streams in the status bar. */
    void actualize_numberOfActiveStreams_in_statusBar();
    /** Displays the settings_general_dialog. */
    void display_global_settings_dialog();
    /** Displays the tip of the day (independently from if the user
    *   has disabled them or not). */
    void displayTipOfDay();
};

#endif
