/*
    Copyright (C) 2008-2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "stationdirectorytree.h"

#include <KDebug>
#include "streamdirectoryservice.h"

stationDirectoryTree::stationDirectoryTree(QWidget *parent, const QString & genreIconFileName)
  : QTreeWidget(parent)
{
  // variables
  QTreeWidgetItem *m_item;

  // code

  // appearance
  setColumnCount(3); // This MUST be done before adding items! TODO use a value that makes sense
  setVerticalScrollMode(QAbstractItemView::ScrollPerPixel);
  setHorizontalScrollMode(QAbstractItemView::ScrollPerPixel);
  setAnimated(true);
  setAlternatingRowColors(true);

  // scale icon size automatically
  m_item = new QTreeWidgetItem(this);
  setIconSize(QSize(32767, sizeHintForRow(0)));
  delete m_item;

  // internals
  genreIcon = KIcon(genreIconFileName);
};

stationDirectoryTree::~stationDirectoryTree()
{
}

void stationDirectoryTree::addStreamToWidget(streamDirectoryService *plugin,//TODO makethis const!?
                                             const QString & genre,
                                             const QString & streamName,
                                             const quint64 bitrate,
                                             const QString & currentlyPlaying)
{
  if (plugin) {
    // TODO
  };
}

void stationDirectoryTree::registerPlugin(streamDirectoryService *plugin)
{
  if (plugin) {
    plugin->setWidget(this);
  };
}

void stationDirectoryTree::removeAllStreamsOfThisService(const streamDirectoryService *plugin)
{
  if (plugin) {
    // TODO
  };
}
