/*
    Copyright (C) 2008-2009  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "streamdirectoryservice.h"

#include "stationdirectorytree.h"

streamDirectoryService::streamDirectoryService(QObject *parent) : QObject(parent)
{
  internal_enabled = true;
  fetchIsRunning = false;
}

streamDirectoryService::~streamDirectoryService()
{
  helper_stop();
}

void streamDirectoryService::addStreamToWidget(const QString & genre,
                                               const QString & streamName,
                                               const quint64 bitrate,
                                               const QString & currentlyPlaying)
{
  if (widget) {
    widget->addStreamToWidget(this, genre, streamName, bitrate, currentlyPlaying);
  };
}

bool streamDirectoryService::isEnabled() const
{
  return internal_enabled;
}

void streamDirectoryService::setEnabled(const bool value)
{
  if (internal_enabled != value) {
    internal_enabled = value;
    if (widget) {
      if (value) {
        helper_start();
      } else {
        helper_stop();
      };
    };
  };
}

void streamDirectoryService::setWidget(stationDirectoryTree *newWidget)
{
  if (widget != newWidget) {
    helper_stop();
    widget = newWidget;
    if (isEnabled() && widget) {
      helper_start();
    };
  };
}

void streamDirectoryService::helper_start()
{
  if (!fetchIsRunning) {
    fetchIsRunning = true;
    kickOffStreamFetch();
  };
}

void streamDirectoryService::helper_stop()
{
  if (fetchIsRunning) {
    fetchIsRunning = false;
    stopStreamFetch();
    if (widget) {
      widget->removeAllStreamsOfThisService(this);
    };
  };
}
