/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef GET_STREAMRIPPER_VERSION_H
#define GET_STREAMRIPPER_VERSION_H

#include "streamripper_base.h"
#include "propertyvalue.h"

/** \brief This class reads the version info from \e %streamripper.
*
*   It calls \e %streamripper with the parameter \e -v.
*   Just connect
*   to the signal vversionNumberDeterminated()
*   and than set the property #streamripperCommand. */
class get_streamripper_version : public streamripper_base
{

     Q_OBJECT

     /** This property holds the command for which this object will try to
     *   find out if it is \e %streamripper and, if yes which version number
     *   it has.
     *
     *
     * \li \e read: \code virtual QString streamripperCommand() const \endcode
     * \li \e write: \code virtual void setStreamripperCommand(const QString value) \endcode
     *     If you change the property, a new recognization will be started: the given
     *     command is invoked with the parameter <i>"-v"</i> (see parameterList()).
     *     This class only reads the very first line of the output produced
     *     when invoking the command.
     *     If it starts with <i>"Streamripper "</i>
     *     then the rest of the line is considered as version number and the signal
     *     versionNumberDeterminated(VersionNumber value) is emitted.
     *     After reading the first
     *     line of the output, the process is killed anyway (independent from if a version
     *     was recognized or not).
     *     If the process aborts without recognizing it as \e %streamripper (with a version
     *     number), than the signal is emitted with an empty value.
     *
     * \sa \code QString internal_streamripperCommand \endcode */
     Q_PROPERTY(QString streamripperCommand READ streamripperCommand WRITE setStreamripperCommand)

  public:
     //contructor(s) and destructor(s)
     /** Constructor of the class.
     * @param parent Sets the parent of this object. */
     get_streamripper_version(const QPointer<QObject> parent = 0);
     /** The destructor. */
     virtual ~get_streamripper_version();
     /** See property #streamripperCommand. */
     virtual QString streamripperCommand() const;

  public slots:
     /** See property #streamripperCommand. */
     virtual void setStreamripperCommand(const QString value);

  signals:
     /** This signal is emitted when
     *   \li \e %streamripper was recognized with a
     *   corresponding version number \e or
     *   \li if recognization was aborted without
     *   a result.
     *
     *   @param value the version number of type VersionNumber
     *   \sa #streamripperCommand */
     void versionNumberDeterminated(PropertyValue value);

  protected:
     /** Tries to recognize the version number.
     *   \sa #streamripperCommand */
     virtual void interpretate_console_output(QStringList & stringList);
     /** \return -v */
     virtual QStringList parameterList() const;
     /** Used internally to store the property #streamripperCommand. */
     QString internal_streamripperCommand;
     /** Used internally to store the information if we have still to
     *   emit the signal versionNumberDeterminated() or not. */
     bool stillSignalExpected;

  protected slots:
     /** Used internally to emit an empty versionNumberDeterminated() if
     *   the binary terminates running and so far nothing was recognized. */
     void binaryStateChange(QProcess::ProcessState newState);

};

#endif
