/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SETTINGS_GENERAL_DIALOG_H
#define SETTINGS_GENERAL_DIALOG_H

#include <KConfigDialog>

/** \brief This class provides a <tt>KConfigDialog</tt> for configuring KRadioRipper.
*
*   It uses settings_general_widget_general,
*   settings_general_widget_saving and
*   settings_general_widget_relayserver.
*   \sa settings_general */
class settings_general_dialog : public KConfigDialog
{

  Q_OBJECT

  public:
    /** The constructor.
        @param parent Pass a QWidget as parent - the dialog is centered to this widget.
        @param name Set a name for this object. You can read the name later using the
                    property "objectName" (class <tt>QObject</tt>) */
    settings_general_dialog(QWidget * parent, const QString name);
    virtual ~settings_general_dialog();
};

#endif
