/*
    Copyright (C) 2008  Tim Fechtner < urwald at users dot sourceforge dot net >

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of
    the License or (at your option) version 3 or any later version
    accepted by the membership of KDE e.V. (or its successor approved
    by the membership of KDE e.V.), which shall act as a proxy
    defined in Section 14 of version 3 of the license.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SETTINGS_GENERAL_WIDGET_GENERAL_H
#define SETTINGS_GENERAL_WIDGET_GENERAL_H

#include "ui_settings_general_widget_general.h"
#include "get_streamripper_version.h"

/** \brief Widget for the "general" options in the KRadioRipper configuration
*          (for use with a KConfigDialog).
*
* It uses the UI that is generated with Qt-Designer.
*
* \sa settings_general */
class settings_general_widget_general : public QWidget, private Ui::settings_general_widget_general
{

  Q_OBJECT

  public:
    /** The constructor. */
    settings_general_widget_general(QWidget *parent=0);
    /** The destructor. */
    virtual ~settings_general_widget_general();

  protected:
    get_streamripper_version versionInfo;

  protected slots:
    void displayVersionNumber(const PropertyValue & value);
};

#endif
