# norootforbuild
# This file is generated by the script set-version.sh.
# All changes you do to this file will be lost.

# The value of the following "name" tag will be set by set-version.sh to "kradioripper" for
# stable releases and to "kradioripper-unstable" for unstable releases.
Name:                         kradioripper  
Version:                      0.6  
%if 0%{?mandriva_version}
Release:                      %mkrel 0
%else
Release:                      0
%endif
# see http://fedoraproject.org/wiki/Packaging/LicensingGuidelines for details
# see http://fedoraproject.org/wiki/Licensing for details
# see http://en.opensuse.org/SUSE_Package_Conventions/RPM_Style#1.6._License_Tag for details
License:                      GPLv2, v3
%if 0%{?mandriva_version}
# see http://wiki.mandriva.com/en/Development/Packaging/Groups for details
Group:                        Sound
%else
# see http://en.opensuse.org/SUSE_Package_Conventions/RPM_Groups for details
Group:                        Productivity/Multimedia/Sound/Utilities
%endif
Summary:                      Recorder for Internet radios (based on Streamripper)
Summary(de.UTF-8):            Aufnahmeprogramm für Internetradios (basiert auf Streamripper)
Summary(cz.UTF-8):            Nahrávač internetových rádií (založený na Streamripperu)
Summary(pt_BR.UTF-8):         Gravador para rádios da internet (baseado no Streamripper)
URL:                          http://kradioripper.sourceforge.net/
Source0:                      %{name}-%{version}.tar.bz2
BuildRoot:                    %{_tmppath}/%{name}-%{version}-build
BuildRequires:                cmake >= 2.4

%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}
BuildRequires:                desktop-file-utils
%if 0%{?fedora_version}
%if 0%{?fedora_version} < 12
%define withoutlibproxy 1
%endif
%endif
%if! 0%{?withoutlibproxy:1}
# TODO or libproxy.so.0
BuildRequires:                libproxy-devel >= 0.3.1
BuildRequires:                libproxy >= 0.3.1
%if 0%{?opensuse_bs}
BuildRequires:                libproxy-webkit
%endif
# TODO or libproxy0-config-kde
Requires:                     libproxy-kde >= 0.3.1
%endif
BuildRequires:                kdelibs-devel
BuildRequires:                gcc-c++
%endif

%if 0%{?mandriva_version}
BuildRequires:                kdelibs4-devel
%if 0%{?mandriva_version} < 2010
%define withoutlibproxy 1
%else
# TODO or libproxy.so.0
BuildRequires:                libproxy-devel >= 0.3.1
BuildRequires:                libproxy >= 0.3.1
# TODO or libproxy0-config-kde
Requires:                     libproxy-kde >= 0.3.1
%endif
# The following lines are because the build service needs to know how to satisfy
# esound needed by lib64esound0: esound-daemon or pulseaudio-esound-compat...
%if 0%{?opensuse_bs}
BuildRequires:                pulseaudio-esound-compat
BuildRequires:                kde4-l10n-en_GB
BuildRequires:                free-kde4-config
BuildRequires:                phonon-gstreamer
BuildRequires:                mandriva-theme-Free
BuildRequires:                mandriva-theme-Free-screensaver
BuildRequires:                wget
BuildRequires:                kernel-desktop-2.6.27-0.rc8.2mnb
%endif
%endif

%if 0%{?suse_version}
BuildRequires:                update-desktop-files
%if 0%{?suse_version} < 1120
%define withoutlibproxy 1
%else
# TODO or libproxy.so.0
BuildRequires:                libproxy-devel  >= 0.3.1
BuildRequires:                libproxy0 >= 0.3.1
# TODO or libproxy0-config-kde
Requires:                     libproxy-kde >= 0.3.1
%endif
BuildRequires:                libkde4-devel
# Alternative: The macro %%kde4_runtime_requires defines
# not only a minimal version, but also a maximal version of KDE.
Requires:                     kdebase4-runtime >= %_kde_platform_version
%endif

# Fedora etc. doesn't support the tags "Recommends", "Suggests" and "Enhanches".
%if 0%{?suse_version} || 0%{?mandriva_version}
# Maybe you want to use "Requieres" or "Suggests" instead of "Recommends" if streamripper
# is avaible in your repository?
Recommends:                   streamripper >= 1.63
Enhances:                     streamripper
%endif

# This following "Conflicts" tag will be removed by set-version.sh,
# if it is a "kradioripper" release (and not a "kradioripper-unstable" release)...
  

%description
KRadioRipper is a program for recording Internet radios and other streams. For streams that
provide information about the song title, it can split the stream and create an own file for
each track - with a corresponding file name and corresponding metadata. KRadioRipper is based
on Streamripper and provides a well-arranged user interface for whose features. Like
Streamripper, it accepts MP3, AAC and OGG streams from Shoutcast-servers and Icecast-servers.

%description -l de.UTF-8
Ein Aufnahmeprogramm für Internetradios. Basiert auf StreamRipper.

%description -l cz.UTF-8
Program pro příjem internetových rádií. Založený na Streamripperu.

%description -l pt_BR.UTF-8
Um programa para ripar rádios da internet. Baseado no StreamRipper.



# The following section _must_ be immediatly befor the prep section.
# (see http://lists.opensuse.org/opensuse-packaging/2007-11/msg00000.html)
#
# To disable debug packages, we do:
%define debug_package %{nil}



%prep
# q means quiet. n sets the directory:
%setup -q -n kradioripper



%build
%if 0%{?withoutlibproxy:1}
%define cmake_parameters -DWITHOUT_LIBPROXY=YES
%endif
%cmake_kde4 %{?cmake_parameters}
# %%make_jobs would be an alternative, but it works only on openSUSE.
# I asume that there is no much difference.
%__make %{?jobs:-j %jobs}



%install
%if 0%{?suse_version}
%makeinstall
%suse_update_desktop_file kradioripper
%endif
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}
%makeinstall DESTDIR=%{buildroot}
desktop-file-install --delete-original --vendor fedora --dir=%{buildroot}/%{_datadir}/appli\
cations/kde4 %{buildroot}/%{_datadir}/applications/kde4/kradioripper.desktop
%endif
%if 0%{?mandriva_version}
cd build
%makeinstall DESTDIR=%{buildroot}
# Mandriva uses Portlands XDGs) desktop-file-install which does nothing than a simple (and
# incomplete) check. So we don't need it.
# desktop-file-install --dir %%{buildroot}/%%{_datadir}/applications/kde4\
# %%{buildroot}/%%{_datadir}/applications/kde4/kradioripper.desktop
%endif
# Using marcro of syntax "%%find_lang name [filelist]". Here, it searches for kradioripper.mo files
# and creates a list of these files with the respective %%doc and %%lang(LOCALE) marks. Because we
# leave "filelist" blank, the filelist is written to "kradioripper.lang". For details, see
# http://en.opensuse.org/Packaging/SUSE_Package_Conventions/RPM_Macros#3.8._.25find_lang
# So, finally "%%{_datadir}/locale/*/LC_MESSAGES/kradioripper.mo" is no longer needed in the
# "files" section.
%find_lang kradioripper
# fdupes searches for duplicate files. It will use hard links instead; this way, the size of the
# installed package is reduced. However, actually we don't need this and it is commented out. If
# we want to use it, we would have to add "BuildRequires: fdupes" above.
# %%fdupes $RPM_BUILD_ROOT
%if 0%{?suse_version}
%kde_post_install
%endif



%clean
rm -rf "%{buildroot}"



%files -f %{?mandriva_version:build/}kradioripper.lang
# leave file permissions "as is", but change owner and group to "root"...
%defattr(-,root,root)
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version}
%{_datadir}/applications/kde4/fedora-kradioripper.desktop
%else
%{_datadir}/applications/kde4/kradioripper.desktop
%endif
%{_bindir}/kradioripper
%if 0%{?fedora_version} || 0%{?rhel_version} || 0%{?centos_version} || 0%{?mandriva_version}
%{_datadir}/config.kcfg/*
%else
%{_datadir}/kde4/config.kcfg/*
%endif
%doc ABOUT COPYING LICENSE LICENSE.GPL2 LICENSE.GPL3 NEWS WARRANTY
%if 0%{?mandriva_version}
%dir %{_datadir}/apps/kradioripper
%{_datadir}/apps/kradioripper/*
%else
%dir %{_datadir}/kde4/apps/kradioripper
%{_datadir}/kde4/apps/kradioripper/*
%endif



%changelog
* Thu Sep 30 2009 Tim Fechtner 0.6
- using %%cmake_kde4 for Mandriva also
- initial support for libproxy (excluded for current distributions)
- better adaption for openSUSE builds
- qualifying the .mo files respectively
- adding ABOUT file
- new, more detailed description
- reducing maximal line size to 100 characters
- trailing whitespace removed
* Thu Mar 26 2009 Tim Fechtner 0.4.82
- localizations added (czech, brazilian portuguese, german)
* Thu Jan 20 2009 Tim Fechtner 0.4.50
- removed workarounds for Mandriva bugs in openSUSE build service
* Thu Dec 23 2008 Tim Fechtner 0.4.28
- disabling debug packages
* Wed Nov 26 2008 Tim Fechtner 0.4.8
- support for localization
- installing the hole _datadir/kde4/apps/kradioripper/* instead of single files
* Fri Nov 14 2008 Tim Fechtner 0.4.7
- recommanding streamripper at least in versio 1.63
* Thu Nov 11 2008 Tim Fechtner 0.4.4
- revolving ambigiously dependency for Mandriva explicitly when using openSUSE build service
* Wed Oct 08 2008 Tim Fechtner 0.4.2
- Integrated Mandriva support. Thanks to Bock & Busse System GbR: http://www.randosweb.de
* Sun Sep 14 2008 Tim Fechtner 0.3.0-1
- streamripper no longer requiered but only recommended
* Sat Sep 13 2008 Tim Fechtner 0.2.1-1
- ported to openSUSE build service
- support for Fedora 9
* Sat May 24 2008 Detlef Reichelt <detlef at links2linux de> 0.2.1-0.pm.1
- initial build for packman
