#!/bin/sh
# Generate a release-ready tarball
# Expects the version number as argument.
SCRIPTDIR=`pwd`
ROOTDIR="${SCRIPTDIR}/../src/qt-extensions/"


echo "Delete old apidoc"
rm -f -r ${ROOTDIR}/html/*
echo "Done deleting old apidoc"
echo "Making apidoc"
cd ${ROOTDIR} && doxygen
echo "Done making apidoc"
echo "Removing build files"
cd ${ROOTDIR}
find . -name '*~' > ${ROOTDIR}/files.list
xargs --arg-file=${ROOTDIR}/files.list rm
rm -f ${ROOTDIR}/files.list
echo "Done removing build files"
echo "Creating archive"
# removing yet existing files of the same name
cd ${SCRIPTDIR}/../.. && rm -f ./qt-extensions-$1.tar && rm -f ./qt-extensions-$1.tar.bz2
cd ${ROOTDIR}/../
tar -cf ${SCRIPTDIR}/../../qt-extensions-$1.tar qt-extensions
cd ${SCRIPTDIR}/../..
bzip2 ./qt-extensions-$1.tar
cd ${SCRIPTDIR}/../.. && rm -f ./qt-extensions-$1.tar
echo "Done creating archive"
